/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.cache.CacheWriter;
import com.gemstone.gemfire.cache.CacheWriterException;
import com.gemstone.gemfire.cache.EntryEvent;
import com.gemstone.gemfire.cache.RegionEvent;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.pivotal.gemfirexd.callbacks.Event;
import com.pivotal.gemfirexd.callbacks.EventCallback;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.EventImpl;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import java.sql.SQLException;

public class GfxdCacheWriter
implements CacheWriter<Object, Object> {
    private final EventCallback ecb;

    public GfxdCacheWriter(EventCallback ecb) {
        this.ecb = ecb;
    }

    public void beforeCreate(EntryEvent<Object, Object> event) throws CacheWriterException {
        GfxdCacheWriter.callEventCallbackOnEvent((EntryEventImpl)event, this.ecb, Event.Type.BEFORE_INSERT);
    }

    public void beforeDestroy(EntryEvent<Object, Object> event) throws CacheWriterException {
        GfxdCacheWriter.callEventCallbackOnEvent((EntryEventImpl)event, this.ecb, Event.Type.BEFORE_DELETE);
    }

    public void beforeRegionClear(RegionEvent<Object, Object> event) throws CacheWriterException {
    }

    public void beforeRegionDestroy(RegionEvent<Object, Object> event) throws CacheWriterException {
    }

    public void beforeUpdate(EntryEvent<Object, Object> event) throws CacheWriterException {
        EntryEventImpl ev = (EntryEventImpl)event;
        if (ev.hasDelta()) {
            GfxdCacheWriter.callEventCallbackOnEvent(ev, this.ecb, Event.Type.BEFORE_UPDATE);
        } else {
            GfxdCacheWriter.callEventCallbackOnEvent(ev, this.ecb, Event.Type.BEFORE_INSERT);
        }
    }

    public void close() {
        try {
            this.ecb.close();
        }
        catch (SQLException e) {
            Misc.getCacheLogWriter().warning("exception encountered while calling EventCallback.close", (Throwable)e);
        }
    }

    public static void callEventCallbackOnEvent(EntryEventImpl event, EventCallback ecb, Event.Type type) throws CacheWriterException {
        GfxdCallbackArgument callbackArg = (GfxdCallbackArgument)event.getCallbackArgument();
        if (callbackArg != null && callbackArg.isSkipListeners()) {
            return;
        }
        EventImpl cbevent = new EventImpl(event, type);
        try {
            ecb.onEvent(cbevent);
        }
        catch (SQLException e) {
            throw GemFireXDRuntimeException.newRuntimeException("GfxdCacheWriter#callEventCallbackOnEvent: unexpected exception", e);
        }
    }

    public String toString() {
        return String.valueOf(this.ecb);
    }
}

