/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.ddl;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.cache.CacheLoader;
import com.gemstone.gemfire.cache.CacheLoaderException;
import com.gemstone.gemfire.cache.Declarable;
import com.gemstone.gemfire.cache.EntryNotFoundException;
import com.gemstone.gemfire.cache.LoaderHelper;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.cache.execute.Function;
import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.cache.execute.InternalFunctionInvocationTargetException;
import com.pivotal.gemfirexd.callbacks.RowLoader;
import com.pivotal.gemfirexd.internal.engine.GfxdDataSerializable;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.FunctionExecutionException;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RegionKey;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Properties;

public class GfxdCacheLoader
implements CacheLoader<Object, Object> {
    private int[] pkIndexes = null;
    private RowLoader gfxdLdr = null;
    private String schemaName = null;
    private String tableName = null;
    private ColumnDescriptorList columnDescriptorList = null;
    private int numberOfColumns = -1;

    public GfxdCacheLoader(String schemaName, String tableName, RowLoader gfxdLdr) {
        this.schemaName = schemaName;
        this.tableName = tableName;
        this.gfxdLdr = gfxdLdr;
    }

    public RowLoader getRowLoader() {
        return this.gfxdLdr;
    }

    public Object load(LoaderHelper<Object, Object> helper) throws CacheLoaderException {
        RegionKey primaryKey = null;
        try {
            GemFireContainer gfcontainer;
            Object value;
            primaryKey = (RegionKey)helper.getKey();
            Object[] columnValues = new Object[this.numberOfColumns];
            Object[] primaryKeyAsJavaObjectArray = new Object[primaryKey.nCols()];
            primaryKey.getKeyColumns(primaryKeyAsJavaObjectArray);
            for (int index = 0; index < primaryKeyAsJavaObjectArray.length; ++index) {
                columnValues[this.pkIndexes[index] - 1] = primaryKeyAsJavaObjectArray[index];
            }
            Object row = this.gfxdLdr.getRow(this.schemaName, this.tableName, primaryKeyAsJavaObjectArray);
            if (row != null && (value = (gfcontainer = (GemFireContainer)helper.getRegion().getUserAttribute()).makeValueAsPerStorage(row)) != null) {
                return value;
            }
        }
        catch (Throwable t) {
            if (GemFireXDUtils.retryToBeDone(t)) {
                throw new InternalFunctionInvocationTargetException(t);
            }
            throw new CacheLoaderException("exception while loading a row", t);
        }
        throw new EntryNotFoundException("no value obtained for key: " + primaryKey + " from row loader");
    }

    public void close() {
    }

    public void setTableDetails(TableDescriptor td) throws StandardException {
        if (td == null) {
            return;
        }
        this.columnDescriptorList = td.getColumnDescriptorList();
        this.numberOfColumns = this.columnDescriptorList.size();
        this.pkIndexes = GemFireXDUtils.getPrimaryKeyColumns(td);
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String toString() {
        return String.valueOf(this.gfxdLdr);
    }

    public static final class GetRowFunctionArgs
    extends GfxdDataSerializable {
        private String schema;
        private String table;
        private Object key;

        public GetRowFunctionArgs() {
        }

        public GetRowFunctionArgs(String schemaName, String tableName, Object gfKey) {
            this.schema = schemaName;
            this.table = tableName;
            this.key = gfKey;
        }

        @Override
        public byte getGfxdID() {
            return 89;
        }

        public String getTableName() {
            return this.table;
        }

        public String getSchemaName() {
            return this.schema;
        }

        public Object getKey() {
            return this.key;
        }

        @Override
        public void toData(DataOutput out) throws IOException {
            super.toData(out);
            DataSerializer.writeString((String)this.schema, (DataOutput)out);
            DataSerializer.writeString((String)this.table, (DataOutput)out);
            DataSerializer.writeObject((Object)this.key, (DataOutput)out);
        }

        @Override
        public void fromData(DataInput in) throws IOException, ClassNotFoundException {
            super.fromData(in);
            this.schema = DataSerializer.readString((DataInput)in);
            this.table = DataSerializer.readString((DataInput)in);
            this.key = DataSerializer.readObject((DataInput)in);
        }
    }

    public static final class GetRowFunction
    implements Function,
    Declarable {
        public static final String ID = "gfxd-GetRowFunction";

        public void init(Properties props) {
        }

        private GfxdCacheLoader getRowLoaderFromRegion(Region<?, ?> region) {
            CacheLoader ldr = region.getAttributes().getCacheLoader();
            if (ldr instanceof GfxdCacheLoader) {
                return (GfxdCacheLoader)ldr;
            }
            throw new IllegalStateException("Expected a GfxdCacheLoader in region: " + region.getName());
        }

        public void execute(FunctionContext context) {
            GetRowFunctionArgs args = (GetRowFunctionArgs)context.getArguments();
            String tableName = args.getTableName();
            String schemaName = args.getSchemaName();
            LocalRegion region = (LocalRegion)Misc.getRegion(Misc.getRegionPath(schemaName, tableName, null), true, false);
            GemFireContainer gfcontainer = (GemFireContainer)region.getUserAttribute();
            GfxdCacheLoader ldr = this.getRowLoaderFromRegion((Region<?, ?>)region);
            RowLoader rowLdr = ldr.getRowLoader();
            RegionKey key = (RegionKey)args.getKey();
            if (region.keyRequiresRegionContext()) {
                key.setRegionContext(region);
            }
            Object[] pkdarr = new Object[key.nCols()];
            try {
                key.getKeyColumns(pkdarr);
                Object row = rowLdr.getRow(schemaName, tableName, pkdarr);
                Object value = gfcontainer.makeValueAsPerStorage(row);
                context.getResultSender().lastResult((Object)((Serializable)value));
            }
            catch (Exception e) {
                throw new FunctionExecutionException(e);
            }
        }

        public String getId() {
            return ID;
        }

        public boolean hasResult() {
            return true;
        }

        public boolean optimizeForWrite() {
            return true;
        }

        public boolean isHA() {
            return false;
        }
    }
}

