/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.wan.GatewayReceiver;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.ReceiverCreateOperation;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public final class ReceiverDropOperation
extends MemOperation {
    private final String id;
    private ServerGroupsTableAttribute serverGroups;
    private final boolean onlyIfExists;

    public ReceiverDropOperation(String id, ServerGroupsTableAttribute serverGroups, boolean onlyIfExists) {
        super(null);
        this.id = id;
        this.serverGroups = serverGroups;
        this.onlyIfExists = onlyIfExists;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        block9: {
            int rowsDeleted;
            DataValueDescriptor groups;
            GemFireTransaction tc = (GemFireTransaction)xact;
            LanguageConnectionContext lcc = tc.getLanguageConnectionContext();
            DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
            dd.startWriting(lcc);
            ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
            TabInfoImpl ti = dd.getNonCoreTI(23);
            keyRow.setColumn(1, new SQLVarchar(this.id));
            ExecRow row = ti.getRow(tc, keyRow, 0);
            if (row != null && (groups = row.getColumn(5)) != null) {
                this.serverGroups = new ServerGroupsTableAttribute();
                this.serverGroups.addServerGroups(SharedUtils.toSortedSet((String)groups.getString(), (boolean)false));
            }
            if ((rowsDeleted = ti.deleteRow(tc, keyRow, 0)) == 0) {
                if (this.onlyIfExists) {
                    return;
                }
                throw StandardException.newException("42Y55", (Object)"DROP GATEWAYRECEIVER", (Object)this.id);
            }
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("DropGatewayReceiver:: removed GatewayReceiver " + this.id + " from SYS table"));
            try {
                GemFireCacheImpl cache = Misc.getGemFireCache();
                try {
                    GatewayReceiver receiver = cache.getGatewayReceiver(this.id);
                    if (receiver != null) {
                        cache.removeGatewayReceiver(receiver);
                        receiver.stop();
                    }
                }
                catch (Exception ex) {
                    if (this.onlyIfExists) {
                        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"DropGatewayReceiver:: got Exception", (Throwable)ex);
                        break block9;
                    }
                    throw StandardException.newException("X0Z22.S", ex, (Object)this.id, (Object)ex.toString());
                }
            }
            catch (Exception e) {
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)"DropGatewayReceiver:: got Exception", (Throwable)e);
            }
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        GatewayReceiver receiver;
        try {
            GemFireCacheImpl cache = Misc.getGemFireCache();
            receiver = cache.getGatewayReceiver(this.id);
        }
        catch (Exception e) {
            receiver = null;
        }
        if (receiver != null) {
            return new ReceiverCreateOperation(receiver, this.serverGroups);
        }
        return null;
    }
}

