/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.internal.util.ArrayUtils;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndex;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.TxnCommitAbortIndexAction;
import com.pivotal.gemfirexd.internal.engine.access.operations.TxnIndexCommitAbortOperations;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;

public abstract class MemIndexOperation
extends MemOperation
implements TxnIndexCommitAbortOperations {
    static final int ROWLOCATION_THRESHOLD = 100;
    protected final Object key;
    protected RowLocation row;
    protected IndexKeyAndRegionKey conflationKey;
    public static final Object TOK_INDEX_KEY_DEL = new Object();

    protected MemIndexOperation(GemFireContainer container, Object key, RowLocation value) {
        super(container);
        this.key = key;
        this.row = value;
    }

    @Override
    public final boolean doAtCommitOrAbort() {
        return false;
    }

    @Override
    public boolean isIndexMemOperation() {
        return true;
    }

    public boolean isTransactionalOperation() {
        return false;
    }

    @Override
    public TxnCommitAbortIndexAction getCommitAbortAction() {
        return null;
    }

    @Override
    public final Object getKeyToConflate() {
        if (this.conflationKey == null) {
            this.conflationKey = new IndexKeyAndRegionKey(this.key, this.row != null ? this.row.getKey() : null);
        }
        return this.conflationKey;
    }

    @Override
    public final Object getValueToConflate() {
        return this.row;
    }

    protected static void dumpIndex(GemFireContainer container, String marker) {
        ((MemIndex)container.getConglomerate()).dumpIndex("Unknown Data type in index");
    }

    static final class IndexKeyAndRegionKey
    implements Comparable<IndexKeyAndRegionKey> {
        private final Object indexKey;
        private final Object regionKey;

        IndexKeyAndRegionKey(Object indexKey, Object regionKey) {
            this.indexKey = indexKey;
            this.regionKey = regionKey;
        }

        @Override
        public int compareTo(IndexKeyAndRegionKey other) {
            int res = GemFireXDUtils.compareKeys(this.indexKey, other.indexKey);
            if (res != 0) {
                return res;
            }
            return GemFireXDUtils.compareKeys(this.regionKey, other.regionKey);
        }

        public boolean equals(Object other) {
            if (other instanceof IndexKeyAndRegionKey) {
                IndexKeyAndRegionKey otherKey = (IndexKeyAndRegionKey)other;
                return ArrayUtils.objectEquals((Object)this.indexKey, (Object)otherKey.indexKey) && ArrayUtils.objectEquals((Object)this.regionKey, (Object)otherKey.regionKey);
            }
            return false;
        }
    }
}

