/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemInsertOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import java.io.IOException;

public final class MemDeleteOperation
extends MemOperation {
    private final Object key;
    private final Object callbackArg;
    private final boolean isPkBased;
    private final boolean isEvict;
    private Object currentValue;

    public MemDeleteOperation(GemFireContainer container, Object regionKey, Object callbackArg, boolean isPkBased, boolean isEvict) {
        super(container);
        this.key = regionKey;
        this.callbackArg = callbackArg;
        this.isPkBased = isPkBased;
        this.isEvict = isEvict;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        this.currentValue = this.memcontainer.delete(this.key, this.callbackArg, this.isPkBased, null, null, GemFireTransaction.getLanguageConnectionContext((GemFireTransaction)xact), this.isEvict);
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        if (this.memcontainer.getRegion().getDataPolicy().withPartitioning()) {
            throw new UnsupportedOperationException("cannot undo partitioned table delete since PR#destroy does not provide old value");
        }
        return new MemInsertOperation(this.memcontainer, null, this.key, this.currentValue, false);
    }

    @Override
    public boolean shouldBeConflated() {
        return true;
    }

    @Override
    public Object getKeyToConflate() {
        return this.key;
    }

    public Object getOldValue() {
        return this.currentValue;
    }
}

