/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.hdfs.HDFSStore;
import com.gemstone.gemfire.cache.hdfs.HDFSStoreFactory;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreFactoryImpl;
import com.gemstone.gemfire.cache.hdfs.internal.HDFSStoreImpl;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.operations.HDFSStoreDropOperation;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdHDFSStoreDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.IOException;

public class HDFSStoreCreateOperation
extends MemOperation {
    private final HDFSStoreFactory hsf;
    private final String storeName;

    public HDFSStoreCreateOperation(HDFSStoreFactory hsf, String storeName) {
        super(null);
        this.hsf = hsf;
        this.storeName = storeName;
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        GemFireTransaction tc = (GemFireTransaction)xact;
        LanguageConnectionContext lcc = tc.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        dd.startWriting(lcc);
        HDFSStoreImpl hsi = Misc.getGemFireCache().findHDFSStore(this.storeName);
        if (hsi != null) {
            throw StandardException.newException("X0Y68.S", (Object)"HDFSSTORE", (Object)this.storeName);
        }
        try {
            UUIDFactory factory = dd.getUUIDFactory();
            UUID id = factory.recreateUUID(this.storeName);
            GfxdHDFSStoreDescriptor hsd = new GfxdHDFSStoreDescriptor(dd, id, ((HDFSStoreFactoryImpl)this.hsf).getConfigView());
            dd.addDescriptor(hsd, null, 24, false, tc);
            if (!ServerGroupUtils.isDataStore()) {
                SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Skipping create hdfsstore for " + this.storeName + " on JVM of kind " + GemFireXDUtils.getMyVMKind()));
                return;
            }
            HDFSStore hs = this.hsf.create(this.storeName);
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("CreateHDFSStoreNode: added hdfsstore configuration for " + this.storeName + " in SYS table"));
        }
        catch (Throwable t) {
            throw StandardException.newException("X0Z30.S", t, (Object)t.getMessage());
        }
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        return new HDFSStoreDropOperation(this.storeName);
    }
}

