/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.operations;

import com.gemstone.gemfire.cache.RegionDestroyedException;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.operations.MemOperation;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import java.io.IOException;

public final class ContainerDropOperation
extends MemOperation {
    private final ContainerKey containerKey;
    private final boolean ignoreRegionDestroyed;
    private boolean isNoOp;

    public ContainerDropOperation(ContainerKey containerId, boolean ignoreRegionDestroyed) {
        super(null);
        this.containerKey = containerId;
        this.ignoreRegionDestroyed = ignoreRegionDestroyed;
        this.memcontainer = Misc.getMemStore().getContainer(this.containerKey);
    }

    @Override
    public void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        if (!this.isNoOp) {
            if (this.ignoreRegionDestroyed) {
                try {
                    ContainerDropOperation.doMe(xact, this.containerKey);
                }
                catch (RegionDestroyedException ex) {
                    if (GemFireXDUtils.TraceConglom) {
                        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("ContainerDropOperation#doMe: got ignorable RegionDestroyedException for container " + this.memcontainer + ": " + ex.toString()));
                    }
                }
            } else {
                ContainerDropOperation.doMe(xact, this.containerKey);
            }
        }
    }

    public static void doMe(Transaction xact, ContainerKey containerKey) throws StandardException {
        Misc.getMemStore().dropConglomerate(xact, containerKey);
    }

    @Override
    public boolean doAtCommitOrAbort() {
        return this.memcontainer == null || this.memcontainer.getBaseId() != null;
    }

    @Override
    public Compensation generateUndo(Transaction xact, LimitObjectInput in) throws StandardException, IOException {
        if (this.memcontainer == null || this.memcontainer.getBaseId() != null) {
            this.isNoOp = true;
            return null;
        }
        throw new UnsupportedOperationException("ContainerDropOperation: undo unimplemented; require GFE region rename support");
    }

    @Override
    public boolean shouldBeConflated() {
        return this.memcontainer != null;
    }

    @Override
    protected StringBuilder toStringBuilder(StringBuilder sb, String regionName) {
        return super.toStringBuilder(sb, regionName).append(" containerKey=").append(this.containerKey).append(" ignoreRegionDestroyed=").append(this.ignoreRegionDestroyed).append(" isNoOp=").append(this.isNoOp);
    }
}

