/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.internal.concurrent.ConcurrentSkipListMap;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexCostController;
import com.pivotal.gemfirexd.internal.engine.access.index.OpenMemIndex;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostResult;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public class SortedMap2IndexCostController
extends MemIndexCostController {
    private ConcurrentSkipListMap<Object, Object> skipListMap;
    private double locatingCost;
    private long numBaseRows;
    private static final double HASH_JOIN_COST_FACTOR = 10.0;

    @Override
    protected void postInit() throws StandardException {
        this.skipListMap = this.open_conglom.getGemFireContainer().getSkipListMap();
        this.num_rows = this.skipListMap.size();
        this.numBaseRows = this.open_conglom.isUnique() ? this.num_rows : this.open_conglom.getBaseContainer().getNumRows();
        this.row_size = this.open_conglom.getBaseContainer().getRowSize();
        if (this.num_rows < 1L) {
            this.num_rows = 1L;
        }
        if (this.numBaseRows < 1L) {
            this.numBaseRows = 1L;
        }
        if (this.row_size < 1L) {
            this.row_size = 1L;
        }
        this.locatingCost = this.treeHeight(this.num_rows) * 0.12;
    }

    private double treeHeight(long numRows) {
        if (numRows < 3L) {
            return 1.0;
        }
        return Math.log(numRows) / Math.log(2.0);
    }

    @Override
    public double getFetchFromFullKeyCost(FormatableBitSet validColumns, int access_type, CostEstimate costEstimate) throws StandardException {
        int numIndexedColumns;
        int[] pkCols;
        GemFireContainer indexContainer = this.open_conglom.getGemFireContainer();
        double cardinality = this.getCardinality() / 1.1;
        if (cardinality < 1.0) {
            cardinality = 1.1;
        }
        double pruneFactor = 1.0;
        if (indexContainer.getExtraIndexInfo() != null && (pkCols = indexContainer.getExtraIndexInfo().getPrimaryKeyColumns()) != null && (numIndexedColumns = pkCols.length) > 1) {
            pruneFactor = 1.0 / (1.0 + (double)numIndexedColumns * 1.0 / (double)this.open_conglom.getBaseContainer().getNumColumns());
        }
        double cost = (cardinality *= pruneFactor) * (double)this.row_size * 0.004;
        cost = access_type != 1 ? (cost += this.locatingCost) : (cost += this.locatingCost * (double)this.numBaseRows * 10.0);
        if (costEstimate != null) {
            costEstimate.setCost(cost, cardinality, cardinality);
        }
        return cost;
    }

    @Override
    public void getScanCost(int scan_type, long row_count, int group_size, boolean forUpdate, FormatableBitSet scanColumnList, DataValueDescriptor[] template, DataValueDescriptor[] startKeyValue, int startSearchOperator, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, boolean reopen_scan, int access_type, StoreCostResult cost_result) throws StandardException {
        GemFireXDQueryObserver sqo;
        double cost = 0.0;
        long rowCount = 0L;
        boolean costEstimationDone = false;
        double pruneFactor = 1.0;
        boolean fromInclusive = startSearchOperator == 1;
        boolean toInclusive = stopSearchOperator == -1;
        int numColsInIndex = this.open_conglom.getGemFireContainer().numColumns();
        GemFireContainer indexContainer = this.open_conglom.getGemFireContainer();
        if (startKeyValue == null && stopKeyValue == null) {
            if (scan_type == 1) {
                rowCount = row_count < 0L ? this.numBaseRows : row_count;
                cost += (double)rowCount * (double)this.row_size * 0.004;
                cost += (double)rowCount * 0.14 * 10.0;
                cost *= this.treeHeight(rowCount) + 2.0;
                costEstimationDone = true;
            } else if (access_type == 1) {
                cost += this.locatingCost;
                rowCount = 1L;
            } else {
                cost += this.locatingCost;
                if (access_type == 0) {
                    rowCount = this.num_rows;
                    pruneFactor = 1.3;
                } else {
                    rowCount = this.num_rows;
                    pruneFactor = access_type == 3 ? 0.1 : 0.6;
                }
            }
        } else if (startKeyValue == null && stopKeyValue != null) {
            cost += this.locatingCost;
            rowCount = this.skipListMap.headMap(OpenMemIndex.newLocalKeyObject(stopKeyValue, indexContainer), toInclusive).size();
        } else if (startKeyValue != null && stopKeyValue == null) {
            cost += this.locatingCost;
            rowCount = this.skipListMap.tailMap(OpenMemIndex.newLocalKeyObject(startKeyValue, indexContainer), fromInclusive).size();
        } else if (startKeyValue != null && stopKeyValue != null) {
            cost += this.locatingCost;
            rowCount = this.skipListMap.subMap(OpenMemIndex.newLocalKeyObject(startKeyValue, indexContainer), fromInclusive, OpenMemIndex.newLocalKeyObject(stopKeyValue, indexContainer), toInclusive).size();
        }
        if (!costEstimationDone) {
            int usefulCols;
            double numIndexKeys = rowCount;
            double cardinality = this.getCardinality();
            int n = usefulCols = startKeyValue != null ? startKeyValue.length : 0;
            if (stopKeyValue != null && stopKeyValue.length > usefulCols) {
                usefulCols = stopKeyValue.length;
            }
            if (usefulCols > 1) {
                pruneFactor /= 1.0 + (double)usefulCols * 1.0 / (double)this.open_conglom.getBaseContainer().getNumColumns();
            }
            if ((rowCount = (long)((double)rowCount * (cardinality * pruneFactor))) < 1L) {
                rowCount = 1L;
            }
            if (access_type == 0 && startKeyValue == null && stopKeyValue == null) {
                rowCount += 5L;
            }
            cost += (double)(rowCount * this.row_size) * 0.004;
            if (scan_type == 1) {
                cost += (double)rowCount * 0.14 * 10.0;
                cost *= this.treeHeight(this.numBaseRows) + 2.0;
            } else {
                cost += (double)rowCount * 0.12;
            }
        }
        if ((sqo = GemFireXDQueryObserverHolder.getInstance()) != null) {
            cost = sqo.overrideDerbyOptimizerIndexUsageCostForSortedIndexScan(this.open_conglom, cost);
        }
        cost_result.setEstimatedCost(cost);
        cost_result.setEstimatedRowCount(rowCount);
    }

    @Override
    public final double getCardinality() {
        double cardinality;
        double d = cardinality = this.num_rows > 0L ? (double)this.numBaseRows / (double)this.num_rows : 0.0;
        if (cardinality >= 1.0) {
            return cardinality;
        }
        return 1.0;
    }
}

