/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.MemIndexController;
import com.pivotal.gemfirexd.internal.engine.access.operations.SortedMap2IndexInsertOperation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import java.io.Serializable;

final class SortedMap2IndexController
extends MemIndexController {
    SortedMap2IndexController() {
    }

    @Override
    public int getType() {
        return 3;
    }

    public String toString() {
        return "SortedMap2IndexController, conglom: " + this.open_conglom;
    }

    @Override
    protected int doInsert(DataValueDescriptor[] row) throws StandardException {
        Serializable key = this.open_conglom.getKey(row, true, true);
        RowLocation rowLocation = this.open_conglom.getValue(row);
        assert (rowLocation != DataValueFactory.DUMMY);
        try {
            GemFireTransaction tran = this.open_conglom.getTransaction();
            LanguageConnectionContext lcc = tran.getLanguageConnectionContext();
            boolean skipConstraintChecks = lcc != null && lcc.isSkipConstraintChecks();
            GemFireContainer container = this.open_conglom.getGemFireContainer();
            SortedMap2IndexInsertOperation.doMe(tran, container.getActiveTXState(tran), container, key, rowLocation, this.open_conglom.isUnique(), null, false, skipConstraintChecks);
        }
        catch (StandardException se) {
            if ("23505".equals(se.getMessageId()) && !this.open_conglom.getBaseContainer().isApplicationTableOrGlobalIndex()) {
                return 1;
            }
            throw se;
        }
        return 0;
    }
}

