/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.index;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.GemFireException;
import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.EntryEventImpl;
import com.gemstone.gemfire.internal.cache.EventID;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.offheap.OffHeapHelper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.index.AbstractRowLocation;
import com.pivotal.gemfirexd.internal.engine.ddl.resolver.GfxdPartitionResolver;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdCallbackArgument;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public final class GlobalRowLocation
extends AbstractRowLocation
implements Serializable {
    private static final long serialVersionUID = -8962822593640959063L;
    private int entryHash;
    private int routingObject;

    public GlobalRowLocation() {
    }

    public GlobalRowLocation(int hash, int routingObject) {
        this.entryHash = hash;
        this.routingObject = routingObject;
    }

    @Override
    public GlobalRowLocation getClone() {
        return new GlobalRowLocation(this.entryHash, this.routingObject);
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new GlobalRowLocation();
    }

    public int hashCode() {
        return this.entryHash ^ this.routingObject;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GlobalRowLocation)) {
            return false;
        }
        GlobalRowLocation other = (GlobalRowLocation)obj;
        return this.entryHash == other.entryHash && this.routingObject == other.routingObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GlobalRowLocation getRowLocation(RowLocation rl, ExecRow insertingRow, GemFireContainer baseContainer, EntryEventImpl event, boolean isPrimaryKeyConstraint) throws StandardException {
        GlobalRowLocation retval;
        block15: {
            int entryHash;
            block14: {
                Object callbackArg;
                assert (rl != null);
                assert (baseContainer.isPartitioned());
                PartitionedRegion region = (PartitionedRegion)baseContainer.getRegion();
                GfxdPartitionResolver partitionResolver = (GfxdPartitionResolver)region.getPartitionResolver();
                Object key = rl.getKeyCopy();
                entryHash = GlobalRowLocation.getEntryHash(event, isPrimaryKeyConstraint, key);
                if (partitionResolver == null) break block14;
                Object resolveKey = null;
                if (event != null && (callbackArg = event.getCallbackArgument()) != null) {
                    if (callbackArg instanceof GfxdCallbackArgument) {
                        GfxdCallbackArgument sca = (GfxdCallbackArgument)callbackArg;
                        if (sca.isRoutingObjectSet()) {
                            resolveKey = sca.getRoutingObject();
                        }
                    } else {
                        resolveKey = callbackArg;
                    }
                }
                if (resolveKey == null) {
                    Object value = null;
                    try {
                        if (rl.isDestroyedOrRemoved()) {
                            assert (insertingRow != null) : "The row to be inserted is null?";
                            value = insertingRow instanceof AbstractCompactExecRow ? ((AbstractCompactExecRow)insertingRow).getRawRowValue(false) : insertingRow.getRowArray();
                        } else {
                            value = rl.getValue(baseContainer);
                        }
                        try {
                            resolveKey = partitionResolver.getRoutingObject(key, value, (Region<?, ?>)region);
                        }
                        catch (GemFireException gfeex) {
                            throw Misc.processGemFireException(gfeex, gfeex, "lookup of global index for key " + key, true);
                        }
                    }
                    catch (Throwable throwable) {
                        OffHeapHelper.release(value);
                        throw throwable;
                    }
                    OffHeapHelper.release((Object)value);
                }
                retval = new GlobalRowLocation(entryHash, (Integer)resolveKey);
                break block15;
            }
            retval = new GlobalRowLocation(entryHash, entryHash);
        }
        return retval;
    }

    public static int getEntryHash(EntryEventImpl event, boolean isPrimaryKeyConstraint, Object regionKey) {
        int entryHash;
        EventID eventId;
        if (event != null && isPrimaryKeyConstraint && (eventId = event.getEventId()) != null) {
            entryHash = 0;
            entryHash = ResolverUtils.addBytesToHash((byte[])eventId.getMembershipID(), (int)entryHash);
            entryHash = ResolverUtils.addLongToHash((long)eventId.getThreadID(), (int)entryHash);
            entryHash = ResolverUtils.addLongToHash((long)eventId.getSequenceID(), (int)entryHash);
        } else {
            entryHash = regionKey.hashCode();
        }
        return entryHash;
    }

    @Override
    public Object getKey() {
        return null;
    }

    @Override
    public Serializable getRoutingObject() {
        return Integer.valueOf(this.routingObject);
    }

    @Override
    public GlobalRowLocation cloneObject() {
        return new GlobalRowLocation(this.entryHash, this.routingObject);
    }

    public String toString() {
        return "GlobalRowLocation: rowHash=" + this.entryHash + " routingObject=" + this.routingObject;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.entryHash = in.readInt();
        this.routingObject = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.entryHash);
        out.writeInt(this.routingObject);
    }

    @Override
    public int getDSFID() {
        return -18;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        DataSerializer.writePrimitiveInt((int)this.entryHash, (DataOutput)out);
        out.writeInt(this.routingObject);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.entryHash = DataSerializer.readPrimitiveInt((DataInput)in);
        this.routingObject = in.readInt();
    }

    @Override
    public void setValue(DataValueDescriptor theValue) {
        assert (theValue instanceof GlobalRowLocation);
        GlobalRowLocation rowLoc = (GlobalRowLocation)theValue;
        this.entryHash = rowLoc.entryHash;
        this.routingObject = rowLoc.routingObject;
    }

    @Override
    public int estimateMemoryUsage() {
        return 8 + ClassSize.refSize;
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) {
        return this.estimateMemoryUsage();
    }
}

