/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine.access.heap;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerateController;
import com.pivotal.gemfirexd.internal.engine.access.MemScanController;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapController;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapCostController;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.ConglomerateUtil;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.GenericConglomerate;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public final class MemHeap
extends GenericConglomerate
implements MemConglomerate {
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(MemHeap.class);
    private static final int CONTAINER_KEY_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(ContainerKey.class);
    protected ContainerKey id;
    protected GemFireContainer container;
    int[] format_ids;

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.id) {
            sz += CONTAINER_KEY_MEMORY_USAGE;
        }
        if (null != this.format_ids) {
            sz += this.format_ids.length * ClassSize.getIntSize();
        }
        return sz;
    }

    @Override
    public void create(GemFireTransaction tran, int segmentId, long containerId, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int tmpFlag) throws StandardException {
        if ((tmpFlag & 1) != 1 && containerId < 0L) {
            throw StandardException.newException("XSCH0.S");
        }
        if (template == null || template.length == 0) {
            throw StandardException.newException("XSCH4.S");
        }
        this.format_ids = ConglomerateUtil.createFormatIds(template);
        properties.put("GEMFIRE_TEMPLATE_ROW", template);
        this.id = ContainerKey.valueOf(segmentId, containerId);
    }

    @Override
    public boolean requiresContainer() {
        return true;
    }

    @Override
    public void addColumn(TransactionManager xactManager, int column_id, Storable template_column, int collation_id) throws StandardException {
    }

    @Override
    public void drop(TransactionManager xactManager) throws StandardException {
        xactManager.getRawStoreXact().dropContainer(this.id);
    }

    @Override
    public boolean fetchMaxOnBTree(TransactionManager xactManager, Transaction rawtran, long conglomId, int openMode, int lockLevel, LockingPolicy locking, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] fetchRow) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    @Override
    public ContainerKey getId() {
        return this.id;
    }

    @Override
    public long getContainerid() {
        return this.id.getContainerId();
    }

    @Override
    public GemFireContainer getGemFireContainer() {
        return this.container;
    }

    @Override
    public void setGemFireContainer(GemFireContainer container) {
        this.container = container;
    }

    @Override
    public int getType() {
        return 0;
    }

    public LocalRegion getRegion() {
        return this.getGemFireContainer().getRegion();
    }

    @Override
    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo() throws StandardException {
        throw new UnsupportedOperationException("not expected to be called");
    }

    @Override
    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(TransactionController tc, long conglomId) throws StandardException {
        return this;
    }

    @Override
    public boolean isTemporary() {
        return this.id.getSegmentId() == -1L;
    }

    @Override
    public long load(TransactionManager xactManager, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    @Override
    public MemConglomerateController open(TransactionManager xactManager, Transaction rawtran, boolean hold, int openMode, int lockLevel, LockingPolicy locking, StaticCompiledOpenConglomInfo staticInfo, DynamicCompiledOpenConglomInfo dynamicInfo) throws StandardException {
        return this.open((GemFireTransaction)xactManager, openMode, lockLevel, locking);
    }

    @Override
    public MemConglomerateController open(GemFireTransaction tran, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        MemHeapController cc = new MemHeapController();
        cc.init(tran, this, openMode, lockLevel, locking);
        return cc;
    }

    @Override
    public MemScanController openScan(TransactionManager xactManager, Transaction rawtran, boolean hold, int openMode, int lockLevel, LockingPolicy locking, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo staticInfo, DynamicCompiledOpenConglomInfo dynamicInfo) throws StandardException {
        return this.openScan(xactManager, rawtran, hold, openMode, lockLevel, locking, isolation_level, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, staticInfo, dynamicInfo, null);
    }

    @Override
    public MemScanController openScan(TransactionManager xactManager, Transaction rawtran, boolean hold, int openMode, int lockLevel, LockingPolicy locking, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo staticInfo, DynamicCompiledOpenConglomInfo dynamicInfo, Activation act) throws StandardException {
        if (!RowUtil.isRowEmpty(startKeyValue) || !RowUtil.isRowEmpty(stopKeyValue)) {
            throw StandardException.newException("XSCH8.S");
        }
        GemFireTransaction tran = (GemFireTransaction)xactManager;
        MemHeapScanController sc = new MemHeapScanController();
        sc.init(tran, this, openMode, lockLevel, null, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator, act);
        return sc;
    }

    @Override
    public boolean openContainer(GemFireTransaction tran, int openMode, int lockLevel, LockingPolicy locking) throws StandardException {
        if (this.isTemporary()) {
            openMode |= 0x800;
        }
        return this.container.open(tran, openMode);
    }

    @Override
    public void purgeConglomerate(TransactionManager xactManager, Transaction rawtran) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    @Override
    public void compressConglomerate(TransactionManager xactManager, Transaction rawtran) throws StandardException {
    }

    @Override
    public MemScanController defragmentConglomerate(TransactionManager xactManager, Transaction rawtran, boolean hold, int openMode, int lockLevel, LockingPolicy locking, int isolation_level) throws StandardException {
        return null;
    }

    @Override
    public StoreCostController openStoreCost(TransactionManager xactManager, Transaction rawtran) throws StandardException {
        GemFireTransaction tran = (GemFireTransaction)xactManager;
        MemHeapCostController cc = new MemHeapCostController();
        cc.init(tran, this, 8, 0, null);
        return cc;
    }

    public String toString() {
        return this.id == null ? "null" : this.id.toString() + ' ' + this.container;
    }

    @Override
    public DataValueDescriptor getConglom() {
        return this;
    }

    @Override
    public int getTypeFormatId() {
        return 91;
    }

    @Override
    public boolean isNull() {
        return this.id == null;
    }

    @Override
    public void restoreToNull() {
        this.id = null;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        FormatIdUtil.writeFormatIdInteger(out, this.getTypeFormatId());
        out.writeInt((int)this.id.getSegmentId());
        out.writeLong(this.id.getContainerId());
        out.writeInt(this.format_ids.length);
        ConglomerateUtil.writeFormatIdArray(this.format_ids, out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        FormatIdUtil.readFormatIdInteger(in);
        int segmentid = in.readInt();
        long containerid = in.readLong();
        this.id = ContainerKey.valueOf(segmentid, containerid);
        int num_columns = in.readInt();
        this.format_ids = ConglomerateUtil.readFormatIdArray(num_columns, in);
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        FormatIdUtil.readFormatIdInteger(in);
        int segmentid = in.readInt();
        long containerid = in.readLong();
        this.id = ContainerKey.valueOf(segmentid, containerid);
        int num_columns = in.readInt();
        this.format_ids = ConglomerateUtil.readFormatIdArray(num_columns, in);
    }
}

