/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.gemfire.internal.process.signal.Signal;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.misc.SignalHandler;

public class SigThreadDumpHandler
implements SignalHandler {
    private static final SigThreadDumpHandler instance = new SigThreadDumpHandler();
    private final Map<Signal, SignalHandler> oldHandlers = Collections.synchronizedMap(new HashMap());

    private SigThreadDumpHandler() {
        ArrayList<String> ignoredSignals = new ArrayList<String>(){
            {
                this.add("WINCH");
                this.add("CHLD");
                this.add("CONT");
                this.add("CLD");
                this.add("BUS");
                this.add("USR1");
                this.add("USR2");
            }
        };
        this.mergeIgnoredSignalsFromProps((List<String>)ignoredSignals);
        if (!ignoredSignals.contains("*")) {
            for (Signal signal : Signal.values) {
                if (ignoredSignals.contains(signal.getName())) continue;
                try {
                    sun.misc.Signal osSignal = new sun.misc.Signal(signal.getName());
                    this.oldHandlers.put(signal, sun.misc.Signal.handle(osSignal, this));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private List<String> mergeIgnoredSignalsFromProps(List<String> ignored) {
        String sigsIgnored = PropertyUtil.getSystemProperty("gemfirexd.signals.notlogged");
        if (sigsIgnored != null) {
            for (String s : sigsIgnored.split(",")) {
                if ((s = s.trim().toUpperCase()).equals("*")) {
                    ignored.clear();
                    ignored.add("*");
                    break;
                }
                ignored.add(s);
            }
        }
        return ignored;
    }

    public static SigThreadDumpHandler install() {
        return instance;
    }

    @Override
    public void handle(sun.misc.Signal sig) {
        try {
            GemFireStore memStore = GemFireStore.getBootingInstance();
            Signal signal = Signal.valueOfName((String)sig.getName());
            if (Signal.SIGURG.equals((Object)signal)) {
                String header = "SIGURG received, full state dump";
                GemFireXDUtils.dumpStacks(memStore, "SIGURG received, full state dump");
            } else {
                SanityManager.DEBUG_PRINT((String)"warning:SignalHandler", (String)("received explicit OS signal SIG" + sig.getName()), (Throwable)new Throwable());
            }
            SignalHandler oldHandler = this.oldHandlers.get(signal);
            if (oldHandler != null && oldHandler != SIG_DFL && oldHandler != SIG_IGN) {
                oldHandler.handle(sig);
            }
        }
        catch (Throwable t) {
            System.err.println("SigThreadDumpHandler failed to dump to log for SIG" + sig.getName() + ": " + SanityManager.getStackTrace((Throwable)t));
        }
    }
}

