/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.gemfire.cache.DiskAccessException;
import com.gemstone.gemfire.internal.InternalDataSerializer;
import com.gemstone.gemfire.internal.LocalLogWriter;
import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.gemstone.gemfire.internal.i18n.LocalizedStrings;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeDataInputStream;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import java.io.DataInput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class OplogIndexReader {
    public static final byte INDEXID_RECORD = 1;
    public static final byte INDEX_RECORD = 2;
    public static final byte INDEX_END_OF_FILE = 3;
    public static final byte[] INDEX_END_OF_FILE_MAGIC = new byte[]{3, -55, -17, -38, -70, 37, 113, 59, 31, 75, -119, 43, -111, -31, 107, -2};

    public static void init() {
    }

    public static void main(String[] args) throws StandardException {
        HashMap<String, ArrayList<ColumnDescriptor>> descriptorMap = new HashMap<String, ArrayList<ColumnDescriptor>>();
        for (int i = 1; i < args.length; ++i) {
            int size;
            String[] parts;
            DataTypeDescriptor columnType;
            boolean nullable;
            String[] columnParts = args[i].split(":");
            String tableName = columnParts[0];
            ArrayList<ColumnDescriptor> descriptors = (ArrayList<ColumnDescriptor>)descriptorMap.get(tableName);
            if (descriptors == null) {
                descriptors = new ArrayList<ColumnDescriptor>();
                descriptorMap.put(tableName, descriptors);
            }
            String columnName = columnParts[1];
            String columnTypeName = columnParts[2].trim().toLowerCase();
            boolean bl = nullable = columnParts.length <= 3 || Boolean.parseBoolean(columnParts[3]);
            if (columnTypeName.equals("int")) {
                columnType = DataTypeDescriptor.getBuiltInDataTypeDescriptor(4, nullable);
            } else if (columnTypeName.equals("bigint") || columnTypeName.equals("long")) {
                columnType = DataTypeDescriptor.getBuiltInDataTypeDescriptor(-5, nullable);
            } else if (columnTypeName.startsWith("varchar")) {
                parts = columnTypeName.split("\\(|\\)");
                size = Integer.parseInt(parts[1].trim());
                columnType = DataTypeDescriptor.getBuiltInDataTypeDescriptor(12, nullable, size);
            } else if (columnTypeName.startsWith("char")) {
                parts = columnTypeName.split("\\(|\\)");
                size = Integer.parseInt(parts[1].trim());
                columnType = DataTypeDescriptor.getBuiltInDataTypeDescriptor(1, nullable, size);
            } else if (columnTypeName.equals("double")) {
                columnType = DataTypeDescriptor.getBuiltInDataTypeDescriptor(8, nullable);
            } else if (columnTypeName.startsWith("decimal") || columnTypeName.startsWith("numeric")) {
                parts = columnTypeName.split("\\(|\\)|,");
                int precision = Integer.parseInt(parts[1].trim());
                int scale = Integer.parseInt(parts[2].trim());
                int maximumWidth = scale > 0 ? precision + 3 : precision + 1;
                columnType = new DataTypeDescriptor(TypeId.getBuiltInTypeId(columnTypeName.charAt(0) == 'd' ? 3 : 2), precision, scale, nullable, maximumWidth);
            } else {
                throw new IllegalArgumentException("unsupported type = " + columnParts[2]);
            }
            descriptors.add(new ColumnDescriptor(columnName, i, columnType, null, null, null, null, 0L, 0L, false));
        }
        System.out.println("DescriptorMap: " + descriptorMap);
        OplogIndexReader.readIndex(args[0], descriptorMap);
    }

    public static void readIndex(String fileName, Map<String, ArrayList<ColumnDescriptor>> descriptorMap) throws StandardException {
        try {
            boolean logFinerEnabled;
            RowFormatter currentFormatter = null;
            LocalLogWriter logger = new LocalLogWriter(500);
            boolean logEnabled = DiskStoreImpl.INDEX_LOAD_DEBUG || logger.fineEnabled();
            boolean bl = logFinerEnabled = DiskStoreImpl.INDEX_LOAD_DEBUG_FINER || logger.finerEnabled();
            if (logEnabled || DiskStoreImpl.INDEX_LOAD_PERF_DEBUG) {
                logger.info(LocalizedStrings.DEBUG, (Object)("OplogIndex#readIndex: for " + fileName));
            }
            RandomAccessFile raf = new RandomAccessFile(fileName, "r");
            FileChannel channel = raf.getChannel();
            ChannelBufferUnsafeDataInputStream in = new ChannelBufferUnsafeDataInputStream((ReadableByteChannel)channel);
            boolean endOfFile = false;
            block7: while (!endOfFile) {
                int opCode = in.read();
                switch (opCode) {
                    case 3: {
                        if (logEnabled) {
                            logger.info(LocalizedStrings.DEBUG, (Object)("OplogIndex#readIndex: read end 0f file record for " + fileName));
                        }
                        byte[] data = new byte[INDEX_END_OF_FILE_MAGIC.length];
                        data[0] = 3;
                        in.readFully(data, 1, INDEX_END_OF_FILE_MAGIC.length - 1);
                        if (Arrays.equals(data, INDEX_END_OF_FILE_MAGIC)) continue block7;
                        throw new DiskAccessException("Did not find end of file magic at the end of index " + fileName, "LOCAL_READ");
                    }
                    case 1: {
                        String currentIndexID;
                        String indexName;
                        ArrayList<ColumnDescriptor> descriptors;
                        if (logEnabled) {
                            logger.info(LocalizedStrings.DEBUG, (Object)"Reading an indexId record");
                        }
                        currentFormatter = (descriptors = descriptorMap.get(indexName = (currentIndexID = InternalDataSerializer.readString((DataInput)in)).split(":")[0])) != null ? new RowFormatter(descriptors.toArray(new ColumnDescriptor[descriptors.size()]), descriptors.size(), 1, null, true) : null;
                        if (!logEnabled) continue block7;
                        logger.info(LocalizedStrings.DEBUG, (Object)("OplogIndex#readIndex: read indexUUID=" + currentIndexID));
                        continue block7;
                    }
                    case 2: {
                        if (logEnabled) {
                            logger.info(LocalizedStrings.DEBUG, (Object)"Reading an index record");
                        }
                        byte[] indexKeyBytes = InternalDataSerializer.readByteArray((DataInput)in);
                        int numRegionKeys = (int)InternalDataSerializer.readUnsignedVL((DataInput)in);
                        if (logFinerEnabled) {
                            logger.info(LocalizedStrings.DEBUG, (Object)("Read index bytes " + Arrays.toString(indexKeyBytes) + ", numRegionKeys=" + numRegionKeys));
                        } else if (logEnabled && currentFormatter != null) {
                            for (int i = 1; i <= currentFormatter.getNumColumns(); ++i) {
                                logger.info(LocalizedStrings.DEBUG, (Object)("    column" + i + '=' + currentFormatter.getColumn(i, indexKeyBytes)));
                            }
                        }
                        long regionEntryKeyId = 0L;
                        for (int i = 0; i < numRegionKeys; ++i) {
                            if (i == 0) {
                                regionEntryKeyId = InternalDataSerializer.readUnsignedVL((DataInput)in);
                                if (!logFinerEnabled) continue;
                                logger.info(LocalizedStrings.DEBUG, (Object)("    read regionEntryId=" + regionEntryKeyId));
                                continue;
                            }
                            long deltaKeyId = InternalDataSerializer.readUnsignedVL((DataInput)in);
                            regionEntryKeyId += deltaKeyId;
                            if (!logFinerEnabled) continue;
                            logger.info(LocalizedStrings.DEBUG, (Object)("    read deltaKeyId=" + deltaKeyId + " regionEntryKeyId=" + regionEntryKeyId));
                        }
                        if (!logEnabled) continue block7;
                        logger.info(LocalizedStrings.DEBUG, (Object)("Read an index key with " + numRegionKeys + " region entries"));
                        continue block7;
                    }
                }
                if (opCode < 0) {
                    endOfFile = true;
                    continue;
                }
                throw new IOException("unexpected opCode=" + opCode + " encountered while reading file: " + fileName);
            }
            in.close();
            raf.close();
            if (logEnabled || DiskStoreImpl.INDEX_LOAD_PERF_DEBUG) {
                logger.info(LocalizedStrings.DEBUG, (Object)("OplogIndex#readIndex: Processed file: " + fileName));
            }
        }
        catch (IOException ioe) {
            throw new DiskAccessException((Throwable)ioe);
        }
    }
}

