/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.gemfire.cache.execute.FunctionException;
import com.gemstone.gemfire.cache.execute.ResultCollector;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableHashtable;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.vti.VTICosting;
import com.pivotal.gemfirexd.internal.vti.VTIEnvironment;
import com.pivotal.gemfirexd.internal.vti.VTITemplate;
import java.sql.SQLException;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public abstract class GfxdVTITemplate
extends VTITemplate
implements VTICosting {
    protected boolean wasNull;
    protected FormatableHashtable compileTimeConstants;

    public void setSharedState(FormatableHashtable compiledState) {
        this.compileTimeConstants = compiledState;
    }

    @Override
    public String getString(int columnNumber) throws SQLException {
        Object res = this.getObject(columnNumber);
        return res != null ? res.toString() : null;
    }

    @Override
    public final Object getObject(int columnNumber) throws SQLException {
        Object res = this.getObjectForColumn(columnNumber);
        this.wasNull = res == null;
        return res;
    }

    @Override
    public boolean getBoolean(int columnNumber) throws SQLException {
        Object v = this.getObject(columnNumber);
        if (v != null) {
            if (v instanceof Boolean) {
                return (Boolean)v;
            }
            return super.getBoolean(columnNumber);
        }
        return false;
    }

    @Override
    public int getInt(int columnNumber) throws SQLException {
        Object v = this.getObject(columnNumber);
        if (v != null) {
            if (v instanceof Boolean) {
                return (Boolean)v != false ? 1 : 0;
            }
            if (v instanceof Number) {
                return ((Number)v).intValue();
            }
            return super.getInt(columnNumber);
        }
        return 0;
    }

    @Override
    public long getLong(int columnNumber) throws SQLException {
        Object v = this.getObject(columnNumber);
        if (v != null) {
            if (v instanceof Boolean) {
                return (Boolean)v != false ? 1L : 0L;
            }
            if (v instanceof Number) {
                return ((Number)v).longValue();
            }
            return super.getLong(columnNumber);
        }
        return 0L;
    }

    @Override
    public double getDouble(int columnNumber) throws SQLException {
        Object v = this.getObject(columnNumber);
        if (v != null) {
            if (v instanceof Boolean) {
                return (Boolean)v != false ? 1.0 : 0.0;
            }
            if (v instanceof Number) {
                return ((Number)v).doubleValue();
            }
            return super.getDouble(columnNumber);
        }
        return 0.0;
    }

    @Override
    public float getFloat(int columnNumber) throws SQLException {
        Object v = this.getObject(columnNumber);
        if (v != null) {
            if (v instanceof Boolean) {
                return (Boolean)v != false ? 1.0f : 0.0f;
            }
            if (v instanceof Number) {
                return ((Number)v).floatValue();
            }
            return super.getFloat(columnNumber);
        }
        return 0.0f;
    }

    @Override
    public short getShort(int columnNumber) throws SQLException {
        Object v = this.getObject(columnNumber);
        if (v != null) {
            if (v instanceof Boolean) {
                return (short)((Boolean)v != false ? 1 : 0);
            }
            if (v instanceof Number) {
                return ((Number)v).shortValue();
            }
            return super.getShort(columnNumber);
        }
        return 0;
    }

    @Override
    public byte getByte(int columnNumber) throws SQLException {
        Object v = this.getObject(columnNumber);
        if (v != null) {
            if (v instanceof Boolean) {
                return (byte)((Boolean)v != false ? 1 : 0);
            }
            if (v instanceof Number) {
                return ((Number)v).byteValue();
            }
            return super.getByte(columnNumber);
        }
        return 0;
    }

    protected abstract Object getObjectForColumn(int var1) throws SQLException;

    @Override
    public final boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public void close() throws SQLException {
        this.wasNull = false;
    }

    protected final SQLException dataTypeConversion(String targetType, ResultColumnDescriptor rcd) {
        return Util.generateCsSQLException(StandardException.newException("22005", (Object)targetType, (Object)rcd.getType().getTypeName(), (Object)rcd.getName()));
    }

    @Override
    public double getEstimatedRowCount(VTIEnvironment vtiEnvironment) throws SQLException {
        return 10000.0;
    }

    @Override
    public double getEstimatedCostPerInstantiation(VTIEnvironment vtiEnvironment) throws SQLException {
        return 100000.0;
    }

    @Override
    public boolean supportsMultipleInstantiations(VTIEnvironment vtiEnvironment) throws SQLException {
        return true;
    }

    public static class MemberSingleResultCollector<T>
    extends TreeMap<DistributedMember, T>
    implements ResultCollector<Object, TreeMap<DistributedMember, T>> {
        private static final long serialVersionUID = 1996707111592217057L;

        public void addResult(DistributedMember memberId, Object resultOfSingleExecution) {
            this.put(memberId, resultOfSingleExecution);
        }

        public TreeMap<DistributedMember, T> getResult() throws FunctionException {
            return this;
        }

        public TreeMap<DistributedMember, T> getResult(long timeout, TimeUnit unit) throws FunctionException, InterruptedException {
            throw new AssertionError((Object)"getResult with timeout not expected to be invoked for GemFireXD");
        }

        public void clearResults() {
            this.clear();
        }

        public void endResults() {
        }
    }
}

