/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.engine;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.execute.CallbackStatement;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverAdapter;
import com.pivotal.gemfirexd.internal.engine.distributed.GfxdConnectionWrapper;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.SubQueryInfo;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireActivation;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.compile.StatementNode;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public final class GemFireXDQueryTimeStatistics
extends GemFireXDQueryObserverAdapter {
    private static final long serialVersionUID = -2632361131680969916L;
    private final ConcurrentHashMap<String, QueryStatistics[]> statsMap = new ConcurrentHashMap();
    private int totalInvocations = 0;
    private final int dumpFreq;
    private static ThreadLocal<Long[]> startTimeStamps = new ThreadLocal<Long[]>(){

        @Override
        public Long[] initialValue() {
            int numTypes = StatType.values().length;
            Long[] initValues = new Long[numTypes];
            for (int index = 0; index < numTypes; ++index) {
                initValues[index] = 0L;
            }
            return initValues;
        }
    };
    public static final String GLOBAL_STATS_NAME = "Global Timings";

    public GemFireXDQueryTimeStatistics(int dumpFreq) {
        this.dumpFreq = dumpFreq;
    }

    @Override
    public void beforeOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
        this.startTimer(StatType.QUERY_OPTIMIZATION);
    }

    @Override
    public void afterOptimizedParsedTree(String query, StatementNode qt, LanguageConnectionContext lcc) {
        long elapsedNanos = this.stopTimer(StatType.QUERY_OPTIMIZATION);
        String customObject = null;
        if (lcc != null && (lcc.getOptimizerTrace() || lcc.explainConnection())) {
            customObject = lcc.getOptimizerTraceOutput();
        }
        this.updateStatisticsForQuery(query, StatType.QUERY_OPTIMIZATION, elapsedNanos, true, customObject);
    }

    @Override
    public void beforeQueryExecution(EmbedStatement stmt, Activation activation) {
        this.startTimer(StatType.TOTAL_EXECUTION);
    }

    @Override
    public boolean afterQueryExecution(CallbackStatement stmt, SQLException sqle) {
        long elapsedNanos = this.stopTimer(StatType.TOTAL_EXECUTION);
        long afterExecNanos = this.stopTimer(StatType.RESULT_SET_EXECUTE);
        this.updateStatisticsForQuery(stmt.getSQLText(), StatType.TOTAL_EXECUTION, elapsedNanos, true);
        this.updateStatisticsForQuery(stmt.getSQLText(), StatType.AFTER_RESULT_SET_EXECUTE, afterExecNanos, true);
        if (this.dumpFreq > 0 && ++this.totalInvocations >= this.dumpFreq) {
            this.totalInvocations = 0;
            this.dumpAllStats();
        }
        return false;
    }

    @Override
    public void beforeGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) {
        this.startTimer(StatType.RESULT_SET_OPEN);
    }

    @Override
    public void afterGemFireResultSetOpen(AbstractGemFireResultSet rs, LanguageConnectionContext lcc) {
        long elapsedNanos = this.stopTimer(StatType.RESULT_SET_OPEN);
        this.updateStatisticsForQuery(rs.getActivation().getPreparedStatement().getUserQueryString(lcc), StatType.RESULT_SET_OPEN, elapsedNanos, true);
    }

    @Override
    public void beforeGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
        long elapsedBeforeNanos = this.peekTimer(StatType.TOTAL_EXECUTION);
        this.updateStatisticsForQuery(activation.getPreparedStatement().getUserQueryString(activation.getLanguageConnectionContext()), StatType.BEFORE_RESULT_SET_EXECUTE, elapsedBeforeNanos, true);
        this.startTimer(StatType.RESULT_SET_EXECUTE);
    }

    @Override
    public void beforeComputeRoutingObjects(AbstractGemFireActivation activation) {
        this.startTimer(StatType.COMPUTE_ROUTING_OBJECTS);
    }

    @Override
    public void afterComputeRoutingObjects(AbstractGemFireActivation activation) {
        long elapsedNanos = this.stopTimer(StatType.COMPUTE_ROUTING_OBJECTS);
        this.updateStatisticsForQuery(activation.getPreparedStatement().getUserQueryString(activation.getLanguageConnectionContext()), StatType.COMPUTE_ROUTING_OBJECTS, elapsedNanos, true);
    }

    @Override
    public <T extends Serializable> void beforeQueryDistribution(StatementExecutorMessage<T> executorMessage, boolean streaming) {
        if (executorMessage == null) {
            return;
        }
        this.startTimer(StatType.TOTAL_DISTRIBUTION);
    }

    @Override
    public <T extends Serializable> void afterQueryDistribution(StatementExecutorMessage<T> executorMessage, boolean streaming) {
        if (executorMessage == null) {
            return;
        }
        long elapsedNanos = this.stopTimer(StatType.TOTAL_DISTRIBUTION);
        this.updateStatisticsForQuery(executorMessage.source(), StatType.TOTAL_DISTRIBUTION, elapsedNanos, true);
    }

    @Override
    public void afterGemFireResultSetExecuteOnActivation(AbstractGemFireActivation activation) {
        long elapsedNanos = this.stopTimer(StatType.RESULT_SET_EXECUTE);
        this.updateStatisticsForQuery(activation.getPreparedStatement().getUserQueryString(activation.getLanguageConnectionContext()), StatType.RESULT_SET_EXECUTE, elapsedNanos, true);
        this.startTimer(StatType.RESULT_SET_EXECUTE);
    }

    @Override
    public void beforeGemFireResultSetClose(AbstractGemFireResultSet rs, String query) {
        this.startTimer(StatType.RESULT_SET_CLOSE);
    }

    @Override
    public void afterGemFireResultSetClose(AbstractGemFireResultSet rs, String query) {
        long elapsedNanos = this.stopTimer(StatType.RESULT_SET_CLOSE);
        this.updateStatisticsForQuery(query, StatType.RESULT_SET_CLOSE, elapsedNanos, true);
    }

    @Override
    public void beforeResultHolderExecution(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        long beforeElapsedNanos = this.peekTimer(StatType.PREPSTATEMENT_QUERY_EXECUTION);
        if (beforeElapsedNanos == 0L) {
            beforeElapsedNanos = this.peekTimer(StatType.STATEMENT_QUERY_EXECUTION);
        }
        this.updateStatisticsForQuery(es.getSQLText(), StatType.BEFORE_RESULT_HOLDER_EXECUTE, beforeElapsedNanos, true);
        this.startTimer(StatType.RESULT_HOLDER_EXECUTE);
    }

    @Override
    public void beforeResultHolderIteration(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        this.startTimer(StatType.RESULT_HOLDER_ITERATION);
    }

    @Override
    public void afterResultHolderIteration(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        long elapsedNanos = this.stopTimer(StatType.RESULT_HOLDER_ITERATION);
        this.updateStatisticsForQuery(es.getSQLText(), StatType.RESULT_HOLDER_ITERATION, elapsedNanos, true);
    }

    @Override
    public void beforeResultHolderSerialization(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        this.startTimer(StatType.RESULT_HOLDER_SERIALIZATION);
    }

    @Override
    public void afterResultHolderSerialization(GfxdConnectionWrapper wrapper, EmbedStatement es) {
        long elapsedNanos = this.stopTimer(StatType.RESULT_HOLDER_SERIALIZATION);
        this.updateStatisticsForQuery(es.getSQLText(), StatType.RESULT_HOLDER_SERIALIZATION, elapsedNanos, true);
    }

    @Override
    public void afterResultHolderExecution(GfxdConnectionWrapper wrapper, EmbedStatement es, String query) {
        long elapsedNanos = this.stopTimer(StatType.RESULT_HOLDER_EXECUTE);
        this.updateStatisticsForQuery(query, StatType.RESULT_HOLDER_EXECUTE, elapsedNanos, true);
    }

    @Override
    public void beforeResultSetHolderRowRead(RowFormatter rf, Activation act) {
        this.startTimer(StatType.RESULT_HOLDER_READ);
    }

    @Override
    public void afterResultSetHolderRowRead(RowFormatter rf, ExecRow row, Activation act) {
        long elapsedNanos = this.stopTimer(StatType.RESULT_HOLDER_READ);
        this.updateStatisticsForQuery(act.getPreparedStatement().getUserQueryString(act.getLanguageConnectionContext()), StatType.RESULT_HOLDER_READ, elapsedNanos, true);
    }

    @Override
    public void beforeQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
        this.startTimer(StatType.STATEMENT_QUERY_EXECUTION);
    }

    @Override
    public void afterQueryExecutionByStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedStatement stmt, String query) {
        long elapsedNanos = this.stopTimer(StatType.STATEMENT_QUERY_EXECUTION);
        this.updateStatisticsForQuery(query, StatType.STATEMENT_QUERY_EXECUTION, elapsedNanos, true);
    }

    @Override
    public void beforeQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
        this.startTimer(StatType.PREPSTATEMENT_QUERY_EXECUTION);
    }

    @Override
    public void afterQueryExecutionByPrepStatementQueryExecutor(GfxdConnectionWrapper wrapper, EmbedPreparedStatement pstmt, String query) {
        long elapsedNanos = this.stopTimer(StatType.PREPSTATEMENT_QUERY_EXECUTION);
        this.updateStatisticsForQuery(pstmt.getSQLText(), StatType.PREPSTATEMENT_QUERY_EXECUTION, elapsedNanos, true);
    }

    @Override
    public void beforeConnectionCloseByExecutorFunction(long[] connectionIDs) {
        this.startTimer(StatType.CONNECTION_CLOSE);
    }

    @Override
    public void afterConnectionCloseByExecutorFunction(long[] connectionIDs) {
        long elapsedNanos = this.stopTimer(StatType.CONNECTION_CLOSE);
        this.updateStatisticsForQuery(GLOBAL_STATS_NAME, StatType.CONNECTION_CLOSE, elapsedNanos, true);
    }

    @Override
    public void beforeORM(Activation activation, AbstractGemFireResultSet rs) {
        this.startTimer(StatType.ORM_TIME);
    }

    @Override
    public void afterORM(Activation activation, AbstractGemFireResultSet rs) {
        long elapsedNanos = this.stopTimer(StatType.ORM_TIME);
        this.updateStatisticsForQuery(activation.getPreparedStatement().getUserQueryString(activation.getLanguageConnectionContext()), StatType.ORM_TIME, elapsedNanos, true);
    }

    @Override
    public void queryInfoObjectFromOptmizedParsedTree(QueryInfo qInfo, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
    }

    @Override
    public void subQueryInfoObjectFromOptmizedParsedTree(List<SubQueryInfo> qInfos, GenericPreparedStatement gps, LanguageConnectionContext lcc) {
    }

    @Override
    public void beforeForeignKeyConstraintCheckAtRegionLevel() {
    }

    @Override
    public void beforeUniqueConstraintCheckAtRegionLevel() {
    }

    @Override
    public void beforeGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey) {
        this.startTimer(StatType.GLOBAL_INDEX_LOOKUP);
    }

    @Override
    public void afterGlobalIndexLookup(LanguageConnectionContext lcc, PartitionedRegion indexRegion, Serializable indexKey, Object result) {
        ExecPreparedStatement pstmt;
        long elapsedNanos = this.stopTimer(StatType.GLOBAL_INDEX_LOOKUP);
        if (lcc != null && lcc.getActivationCount() > 0 && (pstmt = lcc.getLastActivation().getPreparedStatement()) != null) {
            this.updateStatisticsForQuery(pstmt.getUserQueryString(lcc), StatType.GLOBAL_INDEX_LOOKUP, elapsedNanos, true);
        }
    }

    @Override
    public void reset() {
        this.dumpAllStats();
        this.statsMap.clear();
    }

    @Override
    public void close() {
        this.reset();
    }

    public Iterator<Map.Entry<String, QueryStatistics[]>> getIterator() {
        return this.statsMap.entrySet().iterator();
    }

    private synchronized StringBuilder dumpAllStats() {
        StringBuilder statsString = new StringBuilder("Query time statistics:\n");
        QueryStatistics[] globalStatsArray = null;
        for (Map.Entry<String, QueryStatistics[]> statsEntry : this.statsMap.entrySet()) {
            String query = statsEntry.getKey();
            QueryStatistics[] statsArray = statsEntry.getValue();
            if (GLOBAL_STATS_NAME.equals(query)) {
                globalStatsArray = statsArray;
                continue;
            }
            this.dumpStatsForQuery(query, statsArray, statsString);
        }
        if (globalStatsArray != null) {
            this.dumpStatsForQuery(GLOBAL_STATS_NAME, globalStatsArray, statsString);
        }
        SanityManager.DEBUG_PRINT((String)"QueryStats", (String)statsString.toString());
        return statsString;
    }

    private void startTimer(StatType statType) {
        Long[] currValues = startTimeStamps.get();
        long startTime = System.nanoTime();
        currValues[statType.ordinal()] = startTime;
    }

    private long stopTimer(StatType statType) {
        Long[] currValues = startTimeStamps.get();
        long startTime = currValues[statType.ordinal()];
        if (startTime == 0L) {
            return 0L;
        }
        currValues[statType.ordinal()] = 0L;
        return System.nanoTime() - startTime;
    }

    private long peekTimer(StatType statType) {
        Long[] currValues = startTimeStamps.get();
        long startTime = currValues[statType.ordinal()];
        if (startTime == 0L) {
            return 0L;
        }
        return System.nanoTime() - startTime;
    }

    private void updateStatisticsForQuery(String query, StatType statType, long incNanos, boolean incInvocations) {
        this.updateStatisticsForQuery(query, statType, incNanos, incInvocations, null);
    }

    private void updateStatisticsForQuery(String query, StatType statType, long incNanos, boolean incInvocations, Object customObject) {
        if (query != null) {
            QueryStatistics[] queryStatsArray = this.getOrCreateQueryStatisticsForQuery(query);
            QueryStatistics queryStats = queryStatsArray[statType.ordinal()];
            if (incInvocations) {
                ++queryStats.numInvocations;
            }
            queryStats.totalTimeInNanos.addAndGet(incNanos);
            if (customObject != null) {
                queryStats.customObject = customObject;
            }
        }
    }

    private QueryStatistics[] getOrCreateQueryStatisticsForQuery(String query) {
        QueryStatistics[] queryStatsArray = this.statsMap.get(query);
        if (queryStatsArray == null) {
            StatType[] allTypes = StatType.values();
            queryStatsArray = new QueryStatistics[allTypes.length];
            for (int index = 0; index < allTypes.length; ++index) {
                queryStatsArray[index] = new QueryStatistics();
            }
            QueryStatistics[] oldQueryStatsArray = this.statsMap.putIfAbsent(query, queryStatsArray);
            if (oldQueryStatsArray != null) {
                queryStatsArray = oldQueryStatsArray;
            }
        }
        return queryStatsArray;
    }

    private void dumpStatsForQuery(String query, QueryStatistics[] statsArray, StringBuilder statsString) {
        statsString.append("Time Statistics for: ").append(query).append('\n');
        StatType[] allStats = StatType.values();
        for (int index = 0; index < statsArray.length; ++index) {
            QueryStatistics stats = statsArray[index];
            statsString.append('\t').append((Object)allStats[index]).append(" took ").append(stats.totalTimeInNanos.get()).append("nanos for ").append(stats.numInvocations).append(" invocations\n");
        }
    }

    public static class QueryStatistics {
        private int numInvocations = 0;
        private final AtomicLong totalTimeInNanos = new AtomicLong(0L);
        private Object customObject;

        QueryStatistics() {
        }

        public int getNumInvocations() {
            return this.numInvocations;
        }

        public long getTotalTimeInNanos() {
            return this.totalTimeInNanos.get();
        }

        public Object getCustomObject() {
            return this.customObject;
        }
    }

    public static enum StatType {
        RESULT_SET_OPEN,
        RESULT_SET_EXECUTE,
        BEFORE_RESULT_SET_EXECUTE,
        AFTER_RESULT_SET_EXECUTE,
        RESULT_SET_CLOSE,
        RESULT_HOLDER_EXECUTE,
        BEFORE_RESULT_HOLDER_EXECUTE,
        RESULT_HOLDER_SERIALIZATION,
        RESULT_HOLDER_ITERATION,
        RESULT_HOLDER_READ,
        QUERY_OPTIMIZATION,
        COMPUTE_ROUTING_OBJECTS,
        PREPSTATEMENT_QUERY_EXECUTION,
        STATEMENT_QUERY_EXECUTION,
        GLOBAL_INDEX_LOOKUP,
        TOTAL_DISTRIBUTION,
        ORM_TIME,
        CONNECTION_CLOSE,
        TOTAL_EXECUTION;

    }
}

