/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.diag;

import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.ConnectionUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSetMetaData;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericStatement;
import com.pivotal.gemfirexd.internal.impl.sql.conn.CachedStatement;
import com.pivotal.gemfirexd.internal.vti.VTITemplate;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Vector;

public final class StatementCache
extends VTITemplate {
    private int position = -1;
    private Vector data;
    private GenericPreparedStatement currentPs;
    private boolean wasNull;
    private static final ResultColumnDescriptor[] columnInfo = new ResultColumnDescriptor[]{EmbedResultSetMetaData.getResultColumnDescriptor("ID", 1, false, 36), EmbedResultSetMetaData.getResultColumnDescriptor("SCHEMANAME", 12, true, 128), EmbedResultSetMetaData.getResultColumnDescriptor("SQL_TEXT", 12, false, 32672), EmbedResultSetMetaData.getResultColumnDescriptor("UNICODE", -7, false), EmbedResultSetMetaData.getResultColumnDescriptor("VALID", -7, false), EmbedResultSetMetaData.getResultColumnDescriptor("COMPILED_AT", 93, true)};
    private static final ResultSetMetaData metadata = new EmbedResultSetMetaData(columnInfo);

    public StatementCache() throws SQLException {
        LanguageConnectionContext lcc = ConnectionUtil.getCurrentLCC();
        CacheManager statementCache = lcc.getLanguageConnectionFactory().getStatementCache();
        if (statementCache != null) {
            Collection values = statementCache.values();
            this.data = new Vector(values.size());
            for (CachedStatement cs : values) {
                GenericPreparedStatement ps = cs.getPreparedStatement();
                this.data.addElement(ps);
            }
        }
    }

    @Override
    public boolean next() {
        if (this.data == null) {
            return false;
        }
        ++this.position;
        while (this.position < this.data.size()) {
            this.currentPs = (GenericPreparedStatement)this.data.elementAt(this.position);
            if (this.currentPs != null) {
                return true;
            }
            ++this.position;
        }
        this.data = null;
        return false;
    }

    @Override
    public void close() {
        this.data = null;
        this.currentPs = null;
    }

    @Override
    public String getString(int colId) {
        this.wasNull = false;
        switch (colId) {
            case 1: {
                return this.currentPs.getObjectName();
            }
            case 2: {
                return ((GenericStatement)this.currentPs.statement).getCompilationSchema();
            }
            case 3: {
                String sql = this.currentPs.getSource();
                sql = StringUtil.truncate(sql, 32672);
                return sql;
            }
        }
        return null;
    }

    @Override
    public boolean getBoolean(int colId) {
        this.wasNull = false;
        switch (colId) {
            case 4: {
                return true;
            }
            case 5: {
                return this.currentPs.isValid();
            }
        }
        return false;
    }

    @Override
    public Timestamp getTimestamp(int colId) {
        Timestamp ts = this.currentPs.getEndCompileTimestamp();
        this.wasNull = ts == null;
        return ts;
    }

    @Override
    public boolean wasNull() {
        return this.wasNull;
    }

    @Override
    public ResultSetMetaData getMetaData() {
        return metadata;
    }
}

