/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.catalog.types;

import com.pivotal.gemfirexd.internal.catalog.DefaultInfo;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DefaultInfoImpl
implements DefaultInfo,
Formatable {
    private DataValueDescriptor defaultValue;
    private String defaultText;
    private int type;
    private static final int BITS_MASK_IS_DEFAULTVALUE_AUTOINC = 1;

    public DefaultInfoImpl() {
    }

    public DefaultInfoImpl(boolean isDefaultValueAutoinc, String defaultText, DataValueDescriptor defaultValue) {
        this.type = DefaultInfoImpl.calcType(isDefaultValueAutoinc);
        this.defaultText = defaultText;
        this.defaultValue = defaultValue;
    }

    @Override
    public String getDefaultText() {
        return this.defaultText;
    }

    public String toString() {
        if (this.isDefaultValueAutoinc()) {
            return "GENERATED_BY_DEFAULT";
        }
        return this.defaultText;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.defaultText = (String)in.readObject();
        this.defaultValue = (DataValueDescriptor)in.readObject();
        this.type = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.defaultText);
        out.writeObject(this.defaultValue);
        out.writeInt(this.type);
    }

    @Override
    public int getTypeFormatId() {
        return 326;
    }

    public DataValueDescriptor getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(DataValueDescriptor defaultValue) {
        this.defaultValue = defaultValue;
    }

    @Override
    public boolean isDefaultValueAutoinc() {
        return (this.type & 1) != 0;
    }

    private static int calcType(boolean isDefaultValueAutoinc) {
        int value = 0;
        if (isDefaultValueAutoinc) {
            value |= 1;
        }
        return value;
    }
}

