/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.hadoop.mapreduce;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class Key
implements WritableComparable<Key> {
    private byte[] key;
    private static final byte[] EMPTY_BYTES = new byte[0];

    public Key() {
        this.setKey(null);
    }

    public void write(DataOutput out) throws IOException {
        out.writeInt(this.key.length);
        out.write(this.key, 0, this.key.length);
    }

    public void readFields(DataInput in) throws IOException {
        int len = in.readInt();
        this.key = new byte[len];
        in.readFully(this.key, 0, len);
    }

    public final int compareTo(Key k) {
        byte[] b1 = this.key;
        byte[] b2 = k.key;
        return WritableComparator.compareBytes((byte[])b1, (int)0, (int)b1.length, (byte[])b2, (int)0, (int)b2.length);
    }

    public final void setKey(byte[] k) {
        this.key = k != null ? k : EMPTY_BYTES;
    }

    public final byte[] getKey() {
        return this.key;
    }
}

