/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.callbacks.impl;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.i18n.LogWriterI18n;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.TimestampedEntryEventImpl;
import com.pivotal.gemfirexd.callbacks.impl.GatewayConflictHelper;
import com.pivotal.gemfirexd.callbacks.impl.GatewayEventImpl;
import com.pivotal.gemfirexd.internal.engine.ddl.EventImpl;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

public class GatewayConflictHelperImpl
implements GatewayConflictHelper {
    private GatewayEventImpl gatewayEvent;
    private com.gemstone.gemfire.cache.util.GatewayConflictHelper gfeConflictHelper;
    private GemFireContainer.SerializableDelta changes;

    public void setGFEConflictHelper(com.gemstone.gemfire.cache.util.GatewayConflictHelper gfeConflictHelper) {
        this.gfeConflictHelper = gfeConflictHelper;
    }

    public void setGatewayEvent(GatewayEventImpl event) {
        this.gatewayEvent = event;
    }

    public void applyChanges() throws StandardException {
        if (this.changes == null) {
            return;
        }
        TimestampedEntryEventImpl event = this.gatewayEvent.getEntryEvent();
        LogWriterI18n logger = event.getRegion().getLogWriterI18n();
        if (logger.fineEnabled()) {
            logger.fine("GatewayConflictHelperImpl::Applying changes");
        }
        Object collectedChanges = null;
        collectedChanges = event.hasDelta() ? this.changes : this.changes.apply((Region<?, ?>)event.getRegion(), event.getKey(), event.getRawNewValue(), false);
        if (logger.fineEnabled()) {
            logger.fine("GatewayConflictHelperImpl::Setting collected changes on GFE conflict helper");
        }
        this.gfeConflictHelper.changeEventValue(collectedChanges);
    }

    private void saveChange(Region<?, ?> region, GemFireContainer.SerializableDelta delta) {
        LogWriterI18n logger = GemFireCacheImpl.getExisting().getLoggerI18n();
        if (logger.fineEnabled()) {
            logger.fine("GatewayConflictHelperImpl::Saving change:" + delta);
        }
        this.changes = this.changes == null ? delta : (GemFireContainer.SerializableDelta)this.changes.merge(region, delta);
        logger.fine("GatewayConflictHelperImpl::Collected changes:" + this.changes);
    }

    @Override
    public void disallowEvent() {
        assert (this.gfeConflictHelper != null);
        this.gfeConflictHelper.disallowEvent();
    }

    @Override
    public void setColumnValue(int index, Object value) throws Exception {
        GemFireContainer.SerializableDelta eventDelta;
        assert (this.gfeConflictHelper != null);
        assert (this.gatewayEvent != null);
        LogWriterI18n logger = GemFireCacheImpl.getExisting().getLoggerI18n();
        if (logger.fineEnabled()) {
            logger.fine("GatewayConflictHelperImpl::Attempting to set column-" + index + ", value=" + value.toString());
        }
        TimestampedEntryEventImpl event = this.gatewayEvent.getEntryEvent();
        EventImpl eventImpl = this.gatewayEvent.getEventImpl();
        GemFireContainer container = eventImpl.getContainer();
        int numColumns = container.getNumColumns();
        FormatableBitSet changedColumnsBitSet = new FormatableBitSet(numColumns);
        changedColumnsBitSet.grow(numColumns);
        changedColumnsBitSet.set(index - 1);
        DataValueDescriptor[] changedRow = new DataValueDescriptor[numColumns];
        RowFormatter rf = container.getCurrentRowFormatter();
        DataValueDescriptor columnDVD = rf.getNewNull(index);
        columnDVD.setObjectForCast(value, true, value.getClass().getName());
        changedRow[index - 1] = columnDVD;
        GemFireContainer.SerializableDelta newDelta = new GemFireContainer.SerializableDelta(changedRow, changedColumnsBitSet);
        if (event.hasDelta() && (eventDelta = eventImpl.getSerializableDelta()) != null) {
            if (logger.fineEnabled()) {
                logger.fine("Event's Delta=" + eventDelta);
            }
            GemFireContainer.SerializableDelta mergedDelta = (GemFireContainer.SerializableDelta)eventDelta.merge((Region<?, ?>)event.getRegion(), newDelta);
            if (logger.fineEnabled()) {
                logger.fine("Merged Delta as New Value =" + mergedDelta);
            }
            newDelta = mergedDelta;
        }
        this.saveChange((Region<?, ?>)event.getRegion(), newDelta);
    }

    public static void dummy() {
    }
}

