/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.callbacks;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.ByteArrayDataInput;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.FileInputStream;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class EventErrorFileToDBWriter {
    protected static final String ERR_XML_ROOT = "failures";
    protected static final String ERR_XML_ENTRIES_ENTITY = "errorEntries";
    protected static final String ERR_XML_FAILURE = "failure";
    protected static final String ERR_XML_SQL = "sql";
    protected static final String ERR_XML_PARAMS = "parameters";
    protected static final String ERR_XML_PARAM = "param";
    protected static final String ERR_XML_ATTR_TYPE = "jtype";
    protected static final String ERR_XML_ATTR_NULL = "isnull";
    protected static final String ERR_XML_EXCEPTION = "exception";
    protected static final String ERR_XML_SQLSTATE = "sqlstate";
    protected static final String ERR_XML_ERRCODE = "errorcode";
    protected static final String ERR_XML_EX_MESSAGE = "message";
    protected static final String ERR_XML_EX_STACK = "stack";

    public static void main(String[] args) throws Exception {
        Connection conn;
        if (args.length < 2 || args.length > 4) {
            System.err.println("Usage: WriteErrorsToDB <JDBC URL> <file> [<user> <password>]");
            return;
        }
        String connStr = args[0];
        if (args.length > 2) {
            String password;
            String user = args[2];
            if (args.length == 4) {
                password = args[3];
            } else {
                System.out.print("Password: ");
                System.out.flush();
                char[] passwd = System.console().readPassword();
                password = passwd == null ? "" : new String(passwd);
            }
            conn = DriverManager.getConnection(connStr, user, password);
        } else {
            conn = DriverManager.getConnection(connStr);
        }
        EventErrorFileToDBWriter.writeXMLToDB(conn, args[1]);
    }

    public static void writeXMLToDB(Connection conn, String file) throws Exception {
        BufferedInputStream xmlStream = new BufferedInputStream(new FileInputStream(file));
        XMLInputFactory xmlFactory = XMLInputFactory.newFactory();
        xmlFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        xmlFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        XMLStreamReader xmlReader = xmlFactory.createXMLStreamReader(xmlStream);
        String sql = null;
        ArrayList<String[]> paramsBatch = new ArrayList<String[]>();
        ArrayList<Integer> paramTypes = new ArrayList<Integer>();
        block17: while (xmlReader.hasNext()) {
            int entityType = xmlReader.next();
            switch (entityType) {
                case 9: {
                    String entityName = xmlReader.getLocalName();
                    if (ERR_XML_ENTRIES_ENTITY.equals(entityName)) continue block17;
                    EventErrorFileToDBWriter.throwUnexpectedEntity(xmlReader, entityName, entityType, "entityReference");
                    continue block17;
                }
                case 1: {
                    String entityName = xmlReader.getLocalName();
                    if (ERR_XML_ROOT.equals(entityName)) continue block17;
                    if (ERR_XML_FAILURE.equals(entityName)) {
                        sql = null;
                        paramsBatch.clear();
                        paramTypes.clear();
                        continue block17;
                    }
                    if (ERR_XML_SQL.equals(entityName)) {
                        entityType = xmlReader.next();
                        switch (entityType) {
                            case 4: {
                                sql = xmlReader.getText();
                                continue block17;
                            }
                        }
                        EventErrorFileToDBWriter.throwUnexpectedEntity(xmlReader, xmlReader.getLocalName(), entityType, ERR_XML_SQL);
                        continue block17;
                    }
                    if (!ERR_XML_PARAMS.equals(entityName)) continue block17;
                    boolean endReached = false;
                    ArrayList<String> params = new ArrayList<String>();
                    boolean addParamTypes = paramTypes.isEmpty();
                    block18: while (xmlReader.hasNext() && !endReached) {
                        entityType = xmlReader.nextTag();
                        switch (entityType) {
                            case 1: {
                                entityName = xmlReader.getLocalName();
                                if (!ERR_XML_PARAM.equals(entityName)) {
                                    EventErrorFileToDBWriter.throwUnexpectedEntity(xmlReader, entityName, entityType, ERR_XML_PARAMS);
                                }
                                boolean isNull = false;
                                for (int i = 0; i < xmlReader.getAttributeCount(); ++i) {
                                    String attrName = xmlReader.getAttributeLocalName(i);
                                    if (ERR_XML_ATTR_NULL.equals(attrName)) {
                                        if (!Boolean.parseBoolean(xmlReader.getAttributeValue(i))) continue;
                                        params.add(null);
                                        isNull = true;
                                        continue;
                                    }
                                    if (ERR_XML_ATTR_TYPE.equals(attrName)) {
                                        if (!addParamTypes) continue;
                                        paramTypes.add(Integer.parseInt(xmlReader.getAttributeValue(i)));
                                        continue;
                                    }
                                    EventErrorFileToDBWriter.throwUnexpectedEntity(xmlReader, attrName, 10, ERR_XML_PARAM);
                                }
                                if (isNull) continue block18;
                                entityType = xmlReader.next();
                                switch (entityType) {
                                    case 4: {
                                        params.add(xmlReader.getText());
                                        continue block18;
                                    }
                                    case 5: {
                                        continue block18;
                                    }
                                }
                                EventErrorFileToDBWriter.throwUnexpectedEntity(xmlReader, xmlReader.getLocalName(), entityType, ERR_XML_PARAM);
                                continue block18;
                            }
                            case 2: {
                                entityName = xmlReader.getLocalName();
                                if (ERR_XML_PARAMS.equals(entityName)) {
                                    endReached = true;
                                    continue block18;
                                }
                                if (ERR_XML_PARAM.equals(entityName)) continue block18;
                                EventErrorFileToDBWriter.throwUnexpectedEntity(xmlReader, entityName, entityType, ERR_XML_PARAMS);
                                continue block18;
                            }
                        }
                        EventErrorFileToDBWriter.throwUnexpectedEntity(xmlReader, xmlReader.getLocalName(), entityType, ERR_XML_PARAMS);
                    }
                    if (params.size() <= 0) continue block17;
                    paramsBatch.add(params.toArray(new String[params.size()]));
                    continue block17;
                }
                case 2: {
                    String entityName = xmlReader.getLocalName();
                    if (ERR_XML_ROOT.equals(entityName)) continue block17;
                    if (ERR_XML_FAILURE.equals(entityName)) {
                        if (sql == null) {
                            throw new XMLStreamException("no SQL found in current 'failure' tag at: " + xmlReader.getLocation());
                        }
                        int[] result = EventErrorFileToDBWriter.executeStatement(conn, sql, paramsBatch, paramTypes);
                        if (result.length == 1) {
                            System.out.println("Updated " + result[0] + " rows.");
                        } else {
                            int numAffected = 0;
                            String numAffectedStr = null;
                            for (int res : result) {
                                if (res < 0) {
                                    numAffectedStr = "<unknown>";
                                    continue;
                                }
                                numAffected += res;
                            }
                            if (numAffectedStr == null) {
                                numAffectedStr = Integer.toString(numAffected);
                            }
                            System.out.println("Updated " + numAffectedStr + " rows in a batch execution having " + paramsBatch.size() + " elements.");
                        }
                        sql = null;
                        paramsBatch.clear();
                        paramTypes.clear();
                        continue block17;
                    }
                    if (!ERR_XML_SQL.equals(entityName)) continue block17;
                    continue block17;
                }
                case 5: {
                    continue block17;
                }
            }
        }
        conn.commit();
        xmlReader.close();
        xmlStream.close();
    }

    protected static int[] executeStatement(Connection conn, String sql, ArrayList<String[]> paramsBatch, ArrayList<Integer> paramTypes) throws Exception {
        PreparedStatement pstmt = conn.prepareStatement(sql);
        int batchSize = paramsBatch.size();
        if (batchSize > 0) {
            if (batchSize == 1) {
                EventErrorFileToDBWriter.setParameters(pstmt, paramsBatch.get(0), paramTypes);
            } else {
                for (String[] params : paramsBatch) {
                    EventErrorFileToDBWriter.setParameters(pstmt, params, paramTypes);
                    pstmt.addBatch();
                }
                return pstmt.executeBatch();
            }
        }
        return new int[]{pstmt.executeUpdate()};
    }

    public static void setParameters(PreparedStatement pstmt, String[] params, ArrayList<Integer> paramTypes) throws Exception {
        block13: for (int index = 0; index < params.length; ++index) {
            String param = params[index];
            int paramIndex = index + 1;
            int paramType = paramTypes.get(index);
            if (param == null) {
                pstmt.setNull(paramIndex, paramType);
                continue;
            }
            switch (paramType) {
                case -5: {
                    long longVal = Long.parseLong(param);
                    pstmt.setLong(paramIndex, longVal);
                    continue block13;
                }
                case -7: 
                case 16: {
                    boolean boolVal = "1".equals(param) ? true : ("0".equals(param) ? false : Boolean.parseBoolean(param));
                    pstmt.setBoolean(paramIndex, boolVal);
                    continue block13;
                }
                case 91: {
                    Date dateVal = Date.valueOf(param);
                    pstmt.setDate(paramIndex, dateVal);
                    continue block13;
                }
                case 2: 
                case 3: {
                    BigDecimal decimalVal = new BigDecimal(param);
                    pstmt.setBigDecimal(paramIndex, decimalVal);
                    continue block13;
                }
                case 8: {
                    double doubleVal = Double.parseDouble(param);
                    pstmt.setDouble(paramIndex, doubleVal);
                    continue block13;
                }
                case 6: 
                case 7: {
                    float floatVal = Float.parseFloat(param);
                    pstmt.setFloat(paramIndex, floatVal);
                    continue block13;
                }
                case -6: 
                case 4: 
                case 5: {
                    int intVal = Integer.parseInt(param);
                    pstmt.setInt(paramIndex, intVal);
                    continue block13;
                }
                case 92: {
                    Time timeVal = Time.valueOf(param);
                    pstmt.setTime(paramIndex, timeVal);
                    continue block13;
                }
                case 93: {
                    Timestamp timestampVal = Timestamp.valueOf(param);
                    pstmt.setTimestamp(paramIndex, timestampVal);
                    continue block13;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    byte[] bytes = ClientSharedUtils.fromHexString((String)param, (int)0, (int)param.length());
                    pstmt.setBytes(paramIndex, bytes);
                    continue block13;
                }
                case 2000: {
                    byte[] bytes = ClientSharedUtils.fromHexString((String)param, (int)0, (int)param.length());
                    ByteArrayDataInput in = new ByteArrayDataInput();
                    in.initialize(bytes, null);
                    pstmt.setObject(paramIndex, DataSerializer.readObject((DataInput)in));
                    continue block13;
                }
                default: {
                    pstmt.setString(paramIndex, param);
                }
            }
        }
    }

    protected static void throwUnexpectedEntity(XMLStreamReader xmlReader, String name, int type, String currentTag) throws XMLStreamException {
        throw new XMLStreamException("unexpected entity " + name + '[' + type + ']' + " inside '" + currentTag + "' at: " + xmlReader.getLocation());
    }

    public static void dummy() {
    }
}

