/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.pxf.plugins.gemfirexd;

import com.pivotal.gemfirexd.hadoop.mapred.Key;
import com.pivotal.gemfirexd.hadoop.mapred.Row;
import com.pivotal.pxf.api.Fragment;
import com.pivotal.pxf.api.Fragmenter;
import com.pivotal.pxf.api.utilities.InputData;
import com.pivotal.pxf.plugins.gemfirexd.util.GemFireXDManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.lib.CombineFileSplit;

public class GemFireXDFragmenter
extends Fragmenter {
    private JobConf jobConf = new JobConf(new Configuration(), GemFireXDFragmenter.class);
    private GemFireXDManager gfxdManager;

    public GemFireXDFragmenter(InputData inputData) throws Exception {
        this(inputData, new GemFireXDManager(inputData, true));
    }

    public GemFireXDFragmenter(InputData inputData, GemFireXDManager mgr) throws Exception {
        super(inputData);
        this.gfxdManager = mgr;
        this.gfxdManager.configureJob(this.jobConf, this.gfxdManager.getHomeDir());
        String msg = this.gfxdManager.verifyUserAttributes();
        if (msg != null && !msg.equals("")) {
            throw new IllegalArgumentException(msg);
        }
    }

    public List<Fragment> getFragments() throws IOException {
        InputSplit[] splits;
        for (InputSplit split : splits = this.getSplits()) {
            CombineFileSplit cSplit = (CombineFileSplit)split;
            if (cSplit.getLength() <= 0L) continue;
            String filepath = cSplit.getPath(0).toUri().getPath();
            filepath = filepath.substring(1);
            if (this.gfxdManager.getLogger().isDebugEnabled()) {
                this.gfxdManager.getLogger().debug("fragment-filepath " + filepath);
            }
            byte[] data = this.gfxdManager.populateUserData(cSplit);
            this.fragments.add(new Fragment(filepath, cSplit.getLocations(), data));
        }
        return this.fragments;
    }

    private InputSplit[] getSplits() throws IOException {
        InputFormat<Key, Row> inputFormat = this.gfxdManager.getInputFormat();
        try {
            return inputFormat.getSplits(this.jobConf, 1);
        }
        catch (FileNotFoundException fnfe) {
            throw new FileNotFoundException("Table " + this.gfxdManager.getTable() + " not found. The LOCATION string may contain incorrect value for one or more of the following:1. Path to HDFSSTORE (homeDir), 2. Schema name or 3. Table name. " + "LOCATION format: 'pxf://namenode_rest_host:namenode_rest_port/hdfsstore_homedir/schemaname.tablename?PROFILE=GemFireXD[&attribute=value]*'");
        }
    }
}

