/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.planexporter;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.InternalDistributedSystem;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.tools.planexporter.AccessDistributedSystem;
import com.pivotal.gemfirexd.tools.planexporter.ExecutionPlanMessage;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Set;

public abstract class AbstractCreatePlan {
    protected final AccessDistributedSystem ds;
    protected final XPLAINUtil.XMLForms xmlForm;
    protected final String embedXslFileName;

    protected AbstractCreatePlan(AccessDistributedSystem access, boolean isRemote, XPLAINUtil.XMLForms xmlForm, String embedXslFileName) {
        this.ds = access;
        if (isRemote) {
            this.ds.markRemote();
        }
        this.xmlForm = xmlForm;
        this.embedXslFileName = embedXslFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ExecutionPlanMessage sendMessage() throws StandardException, SQLException, IOException {
        LanguageConnectionContext lcc = this.ds.getLanguageConnectionContext();
        Set<DistributedMember> members = GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(null);
        InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
        members.remove(myId);
        ExecutionPlanMessage msg = new ExecutionPlanMessage(lcc.getCurrentSchemaName(), this.ds.getQueryID(), this.xmlForm, this.embedXslFileName, Misc.getGemFireCache().getDistributedSystem(), members);
        try (CharArrayWriter out = new CharArrayWriter();){
            this.processPlan(out, false);
            char[] lc = out.toCharArray();
            if (lc != null && lc.length > 0) {
                if (GemFireXDUtils.TracePlanGeneration) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)(this + " adding local result " + String.valueOf(lc)));
                }
                msg.addResult(lc);
            }
        }
        if (members.size() > 0) {
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("sending execution plan message for " + this.ds.getQueryID()));
            }
            InternalDistributedSystem ids = Misc.getDistributedSystem();
            msg.send(ids, ids.getDM(), msg.getReplyProcessor(), true, false);
            if (GemFireXDUtils.TracePlanGeneration) {
                SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("processing results from remote nodes for " + this.ds.getQueryID()));
            }
        }
        return msg;
    }

    abstract void processPlan(CharArrayWriter var1, boolean var2) throws SQLException, IOException;
}

