/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.security;

import java.security.BasicPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;

public final class SystemPermission
extends BasicPermission {
    public static final String SERVER = "server";
    public static final String ENGINE = "engine";
    public static final String JMX = "jmx";
    public static final String SHUTDOWN = "shutdown";
    public static final String CONTROL = "control";
    public static final String MONITOR = "monitor";
    private static final Set LEGAL_NAMES = new HashSet();
    private static final List LEGAL_ACTIONS;
    private final String actions;

    public SystemPermission(String name, String actions) {
        super(name);
        if (!LEGAL_NAMES.contains(name)) {
            throw new IllegalArgumentException("Unknown permission " + name);
        }
        this.actions = SystemPermission.getCanonicalForm(actions);
    }

    @Override
    public String getActions() {
        return this.actions;
    }

    private static String getCanonicalForm(String actions) {
        actions = actions.trim().toLowerCase(Locale.ENGLISH);
        boolean[] seenAction = new boolean[LEGAL_ACTIONS.size()];
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            String action = st.nextToken().trim().toLowerCase(Locale.ENGLISH);
            int validAction = LEGAL_ACTIONS.indexOf(action);
            if (validAction == -1) continue;
            seenAction[validAction] = true;
        }
        StringBuilder sb = new StringBuilder();
        for (int sa = 0; sa < seenAction.length; ++sa) {
            if (!seenAction[sa]) continue;
            if (sb.length() != 0) {
                sb.append(",");
            }
            sb.append(LEGAL_ACTIONS.get(sa));
        }
        return sb.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        SystemPermission osp = (SystemPermission)other;
        return this.getActions().equals(osp.getActions());
    }

    @Override
    public boolean implies(Permission permission) {
        int permissionMask;
        if (!super.implies(permission)) {
            return false;
        }
        int myActionMask = SystemPermission.getActionMask(this.getActions());
        return (myActionMask & (permissionMask = SystemPermission.getActionMask(permission.getActions()))) == permissionMask;
    }

    private static int getActionMask(String actions) {
        int mask = 0;
        StringTokenizer st = new StringTokenizer(actions, ",");
        while (st.hasMoreTokens()) {
            int validAction = LEGAL_ACTIONS.indexOf(st.nextElement());
            if (validAction == -1) continue;
            mask |= 1 << validAction;
        }
        return mask;
    }

    static {
        LEGAL_NAMES.add(SERVER);
        LEGAL_NAMES.add(ENGINE);
        LEGAL_NAMES.add(JMX);
        LEGAL_ACTIONS = new ArrayList();
        LEGAL_ACTIONS.add(CONTROL);
        LEGAL_ACTIONS.add(MONITOR);
        LEGAL_ACTIONS.add(SHUTDOWN);
    }
}

