/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Undoable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.data.RawContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseDataFileFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.EncryptContainerUndoOperation;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.EncryptData;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class EncryptContainerOperation
implements Undoable {
    private ContainerKey containerId;

    protected EncryptContainerOperation(RawContainerHandle hdl) throws StandardException {
        this.containerId = hdl.getId();
    }

    public EncryptContainerOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.containerId.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.containerId = ContainerKey.read(in);
    }

    @Override
    public ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public void releaseResource(Transaction tran) {
    }

    @Override
    public int group() {
        return 256;
    }

    @Override
    public boolean needsRedo(Transaction xact) throws StandardException {
        return false;
    }

    @Override
    public int getTypeFormatId() {
        return 459;
    }

    @Override
    public final void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException {
        this.releaseResource(tran);
    }

    public void undoMe(Transaction tran) throws StandardException {
        BaseDataFileFactory bdff = (BaseDataFileFactory)((RawTransaction)tran).getDataFactory();
        EncryptData ed = new EncryptData(bdff);
        ed.restoreContainer(this.containerId);
        this.releaseResource(tran);
    }

    @Override
    public Compensation generateUndo(Transaction tran, LimitObjectInput in) throws StandardException {
        return new EncryptContainerUndoOperation(this);
    }

    public String toString() {
        return "Encrypt container " + this.containerId;
    }
}

