/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.diag.Diagnosticable;
import com.pivotal.gemfirexd.internal.iapi.services.io.CounterOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.NullOutputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.StoredPage;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Properties;

public class D_StoredPage
implements Diagnosticable {
    protected StoredPage page;

    @Override
    public void init(Object obj) {
        SanityManager.ASSERT((boolean)(obj instanceof StoredPage));
        this.page = (StoredPage)obj;
    }

    @Override
    public String diag() throws StandardException {
        return this.page.toString();
    }

    @Override
    public void diag_detail(Properties prop) throws StandardException {
        Object prop_value = null;
        if (prop.getProperty("pageSize") != null) {
            prop.put("pageSize", Integer.toString(this.page.getPageSize()));
        }
        if (prop.getProperty("bytesFree") != null) {
            int space_available = this.page.freeSpace;
            prop.put("bytesFree", Integer.toString(space_available));
        }
        if (prop.getProperty("bytesReserved") != null) {
            int reservedSpace = this.page.totalSpace * this.page.spareSpace / 100;
            reservedSpace = Math.min(reservedSpace, this.page.freeSpace);
            prop.put("bytesReserved", Integer.toString(reservedSpace));
        }
        if (prop.getProperty("reserveSpace") != null) {
            prop.put("reserveSpace", Integer.toString(this.page.spareSpace));
        }
        if (prop.getProperty("minRecSize") != null) {
            prop.put("minRecSize", Integer.toString(this.page.minimumRecordSize));
        }
        if (prop.getProperty("pageOverhead") != null) {
            prop.put("pageOverhead", Integer.toString(this.page.getPageSize() - this.page.getMaxFreeSpace()));
        }
        if (prop.getProperty("slotTableSize") != null) {
            int slotEntrySize = this.page.getSlotsInUse() * 3 * (this.page.getPageSize() >= 65536 ? 4 : 2);
            prop.put("slotTableSize", Integer.toString(slotEntrySize));
        }
        int overflow_count = 0;
        int row_size = 0;
        long min_rowsize = 0L;
        long max_rowsize = 0L;
        long record_size = 0L;
        if (this.page.getSlotsInUse() > 0) {
            min_rowsize = Long.MAX_VALUE;
            max_rowsize = Long.MIN_VALUE;
            for (int slot = 0; slot < this.page.getSlotsInUse(); ++slot) {
                try {
                    if (this.page.getIsOverflow(slot)) {
                        SanityManager.DEBUG_PRINT((String)"OVER", (String)("Slot (" + slot + ") is overflow record of page:" + this.page));
                        ++overflow_count;
                    }
                    record_size = this.page.getRecordLength(slot);
                    row_size = (int)((long)row_size + record_size);
                    min_rowsize = Math.min(min_rowsize, record_size);
                    max_rowsize = Math.max(max_rowsize, record_size);
                    continue;
                }
                catch (Throwable t) {
                    System.out.println("Got error from getIsOverflow().");
                }
            }
        }
        if (prop.getProperty("numOverFlowed") != null) {
            prop.put("numOverFlowed", Integer.toString(overflow_count));
        }
        if (prop.getProperty("rowSize") != null) {
            prop.put("rowSize", Integer.toString(row_size));
        }
        if (prop.getProperty("minRowSize") != null) {
            prop.put("minRowSize", Long.toString(min_rowsize));
        }
        if (prop.getProperty("maxRowSize") != null) {
            prop.put("maxRowSize", Long.toString(max_rowsize));
        }
    }

    public boolean checkSlotTable(PrintStream out) throws StandardException, IOException {
        int recordCount;
        boolean ok = true;
        int slotCount = this.page.getSlotsInUse();
        if (slotCount != (recordCount = this.page.recordCount())) {
            out.println("CORRUPT PAGE: slot count mismatch: slot count " + slotCount + " record count " + recordCount);
            ok = false;
        }
        for (int slot = 0; slot < slotCount; ++slot) {
            int recordLength = this.page.getRecordPortionLength(slot);
            CounterOutputStream counter = new CounterOutputStream();
            counter.setOutputStream(new NullOutputStream());
            int recordId = this.page.fetchFromSlot(null, slot, new DataValueDescriptor[0], null, true).getId();
            this.page.logRecord(slot, 0, recordId, null, counter, null);
            int actualLength = counter.getCount();
            if (actualLength == recordLength) continue;
            out.println("CORRUPT PAGE: record length mismatch at slot " + slot);
            out.println("              slot entry length " + recordLength);
            out.println("              actual     length " + actualLength);
            ok = false;
        }
        return ok;
    }

    public String pageHeaderToString() {
        return "page id " + this.page.getIdentity() + " Overflow: " + this.page.isOverflowPage() + " PageVersion: " + this.page.getPageVersion() + " SlotsInUse: " + this.page.getSlotsInUse() + " PageStatus: " + this.page.getPageStatus() + " NextId: " + this.page.newRecordId() + "\n";
    }
}

