/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.btree;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.diag.DiagnosticUtil;
import com.pivotal.gemfirexd.internal.iapi.services.diag.DiagnosticableGeneric;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BTreeController;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.BranchControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.ControlRow;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.LevelInfo;
import com.pivotal.gemfirexd.internal.impl.store.access.btree.OpenBTree;
import java.util.Properties;

public class D_BTreeController
extends DiagnosticableGeneric {
    private static void diag_page(OpenBTree open_btree, ControlRow control_row, Properties prop, LevelInfo[] level_info) throws StandardException {
        LevelInfo li = level_info[control_row.getLevel()];
        Page page = control_row.page;
        ++li.num_pages;
        li.num_entries += page.recordCount() - 1;
        li.num_deleted += page.recordCount() - page.nonDeletedRecordCount();
        li.max_pageno = Math.max(li.max_pageno, page.getPageNumber());
        DiagnosticUtil.findDiagnostic(page).diag_detail(prop);
        DiagnosticUtil.findDiagnostic(page).diag_detail(prop);
        int free_bytes = Integer.parseInt(prop.getProperty("bytesFree"));
        li.num_free_bytes += (long)free_bytes;
        int res_bytes = Integer.parseInt(prop.getProperty("bytesReserved"));
        li.num_res_bytes += (long)res_bytes;
        int overflow = Integer.parseInt(prop.getProperty("numOverFlowed"));
        li.num_overflow_rows += (long)overflow;
        int rowsize = Integer.parseInt(prop.getProperty("rowSize"));
        li.num_rowsize_bytes += (long)rowsize;
        int slottable_size = Integer.parseInt(prop.getProperty("slotTableSize"));
        li.num_slottab_bytes += (long)slottable_size;
        int min_rowsize = Integer.parseInt(prop.getProperty("minRowSize"));
        li.min_rowsize_bytes = Math.min(li.min_rowsize_bytes, (long)min_rowsize);
        int max_rowsize = Integer.parseInt(prop.getProperty("maxRowSize"));
        li.max_rowsize_bytes = Math.max(li.max_rowsize_bytes, (long)max_rowsize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void diag_level(OpenBTree open_btree, ControlRow control_row, Properties prop, LevelInfo[] level_info) throws StandardException {
        ControlRow child = null;
        D_BTreeController.diag_page(open_btree, control_row, prop, level_info);
        try {
            child = control_row.getLeftChild(open_btree);
            if (child != null) {
                SanityManager.ASSERT((boolean)(control_row instanceof BranchControlRow));
                BranchControlRow branch = (BranchControlRow)control_row;
                D_BTreeController.diag_level(open_btree, child, prop, level_info);
                child.release();
                child = null;
                int numslots = branch.page.recordCount();
                for (int slot = 1; slot < numslots; ++slot) {
                    child = branch.getChildPageAtSlot(open_btree, slot);
                    D_BTreeController.diag_level(open_btree, child, prop, level_info);
                    child.release();
                    child = null;
                }
            }
        }
        finally {
            if (child != null) {
                child.release();
            }
        }
    }

    private static String out_summary(String hdr, long value, double ratio, String ratio_desc) {
        String double_str = "" + ratio;
        String short_str = double_str.substring(0, Math.min(double_str.lastIndexOf(".") + 3, double_str.length()));
        return "\t" + hdr + value + ".\t(" + short_str + " " + ratio_desc + ").\n";
    }

    private static String diag_onelevel(Properties prop, LevelInfo li) {
        String ret_string = new String();
        ret_string = ret_string + "Btree conglom has:\n\t" + prop.getProperty("pageSize") + " bytes per page\n\t" + li.num_pages + " total used pages (" + Integer.parseInt(prop.getProperty("pageSize")) * li.num_pages + " bytes)\n\tmaximum page number   = " + li.max_pageno + ".\n\treserved space %      = " + prop.getProperty("reserveSpace") + "%.\n\tminimum record size   = " + prop.getProperty("minRecSize") + ".\n\tpage overhead bytes   = " + prop.getProperty("pageOverhead") + " bytes per page.\n\tminimum record length = " + li.min_rowsize_bytes + ".\n\tmaximum record length = " + li.max_rowsize_bytes + ".\n\t# of bytes in rows    = " + li.num_rowsize_bytes + ".\t(" + (li.num_entries == 0 ? 0L : li.num_rowsize_bytes / (long)li.num_entries) + " bytes/row).\n" + D_BTreeController.out_summary("# of reserved bytes   = ", li.num_res_bytes, li.num_res_bytes / (long)li.num_pages, "reserved bytes/page") + D_BTreeController.out_summary("# of free bytes       = ", li.num_free_bytes, li.num_free_bytes / (long)li.num_pages, "free bytes/page") + D_BTreeController.out_summary("# of slot table bytes = ", li.num_slottab_bytes, li.num_slottab_bytes / (long)li.num_pages, "slot table bytes/page") + D_BTreeController.out_summary("# of reserved+free+row+slot bytes = ", li.num_rowsize_bytes + li.num_res_bytes + li.num_free_bytes + li.num_slottab_bytes, (li.num_rowsize_bytes + li.num_res_bytes + li.num_free_bytes + li.num_slottab_bytes) / (long)li.num_pages, "summed bytes/page") + D_BTreeController.out_summary("# of total records    = ", li.num_entries, (double)li.num_entries / (double)li.num_pages, "records/page") + D_BTreeController.out_summary("# of overflow records = ", li.num_overflow_rows, (double)li.num_overflow_rows / (double)li.num_pages, "overflow records/page") + D_BTreeController.out_summary("# of deleted records  = ", li.num_deleted, (double)li.num_deleted / (double)li.num_pages, "deleted records/page");
        return ret_string;
    }

    private static String diag_tabulate(Properties prop, LevelInfo[] level_info) {
        LevelInfo li;
        int level;
        String ret_string = new String();
        LevelInfo total = new LevelInfo();
        for (level = 0; level < level_info.length; ++level) {
            li = level_info[level];
            total.num_pages += li.num_pages;
            total.num_overflow_pgs += li.num_overflow_pgs;
            total.num_entries += li.num_entries;
            total.num_deleted += li.num_deleted;
            total.max_pageno = Math.max(total.max_pageno, li.max_pageno);
            total.num_free_bytes += li.num_free_bytes;
            total.num_res_bytes += li.num_res_bytes;
            total.num_overflow_rows += li.num_overflow_rows;
            total.num_rowsize_bytes += li.num_rowsize_bytes;
            total.num_slottab_bytes += li.num_slottab_bytes;
            total.min_rowsize_bytes = Math.min(total.min_rowsize_bytes, li.min_rowsize_bytes);
            total.max_rowsize_bytes = Math.max(total.max_rowsize_bytes, li.max_rowsize_bytes);
        }
        ret_string = ret_string + "Btree conglom has:\n\t" + prop.getProperty("pageSize") + " bytes per page\n\t" + total.num_pages + " total used pages (" + Integer.parseInt(prop.getProperty("pageSize")) * total.num_pages + " bytes)\n\tmaximum page number   = " + total.max_pageno + ".\n\treserved space %      = " + prop.getProperty("reserveSpace") + "%.\n\tminimum record size   = " + prop.getProperty("minRecSize") + ".\n\tpage overhead bytes   = " + prop.getProperty("pageOverhead") + " bytes per page.\n";
        ret_string = ret_string + D_BTreeController.diag_onelevel(prop, total);
        for (level = 0; level < level_info.length; ++level) {
            li = level_info[level];
            ret_string = ret_string + "level[" + level + "] stats:\n";
            ret_string = ret_string + D_BTreeController.diag_onelevel(prop, li);
        }
        return ret_string;
    }

    private static String olddiag_tabulate(Properties prop, LevelInfo[] level_info) {
        int level;
        String ret_string = new String();
        long total_pages = 0L;
        long total_res = 0L;
        for (level = 0; level < level_info.length; ++level) {
            total_pages += (long)level_info[level].num_pages;
        }
        ret_string = ret_string + "Btree conglom has:\n\t" + prop.getProperty("pageSize") + " bytes per page\n\t" + total_pages + " total pages (" + (long)Integer.parseInt(prop.getProperty("pageSize")) * total_pages + " bytes)\n\t" + level_info.length + " total levels\n\t" + level_info[0].num_entries + " total user records\n";
        for (level = 0; level < level_info.length; ++level) {
            LevelInfo li = level_info[level];
            ret_string = ret_string + "level[" + level + "] stats:\n";
            ret_string = ret_string + "\t# of pages           = " + li.num_pages + ".\n\t# of entries         = " + li.num_entries + ".  (" + li.num_entries / li.num_pages + " entries/page).\n\t# of deleted entries = " + li.num_deleted + ".  (" + li.num_deleted / li.num_pages + " deleted/page).\n\t# of free bytes      = " + li.num_res_bytes + ".  (" + li.num_res_bytes / (long)li.num_pages + " reserved bytes/page).\n\t# of free bytes      = " + li.num_free_bytes + ".  (" + li.num_free_bytes / (long)li.num_pages + " free bytes/page).\n\t# of slot table bytes= " + li.num_slottab_bytes + ".  (" + li.num_slottab_bytes / (long)li.num_pages + " slot table bytes/page).\n";
        }
        return ret_string;
    }

    @Override
    public void init(Object obj) {
        SanityManager.ASSERT((boolean)(obj instanceof BTreeController));
        super.init(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String diag() throws StandardException {
        BTreeController open_btree = (BTreeController)this.diag_object;
        ControlRow root = null;
        LevelInfo[] level_info = null;
        String diag_info = new String();
        try {
            int tree_height = open_btree.getHeight();
            root = ControlRow.get(open_btree, 1L);
            level_info = new LevelInfo[tree_height];
            for (int level = 0; level < level_info.length; ++level) {
                level_info[level] = new LevelInfo();
            }
            Properties prop = new Properties();
            prop.put("pageSize", "");
            prop.put("bytesFree", "");
            prop.put("bytesReserved", "");
            prop.put("reserveSpace", "");
            prop.put("minRecSize", "");
            prop.put("numOverFlowed", "");
            prop.put("rowSize", "");
            prop.put("minRowSize", "");
            prop.put("maxRowSize", "");
            prop.put("pageOverhead", "");
            prop.put("slotTableSize", "");
            D_BTreeController.diag_level(open_btree, root, prop, level_info);
            diag_info = D_BTreeController.diag_tabulate(prop, level_info);
        }
        finally {
            if (root != null) {
                root.release();
            }
        }
        return diag_info;
    }
}

