/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.rules;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.DMLQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.TableQueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionEngineRule;
import com.pivotal.gemfirexd.internal.impl.sql.rules.ExecutionRuleContext;
import java.util.List;

class AnyOneOfExecutionEngineRule
extends ExecutionEngineRule {
    AnyOneOfExecutionEngineRule() {
    }

    @Override
    protected ExecutionEngineRule.ExecutionEngine findExecutionEngine(DMLQueryInfo qInfo, ExecutionRuleContext context) {
        if (qInfo.isQuery(8, 16) || qInfo.isOuterJoinSpecialCase()) {
            if (GemFireXDUtils.TraceExecution) {
                SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:DISTINCT_QUERY_RULE:SPARK");
            }
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        if (qInfo.hasUnionNode() || qInfo.hasIntersectOrExceptNode()) {
            if (GemFireXDUtils.TraceExecution) {
                SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:UNION_OR_INTERSECT_QUERY_RULE:SPARK");
            }
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        if (qInfo.isQuery(2) && qInfo.getPrimaryKey() == null && qInfo.getLocalIndexKey() == null) {
            if (GemFireXDUtils.TraceExecution) {
                SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:GROUPBY_QUERY_RULE:SPARK");
            }
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        if (qInfo.isSelect() && !qInfo.isPrimaryKeyBased() && !qInfo.isGetAllOnLocalIndex()) {
            if (GemFireXDUtils.TraceExecution) {
                SanityManager.DEBUG_PRINT((String)"TraceExecution", (String)"AnyOneOfExecutionEngineRule:PRIMARY_KEY_BASED_RULE:STORE");
            }
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        List<TableQueryInfo> tqis = qInfo.getTableQueryInfoList();
        if (tqis != null && tqis.size() > 1) {
            return ExecutionEngineRule.ExecutionEngine.SPARK;
        }
        return ExecutionEngineRule.ExecutionEngine.NOT_DECIDED;
    }
}

