/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnectionContext;
import java.sql.SQLException;

class SetTransactionIsolationConstantAction
implements ConstantAction {
    private final int isolationLevel;

    SetTransactionIsolationConstantAction(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public String toString() {
        return "SET TRANSACTION ISOLATION LEVEL = " + this.isolationLevel;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        ContextManager cm = activation.getContextManager();
        EmbedConnection conn = EmbedConnectionContext.getEmbedConnection(cm);
        if (conn != null) {
            try {
                conn.setTransactionIsolation(ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.isolationLevel]);
            }
            catch (SQLException sqle) {
                throw Misc.wrapSQLException(sqle, sqle);
            }
        } else {
            activation.getLanguageConnectionContext().setIsolationLevel(this.isolationLevel);
        }
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

