/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.StatementContext;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BaseActivation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BasicNoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.ArrayList;
import java.util.TreeSet;

public class ProjectRestrictResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public long restrictionTime;
    public long projectionTime;
    final NoPutResultSet source;
    public GeneratedMethod constantRestriction;
    public GeneratedMethod restriction;
    public boolean doesProjection;
    private GeneratedMethod projection;
    private int[] projectMapping;
    private boolean hasProjectMapping;
    private AbstractCompactExecRow rawRow;
    private boolean isOptimized;
    public String projectedColumns;
    private boolean runTimeStatsOn;
    private ExecRow mappedResultRow;
    public boolean reuseResult;
    private boolean shortCircuitOpen;
    private ExecRow projRow;

    ProjectRestrictResultSet(NoPutResultSet s, Activation a, GeneratedMethod r, GeneratedMethod p, int resultSetNumber, GeneratedMethod cr, int mapRefItem, boolean reuseResult, boolean doesProjection, boolean isOptimized, String projectedColumns, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(a, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = s;
        SanityManager.ASSERT((this.source != null ? 1 : 0) != 0, (String)"PRRS(), source expected to be non-null");
        this.restriction = r;
        this.projection = p;
        this.constantRestriction = cr;
        this.projectMapping = ((ReferencedColumnsDescriptorImpl)a.getSavedObject(mapRefItem)).getReferencedColumnPositions();
        this.reuseResult = reuseResult;
        this.doesProjection = doesProjection;
        if (this.projection == null) {
            this.mappedResultRow = this.activation.getExecutionFactory().getValueRow(this.projectMapping.length);
            this.hasProjectMapping = false;
            for (int col : this.projectMapping) {
                if (col == -1) continue;
                this.hasProjectMapping = true;
                break;
            }
        } else {
            boolean isProjectionMapsToStore = true;
            this.hasProjectMapping = false;
            for (int idx = 0; idx < this.projectMapping.length; ++idx) {
                int map = this.projectMapping[idx];
                if (map != -1) {
                    this.hasProjectMapping = true;
                }
                if (map == idx + 1) continue;
                isProjectionMapsToStore = false;
                if (this.hasProjectMapping) break;
            }
            this.doesProjection = !isProjectionMapsToStore;
        }
        this.isOptimized = isOptimized;
        this.projectedColumns = projectedColumns;
        this.runTimeStatsOn = this.lcc.getRunTimeStatisticsMode();
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((this.source != null ? 1 : 0) != 0, (String)"PRRS().openCore(), source expected to be non-null");
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"ProjectRestrictResultSet already open");
        this.isOpen = true;
        if (this.constantRestriction != null) {
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.constantRestriction.invoke(this.activation);
            boolean bl = constantEval = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
        }
        if (constantEval) {
            this.source.openCore();
        } else {
            this.shortCircuitOpen = true;
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        boolean constantEval = true;
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"ProjectRestrictResultSet not open, cannot reopen");
        if (this.constantRestriction != null) {
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.constantRestriction.invoke(this.activation);
            boolean bl = constantEval = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
        }
        if (constantEval) {
            this.source.reopenCore();
        } else {
            this.shortCircuitOpen = true;
        }
        this.isOpen = true;
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow candidateRow = null;
        ExecRow result = null;
        boolean restrict = false;
        long beginRT = 0L;
        if (this.shortCircuitOpen) {
            return result;
        }
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        TXState localTXState = this.localTXState;
        do {
            if ((candidateRow = this.source.getNextRowCore()) == null) continue;
            long l = beginRT = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
            if (this.restriction == null) {
                restrict = true;
            } else {
                this.setCurrentRow(candidateRow);
                DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.restriction.invoke(this.activation);
                if (this.statisticsTimingOn) {
                    this.restrictionTime += this.getElapsedNanos(beginRT);
                }
                boolean bl = restrict = !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                if (!restrict) {
                    ++this.rowsFiltered;
                    this.filteredRowLocationPostRead(localTXState);
                }
            }
            ++this.rowsSeen;
        } while (candidateRow != null && !restrict);
        if (candidateRow != null) {
            TreeSet<RegionAndKey> regionAndKeyInfo;
            beginRT = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
            result = this.doProjection(candidateRow);
            if (this.statisticsTimingOn) {
                this.projectionTime += this.getElapsedNanos(beginRT);
            }
            if ((regionAndKeyInfo = candidateRow.getAllRegionAndKeyInfo()) != null) {
                result.clearAllRegionAndKeyInfo();
                result.addAllKeys(regionAndKeyInfo);
            }
            if (localTXState != null && this.isTopResultSet && this.isForUpdate()) {
                this.updateRowLocationPostRead();
            }
        } else {
            this.clearCurrentRow();
        }
        this.currentRow = result;
        if (this.runTimeStatsOn) {
            if (!this.isTopResultSet) {
                StatementContext sc = this.lcc.getStatementContext();
                this.subqueryTrackingArray = sc.getSubqueryTrackingArray();
            }
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
        }
        return result;
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (!this.isOpen) {
            return;
        }
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.shortCircuitOpen) {
            this.shortCircuitOpen = false;
            this.source.close(cleanupOnError);
            if (this.statisticsTimingOn) {
                this.closeTime += this.getElapsedNanos(this.beginTime);
            }
            this.isOpen = false;
            return;
        }
        if (this.isOpen) {
            this.clearCurrentRow();
            this.source.close(cleanupOnError);
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of ProjectRestrictResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void finish() throws StandardException {
        this.source.finish();
        this.finishAndRTS();
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT((boolean)(this.source instanceof CursorResultSet), (String)"source is not CursorResultSet");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        ExecRow candidateRow = null;
        ExecRow result = null;
        boolean restrict = false;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"PRRS is expected to be open");
        if (this.currentRow == null) {
            return null;
        }
        candidateRow = ((CursorResultSet)((Object)this.source)).getCurrentRow();
        if (candidateRow != null) {
            this.setCurrentRow(candidateRow);
            DataValueDescriptor restrictBoolean = (DataValueDescriptor)(this.restriction == null ? null : this.restriction.invoke(this.activation));
            boolean bl = restrict = restrictBoolean == null || !restrictBoolean.isNull() && restrictBoolean.getBoolean();
        }
        if (candidateRow != null && restrict) {
            result = this.doProjection(candidateRow);
        }
        this.currentRow = result;
        if (result == null) {
            this.clearCurrentRow();
        }
        return this.currentRow;
    }

    private ExecRow doProjection(ExecRow sourceRow) throws StandardException {
        ExecRow result;
        if (this.reuseResult && this.projRow != null) {
            this.setCurrentRow(this.projRow);
            return this.projRow;
        }
        if (this.isTopResultSet && !this.doesProjection && sourceRow instanceof AbstractCompactExecRow) {
            AbstractCompactExecRow row = (AbstractCompactExecRow)sourceRow;
            if (row.nColumns() != this.projectMapping.length) {
                this.doesProjection = true;
            } else {
                if (this.rawRow == null) {
                    this.rawRow = row.getClone();
                } else {
                    this.rawRow.setRowArray(row);
                }
                AbstractCompactExecRow result2 = this.rawRow;
                this.setCurrentRow(result2);
                if (this.reuseResult) {
                    this.projRow = result2;
                }
                return result2;
            }
        }
        if (this.mappedResultRow != null) {
            result = this.mappedResultRow;
        } else {
            assert (this.projection != null);
            result = !this.isOptimized ? (ExecRow)this.projection.invoke(this.activation) : (this.mappedResultRow = (ExecRow)this.projection.invoke(this.activation));
        }
        if (this.hasProjectMapping) {
            for (int index = 0; index < this.projectMapping.length; ++index) {
                int col = this.projectMapping[index];
                if (col == -1) continue;
                result.setColumn(index + 1, sourceRow.getColumn(col));
            }
        }
        this.setCurrentRow(result);
        if (this.reuseResult) {
            this.projRow = result;
        }
        return result;
    }

    public ExecRow doBaseRowProjection(ExecRow sourceRow) throws StandardException {
        ExecRow result;
        if (this.source instanceof ProjectRestrictResultSet) {
            ProjectRestrictResultSet prs = (ProjectRestrictResultSet)this.source;
            result = prs.doBaseRowProjection(sourceRow);
        } else {
            result = sourceRow.getNewNullRow();
            result.setRowArray(sourceRow.getRowArray());
        }
        return this.doProjection(result);
    }

    public int[] getBaseProjectMapping() {
        int[] result;
        if (this.source instanceof ProjectRestrictResultSet) {
            result = new int[this.projectMapping.length];
            ProjectRestrictResultSet prs = (ProjectRestrictResultSet)this.source;
            int[] sourceMap = prs.getBaseProjectMapping();
            for (int i = 0; i < this.projectMapping.length; ++i) {
                if (this.projectMapping[i] <= 0) continue;
                result[i] = sourceMap[this.projectMapping[i] - 1];
            }
        } else {
            result = this.projectMapping;
        }
        return result;
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
        if (this.source.canUpdateInPlace()) {
            ((BaseActivation)this.activation).setProjectMapping(this.projectMapping);
        }
        this.source.updateRow(row);
    }

    @Override
    public boolean canUpdateInPlace() {
        return this.source.canUpdateInPlace();
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        this.source.markRowAsDeleted();
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.source.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.source.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return this.source.supportsMoveToNextKey();
    }

    @Override
    public int getScanKeyGroupID() {
        return this.source.getScanKeyGroupID();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        int index;
        NoPutResultSet[] subqueries = this.subqueryTrackingArray;
        int subqueryTrackingArrayLength = subqueries == null ? 0 : subqueries.length;
        int noChildren = 0;
        boolean anyAttached = false;
        for (index = 0; index < subqueryTrackingArrayLength; ++index) {
            if (subqueries[index] == null || subqueries[index].getPointOfAttachment() != this.resultSetNumber) continue;
            ++noChildren;
            anyAttached = true;
        }
        if (this.source != null) {
            ++noChildren;
        }
        visitor.setNumberOfChildren(noChildren);
        visitor.visit(this);
        if (this.source != null) {
            this.source.accept(visitor);
        }
        if (anyAttached) {
            for (index = 0; index < subqueryTrackingArrayLength; ++index) {
                if (subqueries[index] == null || subqueries[index].getPointOfAttachment() != this.resultSetNumber) continue;
                subqueries[index].accept(visitor);
            }
        }
    }

    @Override
    public void resetStatistics() {
        this.restrictionTime = 0L;
        this.projectionTime = 0L;
        super.resetStatistics();
        this.source.resetStatistics();
    }

    @Override
    public boolean isReplicateIfSetOpSupported() throws StandardException {
        SanityManager.ASSERT((boolean)(this.source instanceof BasicNoPutResultSetImpl));
        return ((BasicNoPutResultSetImpl)this.source).isReplicateIfSetOpSupported();
    }

    @Override
    public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
        this.source.setGfKeysForNCJoin(keys);
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        if (this.projectedColumns.length() > 100) {
            PlanUtils.xmlAttribute(builder, "details", this.projectedColumns.substring(0, 100));
        } else {
            PlanUtils.xmlAttribute(builder, "node_details", this.projectedColumns);
        }
        String projType = this.restriction != null && this.doesProjection ? "PROJECT-FILTER" : (this.doesProjection ? "PROJECTION" : (this.restriction != null ? "FILTER" : "PROJECT-FILTER"));
        PlanUtils.xmlTermTag(builder, context, projType);
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void releasePreviousByteSource() {
        this.source.releasePreviousByteSource();
    }

    public NoPutResultSet getSource() {
        return this.source;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null ? this.source.resultSetNumber() : -1)));
        }
    }
}

