/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.JoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;

class NestedLoopJoinResultSet
extends JoinResultSet {
    private boolean returnedRowMatchingRightSide = false;
    private ExecRow rightTemplate;
    protected boolean matchRight = false;

    @Override
    void clearScanState() {
        this.returnedRowMatchingRightSide = false;
        super.clearScanState();
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        boolean haveRow = false;
        boolean restrict = false;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (GemFireXDUtils.TraceOuterJoin) {
            SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("NestedLoopJoinResultSet::getNextRowCore this is: " + this + "(" + System.identityHashCode(this) + ") leftresultset is: " + this.leftResultSet + "(" + System.identityHashCode(this.leftResultSet) + " rightresultset is: " + this.rightResultSet + "(" + System.identityHashCode(this.rightResultSet)));
        }
        if (this.observer != null) {
            this.observer.onGetNextRowCore(this);
        }
        this.checkCancellationFlag();
        TXState localTXState = this.localTXState;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        if (!this.isRightOpen && this.leftRow != null) {
            if (this.matchRight) {
                this.matchRight = false;
            } else {
                this.leftResultSet.filteredRowLocationPostRead(localTXState);
            }
            this.leftResultSet.releasePreviousByteSource();
            this.leftRow = this.leftResultSet.getNextRowCore();
            if (this.leftRow == null) {
                this.closeRight();
            } else {
                ++this.rowsSeenLeft;
                this.openRight();
            }
        }
        while (this.leftRow != null && !haveRow) {
            this.rightResultSet.releasePreviousByteSource();
            if (this.oneRowRightSide && this.returnedRowMatchingRightSide) {
                this.rightRow = null;
                this.returnedRowMatchingRightSide = false;
            } else {
                this.rightRow = this.rightResultSet.getNextRowCore();
                if (this.notExistsRightSide) {
                    this.rightRow = this.rightRow == null ? this.rightTemplate : null;
                }
                boolean bl = this.returnedRowMatchingRightSide = this.rightRow != null;
            }
            if (this.rightRow == null) {
                if (this.matchRight) {
                    this.matchRight = false;
                } else {
                    this.leftResultSet.filteredRowLocationPostRead(localTXState);
                }
                this.leftResultSet.releasePreviousByteSource();
                this.leftRow = this.leftResultSet.getNextRowCore();
                if (this.leftRow == null) {
                    this.closeRight();
                    continue;
                }
                ++this.rowsSeenLeft;
                this.openRight();
                continue;
            }
            ++this.rowsSeenRight;
            if (this.restriction != null) {
                DataValueDescriptor restrictBoolean = (DataValueDescriptor)this.restriction.invoke(this.activation);
                boolean bl = restrict = !restrictBoolean.isNull() && restrictBoolean.getBoolean();
                if (!restrict) {
                    ++this.rowsFiltered;
                    this.rightRow.clearAllRegionAndKeyInfo();
                    this.rightResultSet.filteredRowLocationPostRead(localTXState);
                    continue;
                }
            }
            if (this.mergedRow == null) {
                this.mergedRow = this.getExecutionFactory().getValueRow(this.leftNumCols + this.rightNumCols);
            }
            int colInCtr = 1;
            int colOutCtr = 1;
            while (colInCtr <= this.leftNumCols) {
                this.mergedRow.setColumn(colOutCtr, this.leftRow.getColumn(colInCtr));
                ++colInCtr;
                ++colOutCtr;
            }
            if (!this.notExistsRightSide) {
                colInCtr = 1;
                while (colInCtr <= this.rightNumCols) {
                    this.mergedRow.setColumn(colOutCtr, this.rightRow.getColumn(colInCtr));
                    ++colInCtr;
                    ++colOutCtr;
                }
            }
            if (this.mergedRow != null) {
                this.mergedRow.clearAllRegionAndKeyInfo();
                this.mergedRow.addAllKeys(this.leftRow.getAllRegionAndKeyInfo());
                this.mergedRow.addAllKeys(this.rightRow.getAllRegionAndKeyInfo());
                this.matchRight = true;
                if (GemFireXDUtils.TraceOuterJoin) {
                    SanityManager.DEBUG_PRINT((String)"TraceOuterJoinMerge", (String)("NestedLoopJoinResultSet::getNextRowCore mergedrow is: " + this.mergedRow + "(" + System.identityHashCode(this.mergedRow) + ") and regionandkeyinfo: " + this.mergedRow.getAllRegionAndKeyInfo()));
                }
            }
            this.setCurrentRow(this.mergedRow);
            haveRow = true;
        }
        if (haveRow) {
            result = this.mergedRow;
            ++this.rowsReturned;
        } else {
            this.clearCurrentRow();
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (this.isOpen) {
            this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
            this.clearCurrentRow();
            super.close(cleanupOnError);
            this.returnedRowMatchingRightSide = false;
            this.matchRight = false;
            if (this.statisticsTimingOn) {
                this.closeTime += this.getElapsedNanos(this.beginTime);
            }
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.leftResultSet.getTimeSpent(1, timeType) - this.rightResultSet.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    NestedLoopJoinResultSet(NoPutResultSet leftResultSet, int leftNumCols, NoPutResultSet rightResultSet, int rightNumCols, Activation activation, GeneratedMethod restriction, int resultSetNumber, boolean oneRowRightSide, boolean notExistsRightSide, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String userSuppliedOptimizerOverrides, int leftResultColumnNames, int rightResultColumnNames) {
        super(leftResultSet, leftNumCols, rightResultSet, rightNumCols, activation, restriction, resultSetNumber, oneRowRightSide, notExistsRightSide, optimizerEstimatedRowCount, optimizerEstimatedCost, userSuppliedOptimizerOverrides, leftResultColumnNames, rightResultColumnNames);
        if (notExistsRightSide) {
            this.rightTemplate = this.getExecutionFactory().getValueRow(rightNumCols);
        }
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        boolean isSuccess = context.setNested();
        super.buildQueryPlan(builder, context);
        if (!isSuccess) {
            return builder;
        }
        PlanUtils.xmlTermTag(builder, context, "NLJOIN");
        this.endBuildQueryPlan(builder, context);
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    public StringBuilder endBuildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        if (this.leftResultSet != null) {
            this.leftResultSet.buildQueryPlan(builder, context.pushContext());
        }
        if (this.rightResultSet != null) {
            PlanUtils.xmlAddTag(builder, context, "Join");
            this.rightResultSet.buildQueryPlan(builder, context.pushContext());
        }
        return builder;
    }
}

