/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class LastIndexKeyResultSet
extends ScanResultSet {
    protected long conglomId;
    protected GeneratedMethod resultRowAllocator;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    protected Qualifier[][] qualifiers;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    protected boolean runTimeStatisticsOn;
    public String stopPositionString;
    public boolean coarserLock;
    public boolean returnedRow;

    public LastIndexKeyResultSet(Activation activation, int resultSetNumber, GeneratedMethod resultRowAllocator, long conglomId, String tableName, String userSuppliedOptimizerOverrides, String indexName, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(activation, resultSetNumber, resultRowAllocator, lockMode, tableLocked, isolationLevel, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.conglomId = conglomId;
        SanityManager.ASSERT((activation != null ? 1 : 0) != 0, (String)"this scan must get activation context");
        SanityManager.ASSERT((resultRowAllocator != null ? 1 : 0) != 0, (String)"this scan must get row allocator");
        this.resultRowAllocator = resultRowAllocator;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.runTimeStatisticsOn = this.getLanguageConnectionContext().getRunTimeStatisticsMode();
        if (SanityManager.DEBUG_ON((String)"ScanTrace")) {
            // empty if block
        }
        activation.informOfRowCount(this, 1L);
        this.recordConstructorTime();
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return true;
    }

    @Override
    public void openCore() throws StandardException {
        ExecRow candidateCopy = this.candidate.getClone();
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"LastIndexKeyResultSet already open");
        this.isOpen = true;
        TransactionController tc = this.activation.getTransactionController();
        this.initIsolationLevel();
        if (tc.fetchMaxOnBtree(this.conglomId, 0, this.lockMode, this.isolationLevel, this.accessedCols, candidateCopy.getRowArray())) {
            this.setCurrentRow(this.getCompactRow(candidateCopy, this.accessedCols, true));
        } else {
            this.clearCurrentRow();
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (this.returnedRow || !this.isOpen) {
            this.clearCurrentRow();
        } else {
            this.returnedRow = true;
        }
        return this.currentRow;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.returnedRow = false;
            this.clearCurrentRow();
            super.close(cleanupOnError);
            this.isOpen = false;
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of LastIndexKeyResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long totTime = this.constructorTime + this.openTime + this.nextTime + this.closeTime;
        if (type == 0) {
            return totTime;
        }
        return totTime - this.constructorTime;
    }

    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        if (this.tableName != null) {
            PlanUtils.xmlAttribute(builder, "tableName", this.tableName);
        }
        if (this.indexName != null) {
            PlanUtils.xmlAttribute(builder, "indexName", this.indexName);
        }
        if (this.userSuppliedOptimizerOverrides != null) {
            PlanUtils.xmlAttribute(builder, "userSuppliedOptimizerOverrides", this.userSuppliedOptimizerOverrides);
        }
        PlanUtils.xmlTermTag(builder, context, "LASTINDEXKEYSCAN");
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }
}

