/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.FileInfoDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.FileResource;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.util.IdUtil;
import com.pivotal.gemfirexd.internal.impl.services.reflect.JarLoader;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public class GfxdRemoteJarUtil {
    private final LanguageConnectionContext lcc;
    private final String schemaName;
    private final String sqlName;
    private final FileResource fr;
    private final DataDictionary dd;
    private final DataDescriptorGenerator ddg;
    private long newId;
    private long oldId;

    private GfxdRemoteJarUtil(LanguageConnectionContext lcc, String schemaName, String sqlName) throws StandardException {
        this.schemaName = schemaName;
        this.sqlName = sqlName;
        this.lcc = lcc;
        this.fr = lcc.getTransactionExecute().getFileHandler();
        this.dd = lcc.getDataDictionary();
        this.ddg = this.dd.getDataDescriptorGenerator();
    }

    public static long install(LanguageConnectionContext lcc, String schemaName, String sqlName, long id) throws StandardException {
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdRemoteJarUtil: install called for " + schemaName + ":" + sqlName + " id is " + id), (Throwable)new Exception());
        }
        GfxdRemoteJarUtil jutil = new GfxdRemoteJarUtil(lcc, schemaName, sqlName);
        jutil.setId(id);
        return jutil.add();
    }

    private void setId(long id) {
        this.newId = id;
    }

    private void setOldId(long id) {
        this.oldId = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long add() throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid != null) {
            throw StandardException.newException("X0Y32.S", fid.getDescriptorType(), (Object)this.sqlName, (Object)fid.getSchemaDescriptor().getDescriptorType(), (Object)this.schemaName);
        }
        SchemaDescriptor sd = this.getSchemaDescriptor();
        try {
            if (GemFireXDUtils.TraceApplicationJars) {
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdRemoteJarUtil: add notifying classpath change for " + this.schemaName + ":" + this.sqlName));
            }
            this.notifyClassPathChange(this.schemaName + "." + this.sqlName, 0);
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            String fullName = this.schemaName + "." + this.sqlName;
            this.setJar(fullName, this.newId, true, 0L);
            fid = this.ddg.newFileInfoDescriptor(null, sd, this.sqlName, this.newId);
            this.dd.addDescriptor(fid, sd, 12, false, this.lcc.getTransactionExecute());
            long l = this.newId;
            return l;
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static void drop(LanguageConnectionContext lcc, String schemaName, String sqlName, long id) throws StandardException {
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdRemoteJarUtil: drop called for " + schemaName + ":" + sqlName + " with id " + id));
        }
        GfxdRemoteJarUtil jutil = new GfxdRemoteJarUtil(lcc, schemaName, sqlName);
        jutil.setOldId(id);
        jutil.drop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drop() throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)this.sqlName, (Object)this.schemaName);
        }
        String dbcp_s = PropertyUtil.getServiceProperty(this.lcc.getTransactionExecute(), "gemfirexd.distributedsystem.classpath");
        if (dbcp_s != null) {
            String[][] dbcp = IdUtil.parseDbClassPath(dbcp_s);
            boolean found = false;
            for (int ix = 0; ix < dbcp.length; ++ix) {
                if (dbcp.length != 2 || !dbcp[ix][0].equals(this.schemaName) || !dbcp[ix][1].equals(this.sqlName)) continue;
                found = true;
            }
            if (found) {
                throw StandardException.newException("X0X07.S", (Object)IdUtil.mkQualifiedName(this.schemaName, this.sqlName), (Object)dbcp_s);
            }
        }
        try {
            if (GemFireXDUtils.TraceApplicationJars) {
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdRemoteJarUtil: drop notifying classpath change for " + this.schemaName + ":" + this.sqlName));
            }
            this.closeOldJarLoader(this.schemaName, this.sqlName);
            this.notifyClassPathChange(this.schemaName + "." + this.sqlName, 1);
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            DependencyManager dm = this.dd.getDependencyManager();
            dm.invalidateFor(fid, 17, this.lcc);
            this.dd.dropFileInfoDescriptor(fid);
            this.fr.remove(this.schemaName + "." + this.sqlName, this.oldId, true);
        }
        finally {
            this.notifyLoader(true);
        }
    }

    public static long replace(LanguageConnectionContext lcc, String schemaName, String sqlName, long newId, long oldId) throws StandardException {
        if (GemFireXDUtils.TraceApplicationJars) {
            SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdRemoteJarUtil: replace called for " + schemaName + ":" + sqlName + " with new id " + newId + " old id " + oldId));
        }
        GfxdRemoteJarUtil jutil = new GfxdRemoteJarUtil(lcc, schemaName, sqlName);
        jutil.setId(newId);
        jutil.setOldId(oldId);
        jutil.replace();
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replace() throws StandardException {
        this.dd.startWriting(this.lcc);
        FileInfoDescriptor fid = this.getInfo();
        if (fid == null) {
            throw StandardException.newException("X0X13.S", (Object)this.sqlName, (Object)this.schemaName);
        }
        JarLoader oldLoader = null;
        boolean loaderNotified = false;
        try {
            oldLoader = this.closeOldJarLoader(this.schemaName, this.sqlName);
            this.notifyLoader(false);
            this.dd.invalidateAllSPSPlans();
            this.dd.dropFileInfoDescriptor(fid);
            String fullName = this.schemaName + "." + this.sqlName;
            this.setJar(fullName, this.newId, false, this.oldId);
            this.notifyClassPathChange(this.schemaName + "." + this.sqlName, 2);
            FileInfoDescriptor fid2 = this.ddg.newFileInfoDescriptor(fid.getUUID(), fid.getSchemaDescriptor(), this.sqlName, this.newId);
            this.dd.addDescriptor(fid2, fid.getSchemaDescriptor(), 12, false, this.lcc.getTransactionExecute());
            this.notifyLoader(true);
            loaderNotified = true;
            oldLoader.refreshDependents();
            long l = this.newId;
            return l;
        }
        finally {
            if (!loaderNotified) {
                this.notifyLoader(true);
            }
        }
    }

    private FileInfoDescriptor getInfo() throws StandardException {
        return this.dd.getFileInfoDescriptor(this.getSchemaDescriptor(), this.sqlName);
    }

    private SchemaDescriptor getSchemaDescriptor() throws StandardException {
        GemFireStore memStore = Misc.getMemStoreBooting();
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(this.schemaName, null, !memStore.initialDDLReplayInProgress());
        if (sd == null || sd.getUUID() == null) {
            UUID tmpSchemaId = this.dd.getUUIDFactory().createUUID();
            TransactionController tc = this.lcc.getTransactionExecute();
            sd = this.ddg.newSchemaDescriptor(this.schemaName, this.lcc.getAuthorizationId(), tmpSchemaId);
            this.dd.addDescriptor(sd, null, 3, false, tc);
            memStore.createSchemaRegion(this.schemaName, tc);
        }
        return sd;
    }

    private void notifyLoader(boolean reload) throws StandardException {
        ClassFactory cf = this.lcc.getLanguageConnectionFactory().getClassFactory();
        cf.notifyModifyJar(reload);
    }

    private void notifyClassPathChange(String name, int jar_opType) {
        ClassFactory cf = this.lcc.getLanguageConnectionFactory().getClassFactory();
        cf.notifyModifyClasspath(name, jar_opType);
    }

    private JarLoader closeOldJarLoader(String schemaName, String sqlName) {
        ClassFactory cf = this.lcc.getLanguageConnectionFactory().getClassFactory();
        return cf.closeJarLoader(schemaName, sqlName);
    }

    private long setJar(final String jarExternalName, final long newId, final boolean add, final long oldId) throws StandardException {
        try {
            if (GemFireXDUtils.TraceApplicationJars) {
                SanityManager.DEBUG_PRINT((String)"TraceJars", (String)("GfxdRemoteJarUtil: set jar called for " + jarExternalName + " with new id " + newId + " add is " + add + " old id is " + oldId));
            }
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Long>(){

                @Override
                public Long run() throws StandardException {
                    if (add) {
                        GfxdRemoteJarUtil.this.fr.add(jarExternalName, null, newId);
                    } else {
                        GfxdRemoteJarUtil.this.fr.replace(jarExternalName, oldId, newId, null);
                    }
                    return oldId;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (StandardException)e.getException();
        }
    }
}

