/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.RoleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

class DropRoleConstantAction
extends DDLConstantAction {
    private final String roleName;

    DropRoleConstantAction(String roleName) {
        this.roleName = roleName;
    }

    public String toString() {
        return "DROP ROLE " + this.roleName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        RoleDescriptor rd = dd.getRoleDefinitionDescriptor(this.roleName);
        if (rd == null) {
            throw StandardException.newException("0P000", this.roleName);
        }
        rd.drop(lcc);
        dd.dropRoleGrantsByGrantee(this.roleName, tc);
        dd.dropRoleGrantsByName(this.roleName, tc);
        dd.dropAllPermsByGrantee(this.roleName, tc);
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

