/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.OrderByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SingleChildResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import java.util.Properties;
import java.util.Vector;

public class WindowNode
extends SingleChildResultSetNode {
    private String windowName;
    private ResultColumnList partitionDefinition;
    private OrderByList orderByList;
    private Object frameDefinition;
    private int windowFunctionLevel;
    private Properties tableProperties;
    private int numTables;

    @Override
    public void init(Object windowName, Object partitionDefinition, Object orderByList, Object frameDefinition) throws StandardException {
        this.windowName = (String)windowName;
        this.partitionDefinition = (ResultColumnList)partitionDefinition;
        this.orderByList = (OrderByList)orderByList;
        this.frameDefinition = frameDefinition;
        this.windowFunctionLevel = -1;
    }

    public ResultSetNode preprocess(int numTables, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        this.numTables = numTables;
        this.referencedTableMap = new JBitSet(numTables);
        int flSize = fromList.size();
        for (int index = 0; index < flSize; ++index) {
            this.referencedTableMap.or(((FromTable)fromList.elementAt(index)).getReferencedTableMap());
        }
        return this;
    }

    public WindowNode bind(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        return this;
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        int rclSize = this.resultColumns.size();
        FormatableBitSet referencedCols = new FormatableBitSet(rclSize);
        int erdNumber = -1;
        int numSet = 0;
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        acb.pushGetResultSetFactoryExpression(mb);
        int skip = 0;
        for (int index = rclSize - 1; index >= 0; --index) {
            ResultColumn rc = (ResultColumn)this.resultColumns.elementAt(index);
            if (rc.isWindowFunction() && skip < this.windowFunctionLevel) {
                ++skip;
                continue;
            }
            referencedCols.set(index);
            ++numSet;
        }
        erdNumber = acb.addItem(referencedCols);
        acb.pushThisAsActivation(mb);
        this.childResult.generate(acb, mb);
        mb.upCast("com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet");
        this.resultColumns.generateHolder(acb, mb);
        mb.push(this.resultSetNumber);
        mb.push(this.windowFunctionLevel);
        mb.push(erdNumber);
        mb.pushNull("com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod");
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getWindowResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 9);
        if (this.cursorTargetTable) {
            acb.rememberCursorTarget(mb);
        }
    }

    @Override
    public ResultSetNode considerMaterialization(JBitSet outerTables) throws StandardException {
        return this;
    }

    @Override
    public boolean performMaterialization(JBitSet outerTables) throws StandardException {
        return false;
    }

    public int getWindowFunctionLevel() {
        return this.windowFunctionLevel;
    }

    public void setWindowFunctionLevel(int level) {
        this.windowFunctionLevel = level;
    }
}

