/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gnu.trove.THashSet;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.compile.DistributedJoinStrategy;
import com.pivotal.gemfirexd.internal.engine.sql.compile.RemapSubqueryVisitor;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.AccessPath;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CompilerContext;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.JoinStrategy;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizableList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RequiredRowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.BaseTableNumbersVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CostEstimateImpl;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.Predicate;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowOrderingImpl;
import java.util.ArrayList;
import java.util.HashMap;

public class OptimizerImpl
implements Optimizer {
    DataDictionary dDictionary;
    int numTablesInQuery;
    int numOptimizables;
    protected JBitSet assignedTableMap;
    protected OptimizableList optimizableList;
    OptimizablePredicateList predicateList;
    JBitSet nonCorrelatedTableMap;
    protected int[] proposedJoinOrder;
    protected int[] bestJoinOrder;
    protected int joinPosition;
    boolean desiredJoinOrderFound;
    protected ArrayList<JBitSet> colocatedTableGrp;
    protected JBitSet replicatedTableGrp;
    protected volatile int driverTableIdx;
    protected volatile int bestJoinOrderDriverTableIdx;
    protected ArrayList<JBitSet> bestJoinOrderColocatedTableGrp;
    protected ArrayList<THashSet> bestJoinOrderColocatedPrCorrName;
    protected int bestJoinOrderDriverTablePrID;
    private static final int NO_JUMP = 0;
    private static final int READY_TO_JUMP = 1;
    private static final int JUMPING = 2;
    private static final int WALK_HIGH = 3;
    private static final int WALK_LOW = 4;
    private int permuteState;
    private int[] firstLookOrder;
    private final boolean ruleBasedOptimization;
    private final CostEstimateImpl outermostCostEstimate;
    protected CostEstimateImpl currentCost;
    protected CostEstimateImpl currentSortAvoidanceCost;
    protected CostEstimateImpl bestCost;
    private boolean bestPlanIsSortAvoidance = false;
    protected long timeOptimizationStarted;
    protected long currentTime;
    protected boolean timeExceeded;
    private final boolean noTimeout;
    private final boolean useStatistics;
    private final int tableLockThreshold;
    private final JoinStrategy[] joinStrategies;
    protected RequiredRowOrdering requiredRowOrdering;
    private boolean foundABestPlan;
    protected CostEstimate sortCost;
    private final RowOrdering currentRowOrdering = new RowOrderingImpl();
    private final RowOrdering bestRowOrdering = new RowOrderingImpl();
    private boolean conglomerate_OneRowResultSet;
    protected boolean optimizerTrace;
    protected boolean optimizerTraceHtml;
    protected int maxMemoryPerTable;
    private boolean reloadBestPlan;
    private HashMap savedJoinOrders;
    protected double timeLimit;
    CostEstimate finalCostEstimate;
    private boolean usingPredsPushedFromAbove;
    private boolean bestJoinOrderUsedPredsFromAbove;
    private boolean allReplicatedTables;
    private boolean createQueryInfo;
    private final boolean isLoner;
    private final DistributedJoinStrategy[] distJoinStrategies;

    protected OptimizerImpl(OptimizableList optimizableList, OptimizablePredicateList predicateList, DataDictionary dDictionary, boolean ruleBasedOptimization, boolean noTimeout, boolean useStatistics, int maxMemoryPerTable, JoinStrategy[] joinStrategies, DistributedJoinStrategy[] distJoinStrategies, int tableLockThreshold, RequiredRowOrdering requiredRowOrdering, int numTablesInQuery) throws StandardException {
        SanityManager.ASSERT((optimizableList != null ? 1 : 0) != 0, (String)"optimizableList is not expected to be null");
        this.outermostCostEstimate = this.getNewCostEstimate(0.0, 1.0, 1.0);
        this.currentCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost = this.getNewCostEstimate(0.0, 0.0, 0.0);
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        optimizableList.verifyProperties(dDictionary);
        this.numTablesInQuery = numTablesInQuery;
        this.numOptimizables = optimizableList.size();
        this.proposedJoinOrder = new int[this.numOptimizables];
        if (numTablesInQuery > 6) {
            this.permuteState = 1;
            this.firstLookOrder = new int[this.numOptimizables];
        } else {
            this.permuteState = 0;
        }
        for (int i = 0; i < this.numOptimizables; ++i) {
            this.proposedJoinOrder[i] = -1;
        }
        this.bestJoinOrder = new int[this.numOptimizables];
        this.joinPosition = -1;
        this.optimizableList = optimizableList;
        this.predicateList = predicateList;
        this.dDictionary = dDictionary;
        this.ruleBasedOptimization = ruleBasedOptimization;
        this.noTimeout = noTimeout;
        this.maxMemoryPerTable = maxMemoryPerTable;
        this.joinStrategies = joinStrategies;
        this.tableLockThreshold = tableLockThreshold;
        this.requiredRowOrdering = requiredRowOrdering;
        this.useStatistics = useStatistics;
        this.assignedTableMap = new JBitSet(numTablesInQuery);
        this.nonCorrelatedTableMap = new JBitSet(numTablesInQuery);
        for (int tabCtr = 0; tabCtr < this.numOptimizables; ++tabCtr) {
            Optimizable curTable = optimizableList.getOptimizable(tabCtr);
            this.nonCorrelatedTableMap.or(curTable.getReferencedTableMap());
        }
        CompilerContext cc = (CompilerContext)ContextService.getContextOrNull("CompilerContext");
        boolean doDistJoinStrategy = false;
        if (cc != null) {
            this.createQueryInfo = cc.createQueryInfo();
            this.allReplicatedTables = cc.allTablesAreReplicatedOnRemote();
            if (Boolean.parseBoolean(PropertyUtil.getSystemProperty(GfxdConstants.OPTIMIZE_NON_COLOCATED_JOIN, "false")) && this.createQueryInfo) {
                doDistJoinStrategy = true;
            }
        }
        this.distJoinStrategies = doDistJoinStrategy ? distJoinStrategies : null;
        this.colocatedTableGrp = new ArrayList(this.numOptimizables);
        this.replicatedTableGrp = new JBitSet(this.numOptimizables);
        this.bestJoinOrderColocatedTableGrp = new ArrayList(this.numOptimizables);
        this.bestJoinOrderColocatedPrCorrName = new ArrayList();
        this.driverTableIdx = 0;
        this.isLoner = Misc.getDistributedSystem().isLoner();
        this.timeOptimizationStarted = System.currentTimeMillis();
        this.reloadBestPlan = false;
        this.savedJoinOrders = null;
        this.timeLimit = Double.MAX_VALUE;
        this.usingPredsPushedFromAbove = false;
        this.bestJoinOrderUsedPredsFromAbove = false;
    }

    @Override
    public void prepForNextRound() {
        this.reloadBestPlan = false;
        this.bestCost = this.getNewCostEstimate(Double.MAX_VALUE, Double.MAX_VALUE, Double.MAX_VALUE);
        this.usingPredsPushedFromAbove = false;
        if (this.predicateList != null && this.predicateList.size() > 0) {
            for (int i = this.predicateList.size() - 1; i >= 0; --i) {
                if (!((Predicate)this.predicateList.getOptPredicate(i)).isScopedForPush()) continue;
                this.usingPredsPushedFromAbove = true;
                break;
            }
        }
        if (this.usingPredsPushedFromAbove) {
            this.timeOptimizationStarted = System.currentTimeMillis();
            this.timeExceeded = false;
        }
        this.desiredJoinOrderFound = false;
    }

    @Override
    public int getMaxMemoryPerTable() {
        return this.maxMemoryPerTable;
    }

    @Override
    public boolean getNextPermutation() throws StandardException {
        boolean alreadyCostsMore;
        if (this.numOptimizables < 1) {
            if (this.optimizerTrace) {
                this.trace(3, 0, 0, 0.0, null);
            }
            this.endOfRoundCleanup();
            return false;
        }
        this.optimizableList.initAccessPaths(this);
        if (!this.timeExceeded && this.numTablesInQuery > 6 && !this.noTimeout) {
            this.currentTime = System.currentTimeMillis();
            boolean bl = this.timeExceeded = (double)(this.currentTime - this.timeOptimizationStarted) > this.timeLimit;
            if (this.optimizerTrace && this.timeExceeded) {
                this.trace(2, 0, 0, 0.0, null);
            }
        }
        if (this.bestCost.isUninitialized() && this.foundABestPlan && (!this.usingPredsPushedFromAbove && !this.bestJoinOrderUsedPredsFromAbove || this.timeExceeded)) {
            if (this.permuteState != 2) {
                if (this.firstLookOrder == null) {
                    this.firstLookOrder = new int[this.numOptimizables];
                }
                for (int i = 0; i < this.numOptimizables; ++i) {
                    this.firstLookOrder[i] = this.bestJoinOrder[i];
                }
                this.permuteState = 2;
                if (this.joinPosition >= 0) {
                    this.rewindJoinOrder();
                    this.joinPosition = -1;
                }
            }
            this.timeExceeded = false;
        }
        boolean joinPosAdvanced = false;
        boolean bl = alreadyCostsMore = !this.bestCost.isUninitialized() && this.currentCost.compare(this.bestCost) > 0.0 && (this.requiredRowOrdering == null || this.currentSortAvoidanceCost.compare(this.bestCost) > 0.0);
        if (this.joinPosition < this.numOptimizables - 1 && !alreadyCostsMore && !this.timeExceeded) {
            if (this.joinPosition < 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]).getBestAccessPath().getCostEstimate() != null) {
                ++this.joinPosition;
                joinPosAdvanced = true;
                this.bestRowOrdering.copy(this.currentRowOrdering);
            }
        } else {
            if (this.optimizerTrace && this.joinPosition < this.numOptimizables - 1) {
                this.trace(8, 0, 0, 0.0, null);
            }
            if (this.joinPosition < this.numOptimizables - 1) {
                this.reloadBestPlan = true;
            }
        }
        if (this.permuteState == 2 && !joinPosAdvanced && this.joinPosition >= 0) {
            this.reloadBestPlan = true;
            this.rewindJoinOrder();
            this.permuteState = 0;
        }
        while (this.joinPosition >= 0) {
            int i;
            int nextOptimizable = this.proposedJoinOrder[this.joinPosition] + 1;
            if (this.proposedJoinOrder[this.joinPosition] >= 0) {
                this.pullOptimizableFromJoinOrder();
            }
            if (this.desiredJoinOrderFound || this.timeExceeded) {
                nextOptimizable = this.numOptimizables;
            } else if (this.permuteState == 2) {
                int idealOptimizable;
                nextOptimizable = idealOptimizable = this.firstLookOrder[this.joinPosition];
                int lookPos = this.numOptimizables;
                int lastSwappedOpt = -1;
                Optimizable nextOpt = this.optimizableList.getOptimizable(nextOptimizable);
                while (!nextOpt.legalJoinOrder(this.assignedTableMap)) {
                    if (lastSwappedOpt >= 0) {
                        this.firstLookOrder[this.joinPosition] = idealOptimizable;
                        this.firstLookOrder[lookPos] = lastSwappedOpt;
                    }
                    if (lookPos <= this.joinPosition + 1) {
                        if (this.joinPosition > 0) {
                            --this.joinPosition;
                            this.reloadBestPlan = true;
                            this.rewindJoinOrder();
                        }
                        this.permuteState = 0;
                        break;
                    }
                    this.firstLookOrder[this.joinPosition] = lastSwappedOpt = this.firstLookOrder[--lookPos];
                    this.firstLookOrder[lookPos] = idealOptimizable;
                    nextOptimizable = lastSwappedOpt;
                    nextOpt = this.optimizableList.getOptimizable(nextOptimizable);
                }
                if (this.permuteState == 0) continue;
                if (this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 3;
                }
            } else {
                while (nextOptimizable < this.numOptimizables) {
                    boolean found = false;
                    for (int posn = 0; posn < this.joinPosition; ++posn) {
                        if (this.proposedJoinOrder[posn] != nextOptimizable) continue;
                        found = true;
                        break;
                    }
                    if (found) {
                        if (nextOptimizable < this.numOptimizables && !this.joinOrderMeetsDependencies(nextOptimizable)) {
                            SanityManager.THROWASSERT((String)("Found optimizable '" + nextOptimizable + "' in current join order even though its dependencies were NOT satisfied."));
                        }
                    } else {
                        if (nextOptimizable >= this.numOptimizables || this.joinOrderMeetsDependencies(nextOptimizable)) break;
                        if (this.optimizerTrace) {
                            this.trace(9, nextOptimizable, 0, 0.0, null);
                        }
                        if (!this.optimizableList.optimizeJoinOrder()) {
                            if (this.optimizerTrace) {
                                this.trace(10, 0, 0, 0.0, null);
                            }
                            throw StandardException.newException("42Y70");
                        }
                    }
                    ++nextOptimizable;
                }
            }
            if (nextOptimizable >= this.numOptimizables) {
                if (!this.optimizableList.optimizeJoinOrder()) {
                    if (!this.optimizableList.legalJoinOrder(this.numTablesInQuery)) {
                        if (this.optimizerTrace) {
                            this.trace(10, 0, 0, 0.0, null);
                        }
                        throw StandardException.newException("42Y70");
                    }
                    if (this.optimizerTrace) {
                        this.trace(11, 0, 0, 0.0, null);
                    }
                    this.desiredJoinOrderFound = true;
                }
                if (this.permuteState == 1 && this.joinPosition > 0 && this.joinPosition == this.numOptimizables - 1) {
                    this.permuteState = 2;
                    double[] rc = new double[this.numOptimizables];
                    for (i = 0; i < this.numOptimizables; ++i) {
                        this.firstLookOrder[i] = i;
                        CostEstimate ce = this.optimizableList.getOptimizable(i).getBestAccessPath().getCostEstimate();
                        if (ce == null) {
                            this.permuteState = 1;
                            break;
                        }
                        rc[i] = ce.singleScanRowCount();
                    }
                    if (this.permuteState == 2) {
                        boolean doIt = false;
                        for (int i2 = 0; i2 < this.numOptimizables; ++i2) {
                            int k = i2;
                            for (int j = i2 + 1; j < this.numOptimizables; ++j) {
                                if (!(rc[j] < rc[k])) continue;
                                k = j;
                            }
                            if (k == i2) continue;
                            rc[k] = rc[i2];
                            int temp = this.firstLookOrder[i2];
                            this.firstLookOrder[i2] = this.firstLookOrder[k];
                            this.firstLookOrder[k] = temp;
                            doIt = true;
                        }
                        if (doIt) {
                            --this.joinPosition;
                            this.rewindJoinOrder();
                            continue;
                        }
                        this.permuteState = 0;
                    }
                }
                --this.joinPosition;
                if (this.joinPosition >= 0 || this.permuteState != 3) continue;
                this.joinPosition = 0;
                this.permuteState = 4;
                continue;
            }
            this.proposedJoinOrder[this.joinPosition] = nextOptimizable;
            if (this.permuteState == 4) {
                boolean finishedCycle = true;
                for (i = 0; i < this.numOptimizables; ++i) {
                    if (this.proposedJoinOrder[i] < this.firstLookOrder[i]) {
                        finishedCycle = false;
                        break;
                    }
                    if (this.proposedJoinOrder[i] > this.firstLookOrder[i]) break;
                }
                if (finishedCycle) {
                    this.proposedJoinOrder[this.joinPosition] = -1;
                    --this.joinPosition;
                    if (this.joinPosition >= 0) {
                        this.reloadBestPlan = true;
                        this.rewindJoinOrder();
                        this.joinPosition = -1;
                    }
                    this.permuteState = 1;
                    this.endOfRoundCleanup();
                    return false;
                }
            }
            this.optimizableList.getOptimizable(nextOptimizable).getBestAccessPath().setCostEstimate(null);
            if (this.optimizerTrace) {
                this.trace(12, 0, 0, 0.0, null);
            }
            Optimizable nextOpt = this.optimizableList.getOptimizable(nextOptimizable);
            JBitSet optMap = (JBitSet)nextOpt.getReferencedTableMap().clone();
            optMap.and(this.assignedTableMap);
            if (optMap.getFirstSetBit() != -1) {
                SanityManager.THROWASSERT((String)("Found multiple optimizables that share one or more referenced table numbers (esp: '" + optMap + "'), but that should not be the case."));
            }
            this.assignedTableMap.or(nextOpt.getReferencedTableMap());
            nextOpt.startOptimizing(this, this.currentRowOrdering);
            JBitSet tablesNoCorr = this.identifyTablesForSubqueryPush(this.proposedJoinOrder, this.joinPosition);
            int tableNum = this.getTableNumber(nextOpt);
            this.pushPredicates(this.optimizableList.getOptimizable(nextOptimizable), this.assignedTableMap, tableNum >= 0 && tablesNoCorr.get(tableNum), false);
            return true;
        }
        this.endOfRoundCleanup();
        return false;
    }

    private void rewindJoinOrder() throws StandardException {
        while (true) {
            Optimizable pullMe = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
            pullMe.pullOptPredicates(this.predicateList, this.assignedTableMap);
            if (this.reloadBestPlan) {
                pullMe.updateBestPlanMap((short)2, this);
            }
            this.proposedJoinOrder[this.joinPosition] = -1;
            if (this.joinPosition == 0) break;
            --this.joinPosition;
        }
        this.currentCost.setCost(0.0, 0.0, 0.0);
        this.currentSortAvoidanceCost.setCost(0.0, 0.0, 0.0);
        this.assignedTableMap.clearAll();
    }

    private void endOfRoundCleanup() throws StandardException {
        for (int i = 0; i < this.numOptimizables; ++i) {
            this.optimizableList.getOptimizable(i).updateBestPlanMap((short)0, this);
        }
    }

    private double recoverCostFromProposedJoinOrder(boolean sortAvoidance) throws StandardException {
        double recoveredCost = 0.0;
        for (int i = 0; i < this.joinPosition; ++i) {
            if (sortAvoidance) {
                recoveredCost += this.optimizableList.getOptimizable(this.proposedJoinOrder[i]).getBestSortAvoidancePath().getCostEstimate().getEstimatedCost();
                continue;
            }
            recoveredCost += this.optimizableList.getOptimizable(this.proposedJoinOrder[i]).getBestAccessPath().getCostEstimate().getEstimatedCost();
        }
        return recoveredCost;
    }

    private boolean joinOrderMeetsDependencies(int optNumber) throws StandardException {
        Optimizable nextOpt = this.optimizableList.getOptimizable(optNumber);
        return nextOpt.legalJoinOrder(this.assignedTableMap);
    }

    private void pullOptimizableFromJoinOrder() throws StandardException {
        double prevSingleScanRowCount;
        double prevRowCount;
        Optimizable pullMe = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        int prevPosition = 0;
        if (this.joinPosition == 0) {
            prevRowCount = this.outermostCostEstimate.rowCount();
            prevSingleScanRowCount = this.outermostCostEstimate.singleScanRowCount();
        } else {
            prevPosition = this.proposedJoinOrder[this.joinPosition - 1];
            CostEstimate localCE = this.optimizableList.getOptimizable(prevPosition).getBestAccessPath().getCostEstimate();
            prevRowCount = localCE.rowCount();
            prevSingleScanRowCount = localCE.singleScanRowCount();
        }
        double newCost = this.currentCost.getEstimatedCost();
        double pullCost = 0.0;
        CostEstimate pullCostEstimate = pullMe.getBestAccessPath().getCostEstimate();
        if (pullCostEstimate != null && (newCost -= (pullCost = pullCostEstimate.getEstimatedCost())) <= 0.0) {
            newCost = this.joinPosition == 0 ? 0.0 : this.recoverCostFromProposedJoinOrder(false);
        }
        if (this.joinPosition == 0) {
            newCost = this.outermostCostEstimate != null ? this.outermostCostEstimate.getEstimatedCost() : 0.0;
        }
        this.currentCost.setCost(newCost, prevRowCount, prevSingleScanRowCount);
        if (this.requiredRowOrdering != null && pullMe.considerSortAvoidancePath()) {
            AccessPath ap = pullMe.getBestSortAvoidancePath();
            double prevEstimatedCost = 0.0;
            if (this.joinPosition == 0) {
                prevRowCount = this.outermostCostEstimate.rowCount();
                prevSingleScanRowCount = this.outermostCostEstimate.singleScanRowCount();
                prevEstimatedCost = this.outermostCostEstimate.getEstimatedCost();
            } else {
                CostEstimate localCE = this.optimizableList.getOptimizable(prevPosition).getBestSortAvoidancePath().getCostEstimate();
                prevRowCount = localCE.rowCount();
                prevSingleScanRowCount = localCE.singleScanRowCount();
                prevEstimatedCost = this.currentSortAvoidanceCost.getEstimatedCost() - ap.getCostEstimate().getEstimatedCost();
            }
            if (prevEstimatedCost <= 0.0) {
                prevEstimatedCost = this.joinPosition == 0 ? 0.0 : this.recoverCostFromProposedJoinOrder(true);
            }
            this.currentSortAvoidanceCost.setCost(prevEstimatedCost, prevRowCount, prevSingleScanRowCount);
            this.bestRowOrdering.removeOptimizable(pullMe.getTableNumber());
            this.bestRowOrdering.copy(this.currentRowOrdering);
        }
        pullMe.pullOptPredicates(this.predicateList, this.assignedTableMap);
        if (this.reloadBestPlan) {
            pullMe.updateBestPlanMap((short)2, this);
        }
        this.proposedJoinOrder[this.joinPosition] = -1;
        this.assignedTableMap.xor(pullMe.getReferencedTableMap());
    }

    void pushPredicates(Optimizable curTable, JBitSet outerTables, boolean pushDeemedNonpushables, boolean finalRemap) throws StandardException {
        int numPreds = this.predicateList.size();
        JBitSet predMap = new JBitSet(this.numTablesInQuery);
        JBitSet curTableNums = null;
        BaseTableNumbersVisitor btnVis = null;
        boolean pushPredNow = false;
        for (int predCtr = numPreds - 1; predCtr >= 0; --predCtr) {
            int index;
            Predicate pred = (Predicate)this.predicateList.getOptPredicate(predCtr);
            if (!this.isPushable(pred, pushDeemedNonpushables)) continue;
            predMap.setTo(pred.getReferencedMap());
            int numTablesInPred = predMap.size();
            int numTablesInQuery = this.nonCorrelatedTableMap.size();
            for (index = 0; index < numTablesInPred; ++index) {
                if (!predMap.get(index) || numTablesInQuery > index && this.nonCorrelatedTableMap.get(index)) continue;
                predMap.clear(index);
            }
            for (index = 0; index < predMap.size(); ++index) {
                if (!outerTables.get(index)) continue;
                predMap.clear(index);
            }
            predMap.and(this.nonCorrelatedTableMap);
            boolean bl = pushPredNow = predMap.getFirstSetBit() == -1;
            if (pushPredNow && pred.isScopedForPush() && this.numOptimizables > 1) {
                if (btnVis == null) {
                    curTableNums = new JBitSet(numTablesInQuery);
                    btnVis = new BaseTableNumbersVisitor(curTableNums);
                }
                int tNum = ((FromTable)curTable).getTableNumber();
                curTableNums.clearAll();
                btnVis.setTableMap(curTableNums);
                ((FromTable)curTable).accept(btnVis);
                if (tNum >= 0) {
                    curTableNums.set(tNum);
                }
                btnVis.setTableMap(predMap);
                pred.accept(btnVis);
                predMap.and(curTableNums);
                if (predMap.getFirstSetBit() == -1) {
                    pushPredNow = false;
                }
            }
            if (!pushPredNow || !curTable.pushOptPredicate(pred)) continue;
            if (pred.hasSubquery()) {
                this.remapSubqueryPredicate(curTable, pred, outerTables, finalRemap);
            }
            this.predicateList.removeOptPredicate(predCtr);
        }
    }

    private void remapSubqueryPredicate(Optimizable optimizable, Predicate pred, JBitSet outerTables, boolean finalRemap) throws StandardException {
        RemapSubqueryVisitor subqueryColRemapper = new RemapSubqueryVisitor(true, outerTables, finalRemap);
        pred.getAndNode().accept(subqueryColRemapper);
    }

    @Override
    public boolean getNextDecoratedPermutation() throws StandardException {
        Optimizable curOpt = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        double originalRowCount = 0.0;
        boolean retval = curOpt.nextAccessPath(this, null, this.currentRowOrdering);
        if (curOpt.getBestAccessPath().getCostEstimate() != null && curOpt.getCurrentAccessPath().getCostEstimate() != null) {
            if (curOpt.getBestAccessPath().getCostEstimate().compare(curOpt.getCurrentAccessPath().getCostEstimate()) != 0.0) {
                curOpt.updateBestPlanMap((short)2, curOpt);
            } else if (curOpt.getBestAccessPath().getCostEstimate().rowCount() < curOpt.getCurrentAccessPath().getCostEstimate().rowCount()) {
                curOpt.updateBestPlanMap((short)2, curOpt);
            }
        }
        curOpt.updateBestPlanMap((short)0, curOpt);
        CostEstimate ce = curOpt.getBestAccessPath().getCostEstimate();
        if (!retval && ce != null) {
            this.currentCost.setCost(this.currentCost.getEstimatedCost() + ce.getEstimatedCost(), ce.rowCount(), ce.singleScanRowCount());
            if (curOpt.considerSortAvoidancePath() && this.requiredRowOrdering != null) {
                ce = curOpt.getBestSortAvoidancePath().getCostEstimate();
                this.currentSortAvoidanceCost.setCost(this.currentSortAvoidanceCost.getEstimatedCost() + ce.getEstimatedCost(), ce.rowCount(), ce.singleScanRowCount());
            }
            if (this.optimizerTrace) {
                this.trace(13, 0, 0, 0.0, null);
                if (curOpt.considerSortAvoidancePath()) {
                    this.trace(14, 0, 0, 0.0, null);
                }
            }
            if (this.joinPosition == this.numOptimizables - 1) {
                if (this.optimizerTrace) {
                    this.trace(4, 0, 0, 0.0, null);
                }
                if (this.requiredRowOrdering != null) {
                    boolean gotSortCost = false;
                    if (this.sortCost == null) {
                        this.sortCost = this.newCostEstimate();
                    } else if (this.requiredRowOrdering.getSortNeeded()) {
                        if (this.bestCost.rowCount() > this.currentCost.rowCount() && !this.bestPlanIsSortAvoidance) {
                            this.requiredRowOrdering.estimateCost(this.bestCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            double oldSortCost = this.sortCost.getEstimatedCost();
                            this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                            gotSortCost = true;
                            this.bestCost.setCost(this.bestCost.getEstimatedCost() - oldSortCost + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                        } else if (this.bestCost.rowCount() < this.currentCost.rowCount()) {
                            this.currentCost.setCost(this.currentCost.getEstimatedCost(), this.bestCost.rowCount(), this.currentCost.singleScanRowCount());
                        }
                    }
                    if (!gotSortCost) {
                        this.requiredRowOrdering.estimateCost(this.currentCost.rowCount(), this.bestRowOrdering, this.sortCost);
                    }
                    originalRowCount = this.currentCost.rowCount();
                    this.currentCost.setCost(this.currentCost.getEstimatedCost() + this.sortCost.getEstimatedCost(), this.sortCost.rowCount(), this.currentCost.singleScanRowCount());
                    if (this.optimizerTrace) {
                        this.trace(5, 0, 0, 0.0, null);
                        this.trace(15, 0, 0, 0.0, null);
                    }
                }
                if (!this.foundABestPlan || this.currentCost.compare(this.bestCost) < 0.0 || this.bestCost.isUninitialized()) {
                    this.rememberBestCost(this.currentCost, 1);
                    this.reloadBestPlan = false;
                } else {
                    this.reloadBestPlan = true;
                }
                if (this.requiredRowOrdering != null) {
                    double newCost = this.currentCost.getEstimatedCost() - this.sortCost.getEstimatedCost();
                    if (newCost < 0.0) {
                        newCost = 0.0;
                    }
                    this.currentCost.setCost(newCost, originalRowCount, this.currentCost.singleScanRowCount());
                }
                if (this.requiredRowOrdering != null && curOpt.considerSortAvoidancePath() && this.requiredRowOrdering.sortRequired(this.bestRowOrdering) == 3) {
                    if (this.optimizerTrace) {
                        this.trace(16, 0, 0, 0.0, null);
                    }
                    if (this.currentSortAvoidanceCost.compare(this.bestCost) <= 0.0 || this.bestCost.isUninitialized()) {
                        this.rememberBestCost(this.currentSortAvoidanceCost, 2);
                    }
                }
            }
        }
        return retval;
    }

    private void rememberBestCost(CostEstimate currentCost, int planType) throws StandardException {
        int i;
        this.foundABestPlan = true;
        if (this.optimizerTrace) {
            this.trace(17, 0, 0, 0.0, null);
            this.trace(18, planType, 0, 0.0, null);
            this.trace(19, 0, 0, 0.0, null);
        }
        this.bestCost.setCost(currentCost);
        if (this.bestCost.getEstimatedCost() < this.timeLimit) {
            this.timeLimit = this.bestCost.getEstimatedCost();
        }
        this.bestJoinOrderUsedPredsFromAbove = this.usingPredsPushedFromAbove;
        for (i = 0; i < this.numOptimizables; ++i) {
            this.bestJoinOrder[i] = this.proposedJoinOrder[i];
        }
        if (this.bestJoinOrderColocatedTableGrp != null && this.colocatedTableGrp != null) {
            this.bestJoinOrderColocatedTableGrp.clear();
            this.bestJoinOrderColocatedTableGrp.addAll(this.colocatedTableGrp);
            this.bestJoinOrderDriverTableIdx = this.driverTableIdx;
        }
        for (i = 0; i < this.numOptimizables; ++i) {
            this.optimizableList.getOptimizable(this.bestJoinOrder[i]).rememberAsBest(planType, this);
        }
        boolean bl = this.bestPlanIsSortAvoidance = planType == 2;
        if (this.requiredRowOrdering != null) {
            if ((!this.createQueryInfo && !this.allReplicatedTables || this.isLoner) && planType == 2) {
                this.requiredRowOrdering.sortNotNeeded();
            } else {
                this.requiredRowOrdering.sortNeeded();
            }
        }
        if (this.optimizerTrace) {
            if (this.requiredRowOrdering != null) {
                this.trace(20, planType, 0, 0.0, null);
            }
            this.trace(21, 0, 0, 0.0, null);
        }
    }

    @Override
    public void costPermutation() throws StandardException {
        CostEstimate outerCost = this.joinPosition == 0 ? this.outermostCostEstimate : this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).getBestAccessPath().getCostEstimate();
        SanityManager.ASSERT((outerCost != null ? 1 : 0) != 0, (String)"outerCost is not expected to be null");
        Optimizable optimizable = this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition]);
        if (!optimizable.feasibleJoinStrategy(this.predicateList, this)) {
            return;
        }
        optimizable.optimizeIt(this, this.predicateList, outerCost, this.currentRowOrdering);
    }

    @Override
    public void costOptimizable(Optimizable optimizable, TableDescriptor td, ConglomerateDescriptor cd, OptimizablePredicateList predList, CostEstimate outerCost) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(predList, this)) {
            return;
        }
        if (this.ruleBasedOptimization) {
            this.ruleBasedCostOptimizable(optimizable, td, cd, predList, outerCost);
        } else {
            this.costBasedCostOptimizable(optimizable, td, cd, predList, outerCost);
        }
    }

    private void ruleBasedCostOptimizable(Optimizable optimizable, TableDescriptor td, ConglomerateDescriptor cd, OptimizablePredicateList predList, CostEstimate outerCost) throws StandardException {
        Object conglomerateDescriptor = null;
        ConglomerateDescriptor bestConglomerateDescriptor = null;
        AccessPath bestAp = optimizable.getBestAccessPath();
        int lockMode = optimizable.getCurrentAccessPath().getLockMode();
        if (predList != null && predList.useful(optimizable, cd)) {
            boolean newCoveringIndex = optimizable.isCoveringIndex(cd);
            if (!bestAp.getCoveringIndexScan() || bestAp.getNonMatchingIndexScan() || newCoveringIndex) {
                bestAp.setCostEstimate(this.estimateTotalCost(predList, cd, outerCost, optimizable));
                bestAp.setConglomerateDescriptor(cd);
                bestAp.setNonMatchingIndexScan(false);
                bestAp.setCoveringIndexScan(newCoveringIndex);
                bestAp.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
                optimizable.rememberJoinStrategyAsBest(bestAp);
            }
            return;
        }
        if (optimizable.isCoveringIndex(cd)) {
            bestAp.setCostEstimate(this.estimateTotalCost(predList, cd, outerCost, optimizable));
            bestAp.setConglomerateDescriptor(cd);
            bestAp.setNonMatchingIndexScan(true);
            bestAp.setCoveringIndexScan(true);
            bestAp.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(bestAp);
            return;
        }
        if (!bestAp.getCoveringIndexScan() && bestAp.getNonMatchingIndexScan() && !cd.isIndex()) {
            bestAp.setCostEstimate(this.estimateTotalCost(predList, cd, outerCost, optimizable));
            bestAp.setConglomerateDescriptor(cd);
            bestAp.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(bestAp);
            return;
        }
        bestConglomerateDescriptor = bestAp.getConglomerateDescriptor();
        if (bestConglomerateDescriptor == null) {
            bestAp.setCostEstimate(this.estimateTotalCost(predList, cd, outerCost, optimizable));
            bestAp.setConglomerateDescriptor(cd);
            bestAp.setCoveringIndexScan(false);
            bestAp.setNonMatchingIndexScan(cd.isIndex());
            bestAp.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(bestAp);
        }
    }

    private void costBasedCostOptimizable(Optimizable optimizable, TableDescriptor td, ConglomerateDescriptor cd, OptimizablePredicateList predList, CostEstimate outerCost) throws StandardException {
        CostEstimate estimatedCost = this.estimateTotalCost(predList, cd, outerCost, optimizable);
        optimizable.getCurrentAccessPath().setCostEstimate(estimatedCost);
        AccessPath ap = optimizable.getBestAccessPath();
        CostEstimate bestCostEstimate = ap.getCostEstimate();
        if (bestCostEstimate == null || bestCostEstimate.isUninitialized() || estimatedCost.compare(bestCostEstimate) < 0.0) {
            ap.setConglomerateDescriptor(cd);
            ap.setCostEstimate(estimatedCost);
            ap.setCoveringIndexScan(optimizable.isCoveringIndex(cd));
            ap.setNonMatchingIndexScan(predList == null || !predList.useful(optimizable, cd));
            ap.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(ap);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap) == 3 && ((bestCostEstimate = (ap = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || bestCostEstimate.isUninitialized() || estimatedCost.compare(bestCostEstimate) < 0.0)) {
            ap.setConglomerateDescriptor(cd);
            ap.setCostEstimate(estimatedCost);
            ap.setCoveringIndexScan(optimizable.isCoveringIndex(cd));
            ap.setNonMatchingIndexScan(predList == null || !predList.useful(optimizable, cd));
            ap.setLockMode(optimizable.getCurrentAccessPath().getLockMode());
            optimizable.rememberJoinStrategyAsBest(ap);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    @Override
    public void considerCost(Optimizable optimizable, OptimizablePredicateList predList, CostEstimate estimatedCost, CostEstimate outerCost) throws StandardException {
        if (!optimizable.feasibleJoinStrategy(predList, this)) {
            return;
        }
        optimizable.getCurrentAccessPath().setCostEstimate(estimatedCost);
        AccessPath ap = optimizable.getBestAccessPath();
        CostEstimate bestCostEstimate = ap.getCostEstimate();
        if (bestCostEstimate == null || bestCostEstimate.isUninitialized() || estimatedCost.compare(bestCostEstimate) <= 0.0) {
            ap.setCostEstimate(estimatedCost);
            optimizable.rememberJoinStrategyAsBest(ap);
        }
        if (this.requiredRowOrdering != null && (this.joinPosition == 0 || this.optimizableList.getOptimizable(this.proposedJoinOrder[this.joinPosition - 1]).considerSortAvoidancePath()) && this.requiredRowOrdering.sortRequired(this.currentRowOrdering, this.assignedTableMap) == 3 && ((bestCostEstimate = (ap = optimizable.getBestSortAvoidancePath()).getCostEstimate()) == null || bestCostEstimate.isUninitialized() || estimatedCost.compare(bestCostEstimate) < 0.0)) {
            ap.setCostEstimate(estimatedCost);
            optimizable.rememberJoinStrategyAsBest(ap);
            optimizable.rememberSortAvoidancePath();
            this.currentRowOrdering.copy(this.bestRowOrdering);
        }
    }

    @Override
    public DataDictionary getDataDictionary() {
        return this.dDictionary;
    }

    @Override
    public void modifyAccessPaths() throws StandardException {
        if (this.optimizerTrace) {
            this.trace(7, 0, 0, 0.0, null);
        }
        if (!this.foundABestPlan) {
            if (this.optimizerTrace) {
                this.trace(6, 0, 0, 0.0, null);
            }
            throw StandardException.newException("42Y69");
        }
        this.optimizableList.reOrder(this.bestJoinOrder);
        JBitSet tablesNoCorr = this.identifyTablesForSubqueryPush(this.bestJoinOrder, this.bestJoinOrder.length - 1);
        JBitSet outerTables = new JBitSet(this.numOptimizables);
        for (int ictr = 0; ictr < this.numOptimizables; ++ictr) {
            Optimizable optimizable = this.optimizableList.getOptimizable(ictr);
            outerTables.or(optimizable.getReferencedTableMap());
            int tableNum = this.getTableNumber(optimizable);
            this.pushPredicates(optimizable, outerTables, tableNum >= 0 && tablesNoCorr.get(tableNum), true);
            this.optimizableList.setOptimizable(ictr, optimizable.modifyAccessPath(outerTables));
        }
    }

    private int getTableNumber(Optimizable optimizable) {
        int curTableNum = -1;
        if (optimizable.hasTableNumber()) {
            curTableNum = optimizable.getTableNumber();
        } else {
            JBitSet tablesRef = optimizable.getReferencedTableMap();
            if (tablesRef.hasSingleBitSet()) {
                curTableNum = tablesRef.getFirstSetBit();
            }
        }
        return curTableNum;
    }

    private JBitSet identifyTablesForSubqueryPush(int[] joinOrder, int traverseFrom) {
        Optimizable opt;
        int i;
        JBitSet tables = new JBitSet(this.numTablesInQuery);
        for (i = traverseFrom; i >= 0; --i) {
            opt = this.optimizableList.getOptimizable(joinOrder[i]);
            int tableNum = this.getTableNumber(opt);
            if (tableNum == -1) continue;
            tables.set(tableNum);
        }
        if (tables.getFirstSetBit() != -1) {
            for (int k = 0; k < this.predicateList.size(); ++k) {
                OptimizablePredicate pred = this.predicateList.getOptPredicate(k);
                if (pred.hasSubquery()) continue;
                JBitSet jbit = pred.getReferencedMap();
                for (int i2 = 0; i2 < jbit.size(); ++i2) {
                    if (!jbit.get(i2)) continue;
                    tables.clear(i2);
                }
            }
            for (i = traverseFrom; i >= 0; --i) {
                opt = this.optimizableList.getOptimizable(joinOrder[i]);
                int optTableNum = this.getTableNumber(opt);
                if (optTableNum == -1) continue;
                JBitSet set = new JBitSet(this.numTablesInQuery);
                opt.getTablesReferencedByRestrictionLists(set);
                for (int j = i - 1; j >= 0; --j) {
                    Optimizable temp = this.optimizableList.getOptimizable(joinOrder[j]);
                    int tableNum = this.getTableNumber(temp);
                    if (tableNum == -1 || !set.get(tableNum)) continue;
                    tables.clear(tableNum);
                    tables.clear(optTableNum);
                }
            }
        }
        return tables;
    }

    @Override
    public CostEstimate newCostEstimate() {
        return new CostEstimateImpl();
    }

    @Override
    public CostEstimate getOptimizedCost() {
        return this.bestCost;
    }

    @Override
    public CostEstimate getFinalCost() {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        this.finalCostEstimate = this.getNewCostEstimate(0.0, 0.0, 0.0);
        CostEstimate ce = null;
        for (int i = 0; i < this.bestJoinOrder.length; ++i) {
            ce = this.optimizableList.getOptimizable(this.bestJoinOrder[i]).getTrulyTheBestAccessPath().getCostEstimate();
            this.finalCostEstimate.setCost(this.finalCostEstimate.getEstimatedCost() + ce.getEstimatedCost(), ce.rowCount(), ce.singleScanRowCount());
        }
        return this.finalCostEstimate;
    }

    @Override
    public void setOuterRows(double outerRows) {
        this.outermostCostEstimate.setCost(this.outermostCostEstimate.getEstimatedCost(), outerRows, this.outermostCostEstimate.singleScanRowCount());
    }

    @Override
    public int tableLockThreshold() {
        return this.tableLockThreshold;
    }

    @Override
    public int getNumberOfJoinStrategies() {
        if (this.distJoinStrategies == null) {
            return this.joinStrategies.length;
        }
        return this.getColocatedTableGroup() == this.driverTableIdx ? this.joinStrategies.length : this.distJoinStrategies.length;
    }

    @Override
    public JoinStrategy getJoinStrategy(int whichStrategy) {
        boolean isOptColocated;
        if (this.distJoinStrategies == null) {
            isOptColocated = true;
        } else {
            boolean bl = isOptColocated = this.getColocatedTableGroup() == this.driverTableIdx;
        }
        if (whichStrategy < 0 || whichStrategy >= (isOptColocated ? this.joinStrategies.length : this.distJoinStrategies.length)) {
            SanityManager.THROWASSERT((String)("whichStrategy value " + whichStrategy + " out of range - should be between 0 and " + (this.joinStrategies.length - 1)));
        }
        if (isOptColocated ? this.joinStrategies[whichStrategy] == null : this.distJoinStrategies[whichStrategy] == null) {
            SanityManager.THROWASSERT((String)("Strategy " + whichStrategy + " not filled in."));
        }
        return isOptColocated ? this.joinStrategies[whichStrategy] : this.distJoinStrategies[whichStrategy];
    }

    @Override
    public JoinStrategy getJoinStrategy(String whichStrategy) {
        int i;
        JoinStrategy retval = null;
        String upperValue = StringUtil.SQLToUpperCase(whichStrategy);
        for (i = 0; i < this.joinStrategies.length; ++i) {
            if (!upperValue.equals(this.joinStrategies[i].getName())) continue;
            retval = this.joinStrategies[i];
        }
        if (this.distJoinStrategies != null) {
            for (i = 0; i < this.distJoinStrategies.length; ++i) {
                if (!upperValue.equals(this.distJoinStrategies[i].getName())) continue;
                retval = this.distJoinStrategies[i];
            }
        }
        return retval;
    }

    @Override
    public double uniqueJoinWithOuterTable(OptimizablePredicateList predList) throws StandardException {
        double retval = -1.0;
        double numUniqueKeys = 1.0;
        double currentRows = this.currentCost.rowCount();
        if (predList != null) {
            for (int i = this.joinPosition - 1; i >= 0; --i) {
                Optimizable opt = this.optimizableList.getOptimizable(this.proposedJoinOrder[i]);
                double uniqueKeysThisOptimizable = opt.uniqueJoin(predList);
                if (!(uniqueKeysThisOptimizable > 0.0)) continue;
                numUniqueKeys *= opt.uniqueJoin(predList);
            }
        }
        if (numUniqueKeys != 1.0) {
            retval = numUniqueKeys / currentRows;
        }
        return retval;
    }

    private boolean isPushable(OptimizablePredicate pred, boolean pushDeemedNonpushables) {
        if (pred.hasSubquery()) {
            if (pushDeemedNonpushables) {
                JBitSet referencedTables = pred.getReferencedMap();
                return referencedTables.getFirstSetBit() != -1;
            }
            return false;
        }
        return true;
    }

    private CostEstimate estimateTotalCost(OptimizablePredicateList predList, ConglomerateDescriptor cd, CostEstimate outerCost, Optimizable optimizable) throws StandardException {
        CostEstimate resultCost = optimizable.estimateCost(predList, cd, outerCost, this, this.currentRowOrdering);
        return resultCost;
    }

    @Override
    public int getLevel() {
        return 1;
    }

    public CostEstimateImpl getNewCostEstimate(double theCost, double theRowCount, double theSingleScanRowCount) {
        return new CostEstimateImpl(theCost, theRowCount, theSingleScanRowCount);
    }

    @Override
    public void trace(int traceFlag, int intParam1, int intParam2, double doubleParam, Object objectParam1) {
    }

    @Override
    public boolean useStatistics() {
        return this.useStatistics && this.optimizableList.useStatistics();
    }

    protected void updateBestPlanMaps(short action, Object planKey) throws StandardException {
        block9: {
            int i;
            int[] joinOrder;
            block10: {
                if (this.numOptimizables <= 1) break block9;
                joinOrder = null;
                if (action != 0) break block10;
                if (this.savedJoinOrders == null) break block9;
                this.savedJoinOrders.remove(planKey);
                if (this.savedJoinOrders.size() != 0) break block9;
                this.savedJoinOrders = null;
                break block9;
            }
            if (action == 1) {
                if (this.savedJoinOrders == null) {
                    this.savedJoinOrders = new HashMap();
                } else {
                    joinOrder = (int[])this.savedJoinOrders.get(planKey);
                }
                if (joinOrder == null) {
                    joinOrder = new int[this.numOptimizables];
                }
                for (i = 0; i < this.bestJoinOrder.length; ++i) {
                    joinOrder[i] = this.bestJoinOrder[i];
                }
                this.savedJoinOrders.put(planKey, joinOrder);
            } else if (this.savedJoinOrders != null && (joinOrder = (int[])this.savedJoinOrders.get(planKey)) != null) {
                for (i = 0; i < joinOrder.length; ++i) {
                    this.bestJoinOrder[i] = joinOrder[i];
                }
            }
        }
        for (int i = this.optimizableList.size() - 1; i >= 0; --i) {
            this.optimizableList.getOptimizable(i).updateBestPlanMap(action, planKey);
        }
    }

    protected void addScopedPredicatesToList(PredicateList pList) throws StandardException {
        int i;
        if (pList == null || pList == this.predicateList) {
            return;
        }
        if (this.predicateList == null) {
            this.predicateList = new PredicateList();
        }
        Predicate pred = null;
        for (i = this.predicateList.size() - 1; i >= 0; --i) {
            pred = (Predicate)this.predicateList.getOptPredicate(i);
            if (!pred.isScopedForPush()) continue;
            this.predicateList.removeOptPredicate(i);
        }
        for (i = pList.size() - 1; i >= 0; --i) {
            pred = (Predicate)pList.getOptPredicate(i);
            if (!pred.isScopedToSourceResultSet()) continue;
            pred.clearScanFlags();
            this.predicateList.addOptPredicate(pred);
            pList.removeOptPredicate(i);
        }
    }

    @Override
    public void determineColocation() throws StandardException {
        if (this.isLoner) {
            return;
        }
        if (this.predicateList == null) {
            return;
        }
        if (this.optimizableList.size() <= 1) {
            return;
        }
        assert (this.predicateList instanceof PredicateList);
        PredicateList src = (PredicateList)this.predicateList;
        if (src.size() == 0 && src.redundantPredicates.size() == 0) {
            return;
        }
        PredicateList predicateCopy = new PredicateList();
        this.predicateList.copyPredicatesToOtherList(predicateCopy);
        for (int i = 0; i < src.redundantPredicates.size(); ++i) {
            predicateCopy.addOptPredicate(src.redundantPredicates.get(i));
        }
        for (int optIdx = 0; optIdx < this.optimizableList.size(); ++optIdx) {
            Optimizable lookupOpt = this.optimizableList.getOptimizable(optIdx);
            if (((FromTable)lookupOpt).getNumPartitioningCols() == -1) {
                this.trace(65, optIdx, 0, 0.0, lookupOpt);
                this.replicatedTableGrp.set(optIdx);
                continue;
            }
            if (this.colocatedTableGrp.size() == 0) {
                JBitSet set = new JBitSet(this.numOptimizables);
                set.set(optIdx);
                this.colocatedTableGrp.add(set);
                continue;
            }
            int groupIdx = this.setColocatedTableInGroup(lookupOpt, optIdx, 0, predicateCopy);
            if (!GemFireXDUtils.TraceNCJ) continue;
            if (groupIdx >= 0) {
                SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("Optimizable " + lookupOpt.shortString() + " is colocated in groupIdx " + groupIdx + ", group info : " + this.colocatedTableGrp.get(groupIdx)));
                continue;
            }
            if (groupIdx == -2) {
                SanityManager.DEBUG_PRINT((String)"warning:TraceNCJ", (String)("Couldn't determine colocation for optimizable " + lookupOpt.getClass().getSimpleName() + " opt: [" + lookupOpt.shortString() + "] due to insufficient code. About to clear ColocatedTableGrp : " + this.colocatedTableGrp + " predList : " + this.predicateList));
                this.colocatedTableGrp.clear();
                return;
            }
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("Optimizable " + lookupOpt.shortString() + " not colocated with any existing table. ColocatedTableGrp : " + this.colocatedTableGrp));
        }
    }

    @Override
    public boolean hasNonColocatedTables() {
        return this.bestJoinOrderColocatedTableGrp.size() > 1;
    }

    private int setColocatedTableInGroup(Optimizable lookupOpt, int optimizableIdx, int beginOffset, OptimizablePredicateList predList) throws StandardException {
        int lookupOptColocatedWith = -1;
        for (int colocIdx = beginOffset; colocIdx < this.colocatedTableGrp.size(); ++colocIdx) {
            JBitSet groups = this.colocatedTableGrp.get(colocIdx);
            int ret = -4;
            ret = this.iterateGroupToSetColocation(groups, lookupOpt, predList);
            if (ret < 0) {
                if (ret == -1) continue;
                return ret;
            }
            lookupOptColocatedWith = colocIdx;
            if (optimizableIdx != -1) {
                groups.set(optimizableIdx);
                this.setColocatedTableInGroup(lookupOpt, -1, colocIdx + 1, predList);
                return lookupOptColocatedWith;
            }
            assert (beginOffset != -1 && beginOffset - 1 < this.colocatedTableGrp.size());
            this.colocatedTableGrp.get(beginOffset - 1).or(groups);
            JBitSet mergedGroup = this.colocatedTableGrp.remove(colocIdx);
            SanityManager.DEBUG_PRINT((String)"TraceDisJoin", (String)("Merged " + mergedGroup + " with " + (beginOffset - 1) + " by induction. group info: " + this.colocatedTableGrp.get(beginOffset - 1)));
        }
        if (lookupOptColocatedWith == -1 && optimizableIdx != -1) {
            JBitSet set = new JBitSet(this.numOptimizables);
            set.set(optimizableIdx);
            this.colocatedTableGrp.add(set);
            return -1;
        }
        return -2;
    }

    private int iterateGroupToSetColocation(JBitSet groups, Optimizable lookup, OptimizablePredicateList predList) throws StandardException {
        int g = -1;
        while ((g = groups.getNextSetBit(g + 1)) != -1) {
            Optimizable driverTable = this.optimizableList.getOptimizable(g);
            int ret = 0;
            ret = predList.setColocatedWith(driverTable, lookup);
            if (ret == 0) {
                return -2;
            }
            if (ret != 1) continue;
            return g;
        }
        return -1;
    }

    private final int getColocatedTableGroup() {
        if (this.colocatedTableGrp.size() == 0) {
            return this.driverTableIdx;
        }
        int lookupOptIdx = this.proposedJoinOrder[this.joinPosition];
        if (this.replicatedTableGrp.get(lookupOptIdx)) {
            return this.driverTableIdx;
        }
        int ret = this.searchColocatedGroup(lookupOptIdx);
        if (this.joinPosition == 0 || this.driverTableIdx < 0) {
            if (ret < 0) {
                this.trace(66, ret, 0, 0.0, null);
                this.driverTableIdx = ret;
            }
            return this.driverTableIdx;
        }
        return ret;
    }

    private final int searchColocatedGroup(int lookupOptIdx) {
        for (int index = 0; index < this.colocatedTableGrp.size(); ++index) {
            if (!this.colocatedTableGrp.get(index).get(lookupOptIdx)) continue;
            return index;
        }
        return -3;
    }

    @Override
    public void saveBestJoinOrderPrIDs() throws StandardException {
        if (this.bestJoinOrder.length == 0 || this.bestJoinOrderColocatedTableGrp == null || this.bestJoinOrderColocatedTableGrp.size() <= 1) {
            return;
        }
        Optimizable opt = this.optimizableList.getOptimizable(this.bestJoinOrderColocatedTableGrp.get(this.bestJoinOrderDriverTableIdx).getFirstSetBit());
        this.bestJoinOrderDriverTablePrID = this.getPrID(opt);
        for (int colocIdx = 1; colocIdx < this.bestJoinOrderColocatedTableGrp.size(); ++colocIdx) {
            JBitSet groups = this.bestJoinOrderColocatedTableGrp.get(colocIdx);
            THashSet prNameGrp = new THashSet();
            this.bestJoinOrderColocatedPrCorrName.add(prNameGrp);
            int g = -1;
            String prName = null;
            while ((g = groups.getNextSetBit(g + 1)) != -1) {
                opt = this.optimizableList.getOptimizable(g);
                prName = this.getPrCorrName(opt);
                if (prName == null) continue;
                prNameGrp.add((Object)prName);
            }
        }
    }

    private int getPrID(Optimizable opt) throws StandardException {
        assert (opt != null) : "opt is not expected to be null";
        Optimizable tab = opt.getBaseTable();
        assert (tab != null) : "tab is not expected to be null";
        Region<?, ?> r = tab.getTableDescriptor().getRegion();
        if (r.getAttributes().getPartitionAttributes() != null) {
            return ((PartitionedRegion)r).getPRId();
        }
        return -1;
    }

    private String getPrCorrName(Optimizable opt) throws StandardException {
        assert (opt != null) : "opt is not expected to be null";
        Optimizable tab = opt.getBaseTable();
        assert (tab != null) : "tab is not expected to be null";
        Region<?, ?> r = tab.getTableDescriptor().getRegion();
        if (r.getAttributes().getPartitionAttributes() != null) {
            if (!(tab instanceof FromBaseTable)) {
                SanityManager.THROWASSERT((String)("tab expected instanceof FromBaseTable but is " + tab.getClass().getSimpleName()));
            }
            return ((FromBaseTable)tab).ncjGetCorrelationName();
        }
        return null;
    }

    public final ArrayList<THashSet> getBestJoinOrderColocationPrCorrName() {
        return this.bestJoinOrderColocatedPrCorrName;
    }

    public final int getBestJoinOrderDriverTablePrID() {
        return this.bestJoinOrderDriverTablePrID;
    }
}

