/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.stream.HeaderPrintWriter;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;

abstract class TDCacheable
implements Cacheable {
    protected TableDescriptor td;
    protected final DataDictionaryImpl dd;

    TDCacheable(DataDictionaryImpl dd) {
        this.dd = dd;
    }

    @Override
    public void clean(boolean forRemove) {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    public TableDescriptor getTableDescriptor() {
        return this.td;
    }

    protected boolean checkConsistency(TableDescriptor uncachedTD, Object identity, HeaderPrintWriter reportInconsistent) throws StandardException {
        boolean retval = true;
        if (uncachedTD == null) {
            reportInconsistent.println("Inconsistent NameTDCacheable: identity = " + identity + ", uncached table descriptor not found.");
            retval = false;
        } else if (!(uncachedTD.getHeapConglomerateId() == this.td.getHeapConglomerateId() && uncachedTD.getUUID().equals(this.td.getUUID()) && uncachedTD.getSchemaName().equals(this.td.getSchemaName()) && uncachedTD.getName().equals(this.td.getName()) && uncachedTD.getTableType() == this.td.getTableType())) {
            reportInconsistent.println("Inconsistent NameTDCacheable: identity = " + identity + ", cached TD = " + this.td + ", uncached TD = " + uncachedTD);
            retval = false;
        }
        return retval;
    }
}

