/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.DefaultInfo;
import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.DefaultInfoImpl;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.UniqueTupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;
import java.util.Properties;

public class SYSCOLUMNSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSCOLUMNS";
    protected static final int SYSCOLUMNS_COLUMN_COUNT = 10;
    protected static final int SYSCOLUMNS_TABLEID = 1;
    protected static final int SYSCOLUMNS_REFERENCEID = 1;
    protected static final int SYSCOLUMNS_COLUMNNAME = 2;
    protected static final int SYSCOLUMNS_COLUMNNUMBER = 3;
    protected static final int SYSCOLUMNS_COLUMNDATATYPE = 4;
    protected static final int SYSCOLUMNS_COLUMNDEFAULT = 5;
    protected static final int SYSCOLUMNS_COLUMNDEFAULTID = 6;
    protected static final int SYSCOLUMNS_AUTOINCREMENTVALUE = 7;
    protected static final int SYSCOLUMNS_AUTOINCREMENTSTART = 8;
    protected static final int SYSCOLUMNS_AUTOINCREMENTINC = 9;
    protected static final int SYSCOLUMNS_IS_GENERATED_BY_DEFAULT = 10;
    protected static final int SYSCOLUMNS_INDEX1_ID = 0;
    protected static final int SYSCOLUMNS_INDEX2_ID = 1;
    private static final boolean[] uniqueness = new boolean[]{true, false};
    private static final String[] uuids = new String[]{"8000001e-00d0-fd77-3ed8-000a0a0b1900", "80000029-00d0-fd77-3ed8-000a0a0b1900", "80000020-00d0-fd77-3ed8-000a0a0b1900", "6839c016-00d9-2829-dfcd-000a0a411400"};
    private static final int[][] indexColumnPositions = new int[][]{{1, 2}, {6}};

    SYSCOLUMNSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        this(uuidf, ef, dvf, TABLENAME_STRING);
    }

    SYSCOLUMNSRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf, String myName) {
        super(uuidf, ef, dvf);
        this.initInfo(10, myName, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        ColumnDescriptor column;
        String colName = null;
        String defaultID = null;
        String tabID = null;
        Integer colID = null;
        TypeDescriptor typeDesc = null;
        Object defaultSerializable = null;
        long autoincStart = 0L;
        long autoincInc = 0L;
        long autoincValue = 0L;
        long autoinc_create_or_modify_Start_Increment = -1L;
        Boolean isGeneratedByDefault = false;
        if (td != null) {
            column = (ColumnDescriptor)td;
            typeDesc = column.getType().getCatalogType();
            tabID = column.getReferencingUUID().toString();
            colName = column.getColumnName();
            colID = column.getPosition();
            autoincStart = column.getAutoincStart();
            autoincInc = column.getAutoincInc();
            autoincValue = column.getAutoincValue();
            autoinc_create_or_modify_Start_Increment = column.getAutoinc_create_or_modify_Start_Increment();
            isGeneratedByDefault = column.isGeneratedByDefault();
            defaultSerializable = column.getDefaultInfo() != null ? column.getDefaultInfo() : column.getDefaultValue();
            if (column.getDefaultUUID() != null) {
                defaultID = column.getDefaultUUID().toString();
            }
        }
        ExecRow row = this.getExecutionFactory().getValueRow(10);
        row.setColumn(1, new SQLChar(tabID));
        row.setColumn(2, new SQLVarchar(colName));
        row.setColumn(3, new SQLInteger(colID));
        row.setColumn(4, this.dvf.getDataValue(typeDesc));
        row.setColumn(5, this.dvf.getDataValue(defaultSerializable));
        row.setColumn(6, new SQLChar(defaultID));
        row.setColumn(10, new SQLBoolean(isGeneratedByDefault));
        if (autoinc_create_or_modify_Start_Increment == 0L || autoinc_create_or_modify_Start_Increment == 2L) {
            row.setColumn(7, new SQLLongint(autoincValue));
            row.setColumn(8, new SQLLongint(autoincStart));
            row.setColumn(9, new SQLLongint(autoincInc));
        } else if (autoinc_create_or_modify_Start_Increment == 1L) {
            column = (ColumnDescriptor)td;
            row.setColumn(7, new SQLLongint(autoincStart));
            row.setColumn(8, new SQLLongint(autoincStart));
            row.setColumn(9, new SQLLongint(column.getTableDescriptor().getColumnDescriptor(colName).getAutoincInc()));
        } else {
            row.setColumn(7, new SQLLongint());
            row.setColumn(8, new SQLLongint());
            row.setColumn(9, new SQLLongint());
        }
        return row;
    }

    @Override
    public Properties getCreateHeapProperties() {
        Properties properties = new Properties();
        properties.put("gemfirexd.storage.pageSize", "4096");
        properties.put("gemfirexd.storage.pageReservedSpace", "0");
        properties.put("gemfirexd.storage.minimumRecordSize", "1");
        return properties;
    }

    @Override
    public Properties getCreateIndexProperties(int indexNumber) {
        Properties properties = new Properties();
        properties.put("gemfirexd.storage.pageSize", "4096");
        return properties;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentTupleDescriptor, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 10 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSCOLUMNS row");
        DefaultInfoImpl defaultInfo = null;
        DataValueDescriptor defaultValue = null;
        UUID defaultUUID = null;
        UUID uuid = null;
        UUIDFactory uuidFactory = this.getUUIDFactory();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        if (parentTupleDescriptor != null) {
            if (!(parentTupleDescriptor instanceof UniqueTupleDescriptor)) {
                SanityManager.THROWASSERT((String)(parentTupleDescriptor.getClass().getName() + " not instanceof UniqueTupleDescriptor"));
            }
            uuid = ((UniqueTupleDescriptor)((Object)parentTupleDescriptor)).getUUID();
        } else {
            uuid = uuidFactory.recreateUUID(row.getColumn(1).getString());
        }
        Object object = row.getColumn(5).getObject();
        if (object instanceof DataValueDescriptor) {
            defaultValue = (DataValueDescriptor)object;
        } else if (object instanceof DefaultInfoImpl) {
            defaultInfo = (DefaultInfoImpl)object;
            defaultValue = defaultInfo.getDefaultValue();
        }
        String defaultID = row.getColumn(6).getString();
        if (defaultID != null) {
            defaultUUID = uuidFactory.recreateUUID(defaultID);
        }
        String columnName = row.getColumn(2).getString();
        int columnNumber = row.getColumn(3).getInt();
        TypeDescriptor catalogType = (TypeDescriptor)row.getColumn(4).getObject();
        DataTypeDescriptor dataTypeServices = DataTypeDescriptor.getType(catalogType);
        long autoincValue = row.getColumn(7).getLong();
        long autoincStart = row.getColumn(8).getLong();
        long autoincInc = row.getColumn(9).getLong();
        boolean isGeneratedByDefault = row.getColumn(10).getBoolean();
        DataValueDescriptor col = row.getColumn(8);
        autoincStart = col.getLong();
        col = row.getColumn(9);
        autoincInc = col.getLong();
        ColumnDescriptor colDesc = new ColumnDescriptor(columnName, columnNumber, dataTypeServices, defaultValue, (DefaultInfo)defaultInfo, uuid, defaultUUID, autoincStart, autoincInc, autoincValue, isGeneratedByDefault);
        return colDesc;
    }

    @Override
    public int getPrimaryKeyIndexNumber() {
        return 0;
    }

    @Override
    public SystemColumn[] buildColumnList() throws StandardException {
        return new SystemColumn[]{SystemColumnImpl.getUUIDColumn("REFERENCEID", false), SystemColumnImpl.getIdentifierColumn("COLUMNNAME", false), SystemColumnImpl.getColumn("COLUMNNUMBER", 4, false), SystemColumnImpl.getJavaColumn("COLUMNDATATYPE", "com.pivotal.gemfirexd.internal.catalog.TypeDescriptor", false), SystemColumnImpl.getJavaColumn("COLUMNDEFAULT", "java.io.Serializable", true), SystemColumnImpl.getUUIDColumn("COLUMNDEFAULTID", true), SystemColumnImpl.getColumn("AUTOINCREMENTVALUE", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTSTART", -5, true), SystemColumnImpl.getColumn("AUTOINCREMENTINC", -5, true), SystemColumnImpl.getColumn("IS_GENERATED_BY_DEFAULT", 16, true)};
    }
}

