/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.catalog;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CatalogRowFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdDiskStoreDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SystemColumn;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TupleDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.SystemColumnImpl;

public class GfxdSYSDISKSTORESRowFactory
extends CatalogRowFactory {
    public static final String TABLENAME_STRING = "SYSDISKSTORES";
    public static final int SYSDISKSTORES_COLUMN_COUNT = 9;
    public static final int SYSDISKSTORES_NAME = 1;
    public static final int SYSDISKSTORES_MAXLOGSIZE = 2;
    public static final int SYSDISKSTORES_AUTOCOMPACT = 3;
    public static final int SYSDISKSTORES_ALLOWFORCECOMPACTION = 4;
    public static final int SYSDISKSTORES_COMPACTIONTHRESHOLD = 5;
    public static final int SYSDISKSTORES_TIMEINTERVAL = 6;
    public static final int SYSDISKSTORES_WRITEBUFFERSIZE = 7;
    public static final int SYSDISKSTORES_QUEUESIZE = 8;
    public static final int SYSDISKSTORES_DIR_PATH_SIZE = 9;
    private static final int[][] indexColumnPositions = new int[][]{{1}};
    private static final boolean[] uniqueness = null;
    private static final String[] uuids = new String[]{"a073400e-00b6-fdfc-71ce-000b0a763800", "a073400e-00b6-fbba-75d4-000b0a763800", "a073400e-00b6-00b9-bbde-000b0a763800"};

    GfxdSYSDISKSTORESRowFactory(UUIDFactory uuidf, ExecutionFactory ef, DataValueFactory dvf) {
        super(uuidf, ef, dvf);
        this.initInfo(9, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    @Override
    public ExecRow makeRow(TupleDescriptor td, TupleDescriptor parent) throws StandardException {
        UUID uuid = null;
        String diskStoreName = null;
        long maxLogSize = -1L;
        String autoCompact = null;
        String allowForceCompaction = null;
        int compactionThreshold = -1;
        long timeInterval = -1L;
        int writeBufferSize = -1;
        int queueSize = -1;
        String dirPathSize = null;
        if (td != null) {
            GfxdDiskStoreDescriptor dsd = (GfxdDiskStoreDescriptor)td;
            diskStoreName = dsd.getDiskStoreName();
            uuid = dsd.getUUID();
            maxLogSize = dsd.getMaxLogSize();
            autoCompact = dsd.getAutocompact();
            allowForceCompaction = dsd.getAllowForceCompaction();
            compactionThreshold = dsd.getCompactionThreshold();
            timeInterval = dsd.getTimeInterval();
            writeBufferSize = dsd.getWriteBufferSize();
            queueSize = dsd.getQueueSize();
            dirPathSize = dsd.getDirPathAndSize();
        }
        ExecRow row = this.getExecutionFactory().getValueRow(9);
        row.setColumn(1, new SQLChar(diskStoreName));
        row.setColumn(2, new SQLLongint(maxLogSize));
        row.setColumn(3, new SQLVarchar(autoCompact));
        row.setColumn(4, new SQLVarchar(allowForceCompaction));
        row.setColumn(5, new SQLInteger(compactionThreshold));
        row.setColumn(6, new SQLLongint(timeInterval));
        row.setColumn(7, new SQLInteger(writeBufferSize));
        row.setColumn(8, new SQLInteger(queueSize));
        row.setColumn(9, new SQLVarchar(dirPathSize));
        return row;
    }

    @Override
    public TupleDescriptor buildDescriptor(ExecRow row, TupleDescriptor parentDesc, DataDictionary dd) throws StandardException {
        SanityManager.ASSERT((row.nColumns() == 9 ? 1 : 0) != 0, (String)"Wrong number of columns for a SYSDISKSTORES row");
        UUIDFactory uuidFactory = this.getUUIDFactory();
        DataValueDescriptor col = row.getColumn(1);
        String diskStoreName = col.getString();
        UUID id = this.getUUIDFactory().recreateUUID(diskStoreName);
        col = row.getColumn(2);
        int maxLogSize = col.getInt();
        col = row.getColumn(3);
        String autoCompact = col.getString();
        col = row.getColumn(4);
        String allowForceCompact = col.getString();
        col = row.getColumn(5);
        int comapctionThreshold = col.getInt();
        col = row.getColumn(6);
        int timeInterval = col.getInt();
        col = row.getColumn(7);
        int writeBufferSize = col.getInt();
        col = row.getColumn(8);
        int queueSize = col.getInt();
        col = row.getColumn(9);
        String dirPathAndSize = col.getString();
        return new GfxdDiskStoreDescriptor(dd, id, diskStoreName, maxLogSize, autoCompact, allowForceCompact, comapctionThreshold, timeInterval, writeBufferSize, queueSize, dirPathAndSize);
    }

    @Override
    public SystemColumn[] buildColumnList() {
        return new SystemColumn[]{SystemColumnImpl.getIdentifierColumn("NAME", false), SystemColumnImpl.getColumn("MAXLOGSIZE", -5, false), SystemColumnImpl.getColumn("AUTOCOMPACT", 12, false, 6), SystemColumnImpl.getColumn("ALLOWFORCECOMPACTION", 12, false, 6), SystemColumnImpl.getColumn("COMPACTIONTHRESHOLD", 4, false, 3), SystemColumnImpl.getColumn("TIMEINTERVAL", -5, false), SystemColumnImpl.getColumn("WRITEBUFFERSIZE", 4, false), SystemColumnImpl.getColumn("QUEUESIZE", 4, false), SystemColumnImpl.getColumn("DIR_PATH_SIZE", 12, false)};
    }
}

