/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.locks;

import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.diag.DiagnosticUtil;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Latch;
import com.pivotal.gemfirexd.internal.iapi.services.locks.Lockable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.locks.AbstractPool;
import com.pivotal.gemfirexd.internal.impl.services.locks.ActiveLock;
import com.pivotal.gemfirexd.internal.impl.services.locks.Control;
import com.pivotal.gemfirexd.internal.impl.services.locks.D_LockControl;
import com.pivotal.gemfirexd.internal.impl.services.locks.Deadlock;
import com.pivotal.gemfirexd.internal.impl.services.locks.Lock;
import com.pivotal.gemfirexd.internal.impl.services.locks.LockControl;
import com.pivotal.gemfirexd.internal.impl.services.locks.LockTable;
import com.pivotal.gemfirexd.internal.impl.services.locks.Timeout;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

final class ConcurrentLockSet
implements LockTable {
    private final AbstractPool factory;
    private final ConcurrentHashMap<Lockable, Entry> locks;
    private ArrayList<Entry> seenByDeadlockDetection;
    private int deadlockTimeout = 20000;
    private int waitTimeout = 60000;
    private boolean deadlockTrace;
    private final AtomicInteger blockCount;

    ConcurrentLockSet(AbstractPool factory) {
        this.factory = factory;
        this.blockCount = new AtomicInteger();
        this.locks = new ConcurrentHashMap();
    }

    private Entry getEntry(Lockable ref) {
        Entry e = this.locks.get(ref);
        while (true) {
            Entry current;
            if (e != null) {
                e.lock();
                if (e.control != null) {
                    return e;
                }
            } else {
                e = new Entry();
                e.lock();
            }
            if ((current = this.locks.putIfAbsent(ref, e)) == null) {
                return e;
            }
            e.unlock();
            e = current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] checkDeadlock(Entry entry, ActiveLock waitingLock, byte wakeupReason) {
        LockControl control = (LockControl)entry.control;
        entry.enterDeadlockDetection();
        Class<Deadlock> clazz = Deadlock.class;
        synchronized (Deadlock.class) {
            Object[] objectArray;
            try {
                objectArray = Deadlock.look(this.factory, this, control, waitingLock, wakeupReason);
            }
            catch (Throwable throwable) {
                for (Entry e : this.seenByDeadlockDetection) {
                    e.unlock();
                }
                this.seenByDeadlockDetection = null;
                entry.exitDeadlockDetection();
                throw throwable;
            }
            for (Entry e : this.seenByDeadlockDetection) {
                e.unlock();
            }
            this.seenByDeadlockDetection = null;
            entry.exitDeadlockDetection();
            // ** MonitorExit[var5_5] (shouldn't be in output)
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock lockObject(CompatibilitySpace compatibilitySpace, Lockable ref, Object qualifier, int timeout) throws StandardException {
        int actualTimeout;
        Lock lockItem;
        LockControl control;
        Entry entry;
        String lockDebug;
        block45: {
            if (SanityManager.TraceMemoryLeak && this.locks.size() > 1000) {
                System.out.println("TraceMemoryLeak:LockSet: " + this.locks.size());
            }
            lockDebug = null;
            entry = this.getEntry(ref);
            try {
                Control gc = entry.control;
                if (gc == null) {
                    Lock gl = new Lock(compatibilitySpace, ref, qualifier);
                    gl.grant();
                    entry.control = gl;
                    Lock lock = gl;
                    return lock;
                }
                control = gc.getLockControl();
                if (control != gc) {
                    entry.control = control;
                }
                SanityManager.ASSERT((boolean)ref.equals(control.getLockable()));
                SanityManager.ASSERT((this.locks.get((Object)control.getLockable()).control == control ? 1 : 0) != 0);
                lockItem = control.addLock(this, compatibilitySpace, qualifier);
                if (lockItem.getCount() != 0) {
                    Lock gl = lockItem;
                    return gl;
                }
                if (!AbstractPool.noLockWait(timeout, compatibilitySpace)) break block45;
                control.giveUpWait(lockItem, this);
                if (SanityManager.DEBUG_ON((String)"DeadlockTrace")) {
                    SanityManager.showTrace((Throwable)new Throwable());
                    lockDebug = DiagnosticUtil.toDiagString(lockItem) + "\nCould not grant lock with zero timeout, here's the table";
                    entry.unlock();
                    try {
                        lockDebug = lockDebug + this.toDebugString();
                    }
                    finally {
                        entry.lock();
                    }
                }
                Lock gl = null;
                return gl;
            }
            finally {
                entry.unlock();
            }
        }
        boolean deadlockWait = false;
        if (timeout == -1) {
            deadlockWait = true;
            actualTimeout = this.deadlockTimeout;
            if (actualTimeout == -1) {
                actualTimeout = 20000;
            }
        } else {
            if (timeout == -2) {
                timeout = actualTimeout = this.waitTimeout;
            } else {
                actualTimeout = timeout;
            }
            if (this.deadlockTimeout >= 0) {
                if (actualTimeout < 0) {
                    deadlockWait = true;
                    actualTimeout = this.deadlockTimeout;
                } else if (this.deadlockTimeout < actualTimeout) {
                    deadlockWait = true;
                    actualTimeout = this.deadlockTimeout;
                    timeout -= this.deadlockTimeout;
                }
            }
        }
        ActiveLock waitingLock = (ActiveLock)lockItem;
        lockItem = null;
        int earlyWakeupCount = 0;
        long startWaitTime = 0L;
        while (true) {
            byte wakeupReason = waitingLock.waitForGrant(actualTimeout);
            ActiveLock nextWaitingLock = null;
            Object[] deadlockData = null;
            try {
                boolean willQuitWait;
                Enumeration timeoutLockTable = null;
                long currentTime = 0L;
                entry.lock();
                try {
                    if (control.isGrantable(control.firstWaiter() == waitingLock, compatibilitySpace, qualifier)) {
                        control.grant(waitingLock);
                        nextWaitingLock = control.getNextWaiter(waitingLock, true, this);
                        ActiveLock activeLock = waitingLock;
                        return activeLock;
                    }
                    waitingLock.clearPotentiallyGranted();
                    boolean bl = willQuitWait = wakeupReason != 1;
                    if (wakeupReason == 0 && deadlockWait || wakeupReason == 2) {
                        deadlockData = this.checkDeadlock(entry, waitingLock, wakeupReason);
                        if (deadlockData == null) {
                            deadlockWait = false;
                            actualTimeout = timeout;
                            startWaitTime = 0L;
                            willQuitWait = false;
                        } else {
                            willQuitWait = true;
                        }
                    }
                    nextWaitingLock = control.getNextWaiter(waitingLock, willQuitWait, this);
                    if (SanityManager.DEBUG_ON((String)"DeadlockTrace") && willQuitWait) {
                        lockDebug = DiagnosticUtil.toDiagString(waitingLock) + "\nGot deadlock/timeout, here's the table";
                    }
                }
                finally {
                    entry.unlock();
                }
                if (willQuitWait) {
                    if (this.deadlockTrace && deadlockData == null) {
                        currentTime = System.currentTimeMillis();
                        timeoutLockTable = this.factory.makeVirtualLockTable();
                    }
                    if (SanityManager.DEBUG_ON((String)"DeadlockTrace")) {
                        SanityManager.showTrace((Throwable)new Throwable());
                        lockDebug = lockDebug + this.toDebugString();
                    }
                    if (lockDebug != null) {
                        String type = deadlockData != null ? "deadlock:" : "timeout:";
                        SanityManager.DEBUG_PRINT((String)type, (String)("wait on lockitem caused " + type + lockDebug));
                    }
                    if (deadlockData == null) {
                        if (this.deadlockTrace) {
                            throw Timeout.buildException(waitingLock, timeoutLockTable, currentTime);
                        }
                        StandardException se = StandardException.newException("40XL1");
                        throw se;
                    }
                    throw Deadlock.buildException(this.factory, deadlockData);
                }
            }
            finally {
                if (nextWaitingLock != null) {
                    nextWaitingLock.wakeUp((byte)1);
                    nextWaitingLock = null;
                }
            }
            if (actualTimeout == -1) continue;
            if (wakeupReason != 0) {
                ++earlyWakeupCount;
            }
            if (earlyWakeupCount <= 5) continue;
            long now = System.currentTimeMillis();
            if (startWaitTime != 0L) {
                long sleepTime = now - startWaitTime;
                actualTimeout = (int)((long)actualTimeout - sleepTime);
            }
            startWaitTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlock(Latch item, int unlockCount) {
        Entry entry = this.locks.get(item.getLockable());
        entry.lock();
        try {
            this.unlock(entry, item, unlockCount);
        }
        finally {
            entry.unlock();
        }
    }

    private void unlock(Entry entry, Latch item, int unlockCount) {
        SanityManager.ASSERT((boolean)entry.mutex.isHeldByCurrentThread());
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            SanityManager.DEBUG((String)"LockTrace", (String)("Release lock: " + DiagnosticUtil.toDiagString(item)));
        }
        boolean tryGrant = false;
        ActiveLock nextGrant = null;
        Control control = entry.control;
        if (item.getLockable() == null) {
            SanityManager.THROWASSERT((String)("item.getLockable() = null.unlockCount " + unlockCount + "item = " + DiagnosticUtil.toDiagString(item)));
        }
        if (control == null) {
            SanityManager.THROWASSERT((String)("control = null.unlockCount " + unlockCount + "item = " + DiagnosticUtil.toDiagString(item)));
        }
        SanityManager.ASSERT((this.locks.get((Object)control.getLockable()).control == control ? 1 : 0) != 0);
        if (unlockCount != 0 && unlockCount > item.getCount()) {
            SanityManager.THROWASSERT((String)("unlockCount " + unlockCount + " larger than actual lock count " + item.getCount() + " item " + item));
        }
        tryGrant = control.unlock(item, unlockCount);
        item = null;
        boolean mayBeEmpty = true;
        if (tryGrant && (nextGrant = control.firstWaiter()) != null) {
            mayBeEmpty = false;
            if (!nextGrant.setPotentiallyGranted()) {
                nextGrant = null;
            }
        }
        if (mayBeEmpty) {
            if (control.isEmpty()) {
                this.locks.remove(control.getLockable());
                entry.control = null;
            }
            return;
        }
        if (tryGrant && nextGrant != null) {
            nextGrant.wakeUp((byte)1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lock unlockReference(CompatibilitySpace space, Lockable ref, Object qualifier, Map group) {
        Entry entry = this.locks.get(ref);
        if (entry == null) {
            return null;
        }
        entry.lock();
        try {
            Control control = entry.control;
            if (control == null) {
                Lock lock = null;
                return lock;
            }
            Lock setLock = control.getLock(space, qualifier);
            if (setLock == null) {
                Lock lock = null;
                return lock;
            }
            Lock lockInGroup = (Lock)group.remove(setLock);
            if (lockInGroup != null) {
                this.unlock(entry, lockInGroup, 1);
            }
            Lock lock = lockInGroup;
            return lock;
        }
        finally {
            entry.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean zeroDurationLockObject(CompatibilitySpace space, Lockable ref, Object qualifier, int timeout) throws StandardException {
        Entry entry;
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Zero Duration Lock Request before Grant: ", space, null, ref, qualifier, timeout);
            if (SanityManager.DEBUG_ON((String)"LockStackTrace")) {
                Throwable t = new Throwable();
                PrintWriter istream = SanityManager.GET_DEBUG_STREAM();
                istream.println("Stack trace of lock request:");
                t.printStackTrace(istream);
            }
        }
        if ((entry = this.locks.get(ref)) == null) {
            return true;
        }
        entry.lock();
        try {
            Control control = entry.control;
            if (control == null) {
                boolean bl = true;
                return bl;
            }
            if (control.isGrantable(true, space, qualifier)) {
                boolean bl = true;
                return bl;
            }
            if (AbstractPool.noLockWait(timeout, space)) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            entry.unlock();
        }
        Lock lock = this.lockObject(space, ref, qualifier, timeout);
        if (SanityManager.DEBUG_ON((String)"LockTrace")) {
            D_LockControl.debugLock("Zero Lock Request Granted: ", space, null, ref, qualifier, timeout);
        }
        this.unlock(lock, 1);
        return true;
    }

    @Override
    public void setDeadlockTimeout(int timeout) {
        this.deadlockTimeout = timeout;
    }

    @Override
    public void setWaitTimeout(int timeout) {
        this.waitTimeout = timeout;
    }

    @Override
    public void setDeadlockTrace(boolean val) {
        this.deadlockTrace = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String toDebugString() {
        String str = new String();
        int i = 0;
        for (Entry entry : this.locks.values()) {
            entry.lock();
            try {
                str = str + "\n  lock[" + i + "]: " + DiagnosticUtil.toDiagString(entry.control);
            }
            finally {
                entry.unlock();
            }
        }
        return str;
    }

    @Override
    public void addWaiters(Map waiters) {
        this.seenByDeadlockDetection = new ArrayList(this.locks.size());
        for (Entry entry : this.locks.values()) {
            this.seenByDeadlockDetection.add(entry);
            entry.lockForDeadlockDetection();
            if (entry.control == null) continue;
            entry.control.addWaiters(waiters);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Lockable, Control> shallowClone() {
        HashMap<Lockable, Control> clone = new HashMap<Lockable, Control>();
        for (Entry entry : this.locks.values()) {
            entry.lock();
            try {
                Control control = entry.control;
                if (control == null) continue;
                clone.put(control.getLockable(), control.shallowClone());
            }
            finally {
                entry.unlock();
            }
        }
        return clone;
    }

    @Override
    public void oneMoreWaiter() {
        this.blockCount.incrementAndGet();
    }

    @Override
    public void oneLessWaiter() {
        this.blockCount.decrementAndGet();
    }

    @Override
    public boolean anyoneBlocked() {
        int blocked = this.blockCount.get();
        SanityManager.ASSERT((blocked >= 0 ? 1 : 0) != 0, (String)"blockCount should not be negative");
        return blocked != 0;
    }

    private static final class Entry {
        Control control;
        private final ReentrantLock mutex = new ReentrantLock();
        private Condition deadlockDetection;

        private Entry() {
        }

        void lock() {
            SanityManager.ASSERT((!this.mutex.isHeldByCurrentThread() ? 1 : 0) != 0);
            this.mutex.lock();
            while (this.deadlockDetection != null) {
                Misc.awaitForCondition(this.deadlockDetection);
            }
        }

        void unlock() {
            this.mutex.unlock();
        }

        void lockForDeadlockDetection() {
            SanityManager.ASSERT((!this.mutex.isHeldByCurrentThread() ? 1 : 0) != 0);
            this.mutex.lock();
        }

        void enterDeadlockDetection() {
            this.deadlockDetection = this.mutex.newCondition();
            this.mutex.unlock();
        }

        void exitDeadlockDetection() {
            SanityManager.ASSERT((!this.mutex.isHeldByCurrentThread() ? 1 : 0) != 0);
            this.mutex.lock();
            this.deadlockDetection.signalAll();
            this.deadlockDetection = null;
        }
    }
}

