/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.cache;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheManager;
import com.pivotal.gemfirexd.internal.iapi.services.cache.Cacheable;
import com.pivotal.gemfirexd.internal.iapi.services.cache.CacheableFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;

final class CachedItem {
    private boolean valid_ = false;
    private boolean removeRequested_ = false;
    private boolean settingIdentity_ = false;
    private boolean removeOk_ = false;
    private boolean recentlyUsed_ = false;
    private int keepCount;
    private Cacheable entry;

    public void keepAfterSearch() {
        ++this.keepCount;
        this.setUsed(true);
    }

    public void keepForCreate() {
        SanityManager.ASSERT((!this.isKept() ? 1 : 0) != 0);
        SanityManager.ASSERT((!this.isValid() ? 1 : 0) != 0);
        this.keepCount = 1;
        this.settingIdentity_ = true;
    }

    public void unkeepForCreate() {
        this.settingIdentityComplete();
        this.unkeep();
    }

    public void keepForClean() {
        SanityManager.ASSERT((boolean)this.isValid());
        ++this.keepCount;
    }

    public synchronized boolean unkeep() {
        boolean unkept = --this.keepCount == 0;
        SanityManager.ASSERT((this.keepCount >= 0 ? 1 : 0) != 0);
        return unkept && this.removeRequested_;
    }

    public final boolean isKept() {
        return this.keepCount != 0;
    }

    public void clean(boolean forRemove) throws StandardException {
        this.entry.clean(forRemove);
    }

    public synchronized void setRemoveState() {
        this.removeRequested_ = true;
    }

    public final synchronized boolean isValid() {
        return this.valid_;
    }

    public synchronized void setValidState(boolean flag) {
        this.valid_ = flag;
        this.removeRequested_ = false;
        this.removeOk_ = false;
        this.recentlyUsed_ = flag;
    }

    public Cacheable getEntry() {
        return this.entry;
    }

    public Cacheable takeOnIdentity(CacheManager cm, CacheableFactory holderFactory, Object key, boolean forCreate, Object createParameter) throws StandardException {
        Cacheable oldEntry = this.entry;
        if (oldEntry == null) {
            oldEntry = holderFactory.newCacheable(cm);
        }
        this.entry = forCreate ? oldEntry.createIdentity(key, createParameter) : oldEntry.setIdentity(key);
        if (this.entry != null) {
            SanityManager.ASSERT((boolean)this.entry.getIdentity().equals(key));
            return this.entry;
        }
        this.entry = oldEntry;
        return null;
    }

    public synchronized void settingIdentityComplete() {
        this.settingIdentity_ = false;
        this.notifyAll();
    }

    public synchronized Cacheable use() throws StandardException {
        while (this.settingIdentity_) {
            try {
                SanityManager.DEBUG((String)"CacheTrace", (String)"trying to use a cached item that is taking on an identity");
                this.wait();
            }
            catch (InterruptedException ie) {
                throw StandardException.interrupt(ie);
            }
        }
        if (!this.valid_) {
            return null;
        }
        if (SanityManager.DEBUG_ON((String)"CacheTrace")) {
            SanityManager.DEBUG((String)"CacheTrace", (String)("item keep count is " + this.keepCount));
        }
        return this.entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(boolean removeNow) throws StandardException {
        if (!removeNow) {
            CachedItem cachedItem = this;
            synchronized (cachedItem) {
                while (!this.removeOk_) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ie) {
                        throw StandardException.interrupt(ie);
                    }
                }
            }
        }
        this.clean(true);
    }

    public synchronized void notifyRemover() {
        SanityManager.ASSERT((boolean)this.removeRequested_);
        SanityManager.ASSERT((boolean)this.isKept());
        this.removeOk_ = true;
        this.notifyAll();
    }

    public synchronized void setUsed(boolean flag) {
        this.recentlyUsed_ = flag;
    }

    public synchronized boolean recentlyUsed() {
        return this.recentlyUsed_;
    }
}

