/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.services.bytecode;

import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassFormatOutput;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassHolder;
import com.pivotal.gemfirexd.internal.iapi.services.classfile.ClassMember;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.ClassBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.LocalField;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCClass;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCJava;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCLocalField;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCMethodCaller;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.BCMethodDescriptor;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.CodeChunk;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.Conditional;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.Type;
import com.pivotal.gemfirexd.internal.impl.services.bytecode.d_BCValidate;
import java.io.IOException;
import java.util.Vector;

class BCMethod
implements MethodBuilder {
    static final int CODE_SPLIT_LENGTH = 65535;
    final BCClass cb;
    protected final ClassHolder modClass;
    final String myReturnType;
    private final String myName;
    BCLocalField[] parameters;
    private final String[] parameterTypes;
    Vector thrownExceptions;
    CodeChunk myCode;
    protected ClassMember myEntry;
    private int currentVarNum;
    private int statementNum;
    private boolean handlingOverflow;
    private int subMethodCount;
    private Type[] stackTypes = new Type[8];
    private int stackTypeOffset;
    int maxStack;
    private int stackDepth;
    private Conditional condition;
    private static final byte[] newArrayElementTypeMap = new byte[]{8, 9, 10, 11, 6, 7, 5};
    static final byte T_BOOLEAN = 4;

    BCMethod(ClassBuilder cb, String returnType, String methodName, int modifiers, String[] parms, BCJava factory) {
        String[] vmParamterTypes;
        this.cb = (BCClass)cb;
        this.modClass = this.cb.modify();
        this.myReturnType = returnType;
        this.myName = methodName;
        this.cb.validateType(returnType);
        if ((modifiers & 8) == 0) {
            this.currentVarNum = 1;
        }
        if (parms != null && parms.length != 0) {
            int len = parms.length;
            vmParamterTypes = new String[len];
            this.parameters = new BCLocalField[len];
            for (int i = 0; i < len; ++i) {
                Type t = factory.type(parms[i]);
                this.parameters[i] = new BCLocalField(t, this.currentVarNum);
                this.currentVarNum += t.width();
                vmParamterTypes[i] = t.vmName();
            }
        } else {
            vmParamterTypes = BCMethodDescriptor.EMPTY;
        }
        String sig = BCMethodDescriptor.get(vmParamterTypes, factory.type(returnType).vmName(), factory);
        this.myEntry = this.modClass.addMember(methodName, sig, modifiers);
        this.myCode = new CodeChunk(this.cb);
        this.parameterTypes = parms;
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void getParameter(int id) {
        int num = this.parameters[id].cpi;
        short typ = this.parameters[id].type.vmType();
        if (num < 4) {
            this.myCode.addInstr((short)(CodeChunk.LOAD_VARIABLE_FAST[typ] + num));
        } else {
            this.myCode.addInstrWide(CodeChunk.LOAD_VARIABLE[typ], num);
        }
        this.growStack(this.parameters[id].type);
    }

    @Override
    public void addThrownException(String exceptionClass) {
        if (this.myCode.getPC() != 0) {
            SanityManager.THROWASSERT((String)("Adding exception after code generation " + exceptionClass + " to method " + this.getName()));
        }
        if (this.thrownExceptions == null) {
            this.thrownExceptions = new Vector();
        }
        this.thrownExceptions.addElement(exceptionClass);
    }

    @Override
    public void complete() {
        if (this.myCode.getPC() > 65535) {
            this.splitMethod();
        }
        this.writeExceptions();
        this.myCode.complete(this, this.modClass, this.myEntry, this.maxStack, this.currentVarNum);
    }

    private void splitMethod() {
        int split_pc = 0;
        boolean splittingZeroStack = true;
        int codeLength = this.myCode.getPC();
        while (this.cb.limitMsg == null && codeLength > 65535) {
            int lengthToCheck;
            int optimalMinLength = codeLength < 131070 ? codeLength - 65535 : 65534;
            if (optimalMinLength > (lengthToCheck = codeLength - split_pc)) {
                optimalMinLength = lengthToCheck;
            }
            if ((split_pc = splittingZeroStack ? this.myCode.splitZeroStack(this, this.modClass, split_pc, optimalMinLength) : this.myCode.splitExpressionOut(this, this.modClass, optimalMinLength, this.maxStack)) < 0) {
                if (!splittingZeroStack) break;
                splittingZeroStack = false;
                split_pc = 0;
            }
            codeLength = this.myCode.getPC();
        }
    }

    ClassHolder constantPool() {
        return this.modClass;
    }

    protected void writeExceptions() {
        if (this.thrownExceptions == null) {
            return;
        }
        int numExc = this.thrownExceptions.size();
        if (numExc != 0) {
            try {
                ClassFormatOutput eout = new ClassFormatOutput(numExc * 2 + 2);
                eout.putU2(numExc);
                for (int i = 0; i < numExc; ++i) {
                    String e = this.thrownExceptions.elementAt(i).toString();
                    int ei2 = this.modClass.addClassReference(e);
                    eout.putU2(ei2);
                }
                this.myEntry.addAttribute("Exceptions", eout);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void growStack(int size, Type type) {
        this.stackDepth += size;
        if (this.stackDepth > this.maxStack) {
            this.maxStack = this.stackDepth;
        }
        if (this.stackTypeOffset >= this.stackTypes.length) {
            Type[] newStackTypes = new Type[this.stackTypes.length + 8];
            System.arraycopy(this.stackTypes, 0, newStackTypes, 0, this.stackTypes.length);
            this.stackTypes = newStackTypes;
        }
        this.stackTypes[this.stackTypeOffset++] = type;
        int sum = 0;
        for (int i = 0; i < this.stackTypeOffset; ++i) {
            sum += this.stackTypes[i].width();
        }
        if (sum != this.stackDepth) {
            SanityManager.THROWASSERT((String)("invalid stack depth " + this.stackDepth + " calc " + sum));
        }
    }

    private void growStack(Type type) {
        this.growStack(type.width(), type);
    }

    private Type popStack() {
        --this.stackTypeOffset;
        Type topType = this.stackTypes[this.stackTypeOffset];
        this.stackDepth -= topType.width();
        return topType;
    }

    private Type[] copyStack() {
        Type[] stack = new Type[this.stackTypeOffset];
        System.arraycopy(this.stackTypes, 0, stack, 0, this.stackTypeOffset);
        return stack;
    }

    @Override
    public void pushThis() {
        this.myCode.addInstr((short)42);
        this.growStack(1, this.cb.classType);
    }

    @Override
    public void push(byte value) {
        this.push(value, Type.BYTE);
    }

    @Override
    public void push(boolean value) {
        this.push(value ? 1 : 0, Type.BOOLEAN);
    }

    @Override
    public void push(short value) {
        this.push(value, Type.SHORT);
    }

    @Override
    public void push(int value) {
        this.push(value, Type.INT);
    }

    @Override
    public void dup() {
        Type dup = this.popStack();
        this.myCode.addInstr(dup.width() == 2 ? (short)92 : 89);
        this.growStack(dup);
        this.growStack(dup);
    }

    @Override
    public void swap() {
        Type wB = this.popStack();
        Type wA = this.popStack();
        this.growStack(wB);
        this.growStack(wA);
        if (wB.width() == 1) {
            if (wA.width() == 1) {
                this.myCode.addInstr((short)95);
                return;
            }
            this.myCode.addInstr((short)91);
            this.myCode.addInstr((short)87);
        } else if (wA.width() == 1) {
            this.myCode.addInstr((short)93);
            this.myCode.addInstr((short)88);
        } else {
            this.myCode.addInstr((short)94);
            this.myCode.addInstr((short)88);
        }
        this.growStack(wB);
        this.popStack();
    }

    private void push(int value, Type type) {
        CodeChunk chunk = this.myCode;
        if (value >= -1 && value <= 5) {
            chunk.addInstr((short)(3 + value));
        } else if (value >= -128 && value <= 127) {
            chunk.addInstrU1((short)16, value);
        } else if (value >= Short.MIN_VALUE && value <= Short.MAX_VALUE) {
            chunk.addInstrU2((short)17, value);
        } else {
            int cpe = this.modClass.addConstant(value);
            this.addInstrCPE((short)18, cpe);
        }
        this.growStack(type.width(), type);
    }

    @Override
    public void push(long value) {
        CodeChunk chunk = this.myCode;
        if (value == 0L || value == 1L) {
            short opcode = value == 0L ? (short)9 : 10;
            chunk.addInstr(opcode);
        } else {
            if (value >= Integer.MIN_VALUE && value <= Integer.MAX_VALUE) {
                this.push((int)value, Type.LONG);
                chunk.addInstr((short)133);
                return;
            }
            int cpe = this.modClass.addConstant(value);
            chunk.addInstrU2((short)20, cpe);
        }
        this.growStack(2, Type.LONG);
    }

    @Override
    public void push(float value) {
        CodeChunk chunk = this.myCode;
        if ((double)value == 0.0) {
            chunk.addInstr((short)11);
        } else if ((double)value == 1.0) {
            chunk.addInstr((short)12);
        } else if ((double)value == 2.0) {
            chunk.addInstr((short)13);
        } else {
            int cpe = this.modClass.addConstant(value);
            this.addInstrCPE((short)18, cpe);
        }
        this.growStack(1, Type.FLOAT);
    }

    @Override
    public void push(double value) {
        CodeChunk chunk = this.myCode;
        if (value == 0.0) {
            chunk.addInstr((short)14);
        } else {
            int cpe = this.modClass.addConstant(value);
            chunk.addInstrU2((short)20, cpe);
        }
        this.growStack(2, Type.DOUBLE);
    }

    @Override
    public void push(String value) {
        int cpe = this.modClass.addConstant(value);
        this.addInstrCPE((short)18, cpe);
        this.growStack(1, Type.STRING);
    }

    @Override
    public void methodReturn() {
        short opcode;
        if (this.stackDepth != 0) {
            Type topType = this.popStack();
            opcode = CodeChunk.RETURN_OPCODE[topType.vmType()];
        } else {
            opcode = 177;
        }
        this.myCode.addInstr(opcode);
        if (this.stackDepth != 0) {
            SanityManager.THROWASSERT((String)("items left on stack " + this.stackDepth));
        }
    }

    @Override
    public Object describeMethod(short opcode, String declaringClass, String methodName, String returnType) {
        Type rt = this.cb.factory.type(returnType);
        String methodDescriptor = BCMethodDescriptor.get(BCMethodDescriptor.EMPTY, rt.vmName(), this.cb.factory);
        if (declaringClass == null && opcode != 184) {
            Type dt = this.stackTypes[this.stackTypeOffset - 1];
            if (declaringClass == null) {
                declaringClass = dt.javaName();
            }
        }
        int cpi = this.modClass.addMethodReference(declaringClass, methodName, methodDescriptor, opcode == 185);
        return new BCMethodCaller(opcode, rt, cpi);
    }

    @Override
    public int callMethod(Object methodDescriptor) {
        this.popStack();
        BCMethodCaller mc = (BCMethodCaller)methodDescriptor;
        int cpi = mc.cpi;
        short opcode = mc.opcode;
        if (opcode == 185) {
            this.myCode.addInstrU2U1U1(opcode, cpi, (short)1, (short)0);
        } else {
            this.myCode.addInstrU2(opcode, cpi);
        }
        Type rt = mc.type;
        int rw = rt.width();
        if (rw != 0) {
            this.growStack(rw, rt);
        } else if (this.stackDepth == 0) {
            this.overflowMethodCheck();
        }
        return cpi;
    }

    @Override
    public int callMethod(short opcode, String declaringClass, String methodName, String returnType, int numArgs) {
        Type dtu;
        String[] vmParameterTypes;
        Type rt = this.cb.factory.type(returnType);
        int initialStackDepth = this.stackDepth;
        String[] debugParameterTypes = null;
        if (numArgs == 0) {
            vmParameterTypes = BCMethodDescriptor.EMPTY;
        } else {
            debugParameterTypes = new String[numArgs];
            vmParameterTypes = new String[numArgs];
            for (int i = numArgs - 1; i >= 0; --i) {
                Type at = this.popStack();
                vmParameterTypes[i] = at.vmName();
                debugParameterTypes[i] = at.javaName();
            }
        }
        String methodDescriptor = BCMethodDescriptor.get(vmParameterTypes, rt.vmName(), this.cb.factory);
        Type dt = null;
        if (opcode != 184) {
            dt = this.popStack();
        }
        if ((dtu = this.vmNameDeclaringClass(declaringClass)) != null) {
            dt = dtu;
        }
        int cpi = this.modClass.addMethodReference(dt.vmNameSimple, methodName, methodDescriptor, opcode == 185);
        if (opcode == 185) {
            short callArgCount = (short)(initialStackDepth - this.stackDepth);
            this.myCode.addInstrU2U1U1(opcode, cpi, callArgCount, (short)0);
        } else {
            this.myCode.addInstrU2(opcode, cpi);
        }
        int rw = rt.width();
        if (rw != 0) {
            this.growStack(rw, rt);
        } else if (this.stackDepth == 0) {
            this.overflowMethodCheck();
        }
        d_BCValidate.checkMethod(opcode, dt, methodName, debugParameterTypes, rt);
        return cpi;
    }

    private Type vmNameDeclaringClass(String declaringClass) {
        if (declaringClass == null) {
            return null;
        }
        return this.cb.factory.type(declaringClass);
    }

    @Override
    public void callSuper() {
        this.pushThis();
        this.callMethod((short)183, this.cb.getSuperClassName(), "<init>", "void", 0);
    }

    @Override
    public void pushNewStart(String className) {
        int cpi = this.modClass.addClassReference(className);
        this.myCode.addInstrU2((short)187, cpi);
        this.myCode.addInstr((short)89);
        Type nt = this.cb.factory.type(className);
        this.growStack(1, nt);
        this.growStack(1, nt);
    }

    @Override
    public void pushNewComplete(int numArgs) {
        this.callMethod((short)183, null, "<init>", "void", numArgs);
    }

    @Override
    public void upCast(String className) {
        Type uct;
        this.stackTypes[this.stackTypeOffset - 1] = uct = this.cb.factory.type(className);
    }

    @Override
    public void cast(String className) {
        Type tbc = this.stackTypes[this.stackTypeOffset - 1];
        short sourceType = tbc.vmType();
        if (sourceType == 7 && className.equals(tbc.javaName())) {
            return;
        }
        Type ct = this.cb.factory.type(className);
        this.popStack();
        short targetType = ct.vmType();
        if (!(sourceType == 7 && targetType == 7 || sourceType != 7 && targetType != 7)) {
            SanityManager.THROWASSERT((String)("Both or neither must be object types " + ct.javaName() + " " + tbc.javaName()));
        }
        if (sourceType == 7) {
            int cpi = this.modClass.addClassReference(ct.vmNameSimple);
            this.myCode.addInstrU2((short)192, cpi);
        } else {
            short opcode = 0;
            while (sourceType != targetType && opcode != -999) {
                short[] currentConversion = CodeChunk.CAST_CONVERSION_INFO[sourceType][targetType];
                sourceType = currentConversion[1];
                opcode = currentConversion[0];
                if (opcode == 0) continue;
                this.myCode.addInstr(opcode);
            }
            SanityManager.ASSERT((opcode != -999 ? 1 : 0) != 0, (String)"BAD VMOpcode not expected in cast");
        }
        this.growStack(ct);
    }

    @Override
    public void isInstanceOf(String className) {
        int cpi = this.modClass.addClassReference(className);
        this.myCode.addInstrU2((short)193, cpi);
        this.popStack();
        this.growStack(1, Type.BOOLEAN);
    }

    @Override
    public void pushNull(String type) {
        this.myCode.addInstr((short)1);
        this.growStack(1, this.cb.factory.type(type));
    }

    @Override
    public void getField(LocalField field) {
        BCLocalField lf = (BCLocalField)field;
        Type lt = lf.type;
        this.pushThis();
        this.myCode.addInstrU2((short)180, lf.cpi);
        this.popStack();
        this.growStack(lt);
    }

    @Override
    public void getField(String declaringClass, String fieldName, String fieldType) {
        Type dt = this.popStack();
        Type dtu = this.vmNameDeclaringClass(declaringClass);
        if (dtu != null) {
            dt = dtu;
        }
        this.getField((short)180, dt.vmNameSimple, fieldName, fieldType);
    }

    @Override
    public void getStaticField(String declaringClass, String fieldName, String fieldType) {
        this.getField((short)178, declaringClass, fieldName, fieldType);
    }

    private void getField(short opcode, String declaringClass, String fieldName, String fieldType) {
        Type ft = this.cb.factory.type(fieldType);
        int cpi = this.modClass.addFieldReference(this.vmNameDeclaringClass((String)declaringClass).vmNameSimple, fieldName, ft.vmName());
        this.myCode.addInstrU2(opcode, cpi);
        this.growStack(ft);
    }

    @Override
    public void setField(LocalField field) {
        BCLocalField lf = (BCLocalField)field;
        Type lt = lf.type;
        this.putField(lf.type, lf.cpi, false);
        if (this.stackDepth == 0) {
            this.overflowMethodCheck();
        }
    }

    @Override
    public void putField(LocalField field) {
        BCLocalField lf = (BCLocalField)field;
        Type lt = lf.type;
        this.putField(lf.type, lf.cpi, true);
    }

    @Override
    public void putField(String fieldName, String fieldType) {
        Type ft = this.cb.factory.type(fieldType);
        int cpi = this.modClass.addFieldReference(this.cb.classType.vmNameSimple, fieldName, ft.vmName());
        this.putField(ft, cpi, true);
    }

    private void putField(Type fieldType, int cpi, boolean dup) {
        if (dup) {
            this.myCode.addInstr(fieldType.width() == 2 ? (short)92 : 89);
            this.growStack(fieldType);
        }
        this.pushThis();
        this.swap();
        this.myCode.addInstrU2((short)181, cpi);
        this.popStack();
        this.popStack();
    }

    @Override
    public void putField(String declaringClass, String fieldName, String fieldType) {
        Type vt = this.popStack();
        Type dt = this.popStack();
        if (dt.width() != 1) {
            SanityManager.THROWASSERT((String)("reference expected for field access - is " + dt.javaName()));
        }
        this.myCode.addInstr(vt.width() == 2 ? (short)93 : 90);
        this.growStack(vt);
        this.growStack(dt);
        this.growStack(vt);
        Type dtu = this.vmNameDeclaringClass(declaringClass);
        if (dtu != null) {
            dt = dtu;
        }
        Type ft = this.cb.factory.type(fieldType);
        int cpi = this.modClass.addFieldReference(dt.vmNameSimple, fieldName, ft.vmName());
        this.myCode.addInstrU2((short)181, cpi);
        this.popStack();
        this.popStack();
    }

    @Override
    public void conditionalIfNull() {
        this.conditionalIf((short)199);
    }

    @Override
    public void conditionalIf() {
        this.conditionalIf((short)153);
    }

    private void conditionalIf(short opcode) {
        this.popStack();
        this.condition = new Conditional(this.condition, this.myCode, opcode, this.copyStack());
    }

    @Override
    public void startElseCode() {
        Type[] entryStack = this.condition.startElse(this, this.myCode, this.copyStack());
        this.stackDepth = 0;
        for (int i = 0; i < entryStack.length; ++i) {
            this.stackTypes[i] = entryStack[i];
            this.stackDepth += this.stackTypes[i].width();
        }
        this.stackTypeOffset = entryStack.length;
    }

    @Override
    public void completeConditional() {
        this.condition = this.condition.end(this, this.myCode, this.stackTypes, this.stackTypeOffset);
    }

    @Override
    public void pop() {
        Type toPop;
        if (this.stackDepth == 0) {
            SanityManager.THROWASSERT((String)"pop when stack is empty!");
        }
        this.myCode.addInstr((toPop = this.popStack()).width() == 2 ? (short)88 : 87);
        if (this.stackDepth == 0) {
            this.overflowMethodCheck();
        }
    }

    @Override
    public void endStatement() {
        if (this.stackDepth != 0) {
            this.pop();
        }
    }

    @Override
    public boolean getArrayElement(int element) {
        boolean isArrayType;
        String componentString;
        this.push(element);
        this.popStack();
        Type arrayType = this.popStack();
        String arrayJava = arrayType.javaName();
        if (arrayJava.endsWith("[]")) {
            componentString = arrayJava.substring(0, arrayJava.length() - 2);
            isArrayType = !"java.lang.Object".equals(componentString);
        } else {
            componentString = arrayJava;
            isArrayType = false;
        }
        Type componentType = this.cb.factory.type(componentString);
        short typ = componentType.vmType();
        if (typ == 2 && componentType.vmName().equals("Z")) {
            typ = 0;
        }
        this.myCode.addInstr(CodeChunk.ARRAY_ACCESS[typ]);
        this.growStack(componentType);
        return isArrayType;
    }

    @Override
    public void setArrayElement(int element) {
        this.push(element);
        this.swap();
        Type componentType = this.popStack();
        this.popStack();
        this.popStack();
        short typ = componentType.vmType();
        if (typ == 2 && componentType.vmName().equals("Z")) {
            typ = 0;
        }
        this.myCode.addInstr(CodeChunk.ARRAY_STORE[typ]);
    }

    @Override
    public void pushNewArray(String className, int size) {
        this.push(size);
        this.popStack();
        Type elementType = this.cb.factory.type(className);
        if (elementType.vmType() == 7) {
            int cpi = this.modClass.addClassReference(elementType.javaName());
            this.myCode.addInstrU2((short)189, cpi);
        } else {
            int atype = elementType.vmType() == 2 && 'Z' == elementType.vmName().charAt(0) ? 4 : newArrayElementTypeMap[elementType.vmType()];
            this.myCode.addInstrU1((short)188, atype);
        }
        this.growStack(1, this.cb.factory.type(className.concat("[]")));
    }

    private void addInstrCPE(short opcode, int cpe) {
        if (cpe >= 65535) {
            this.cb.addLimitExceeded(this, "constant_pool_count", 65535, cpe);
        }
        this.myCode.addInstrCPE(opcode, cpe);
    }

    @Override
    public boolean statementNumHitLimit(int noStatementsAdded) {
        if (this.statementNum > 2048) {
            return true;
        }
        this.statementNum += noStatementsAdded;
        return false;
    }

    private void overflowMethodCheck() {
        if (this.handlingOverflow) {
            return;
        }
        if (this.condition != null) {
            return;
        }
        int currentCodeSize = this.myCode.getPC();
        if (currentCodeSize < 55000) {
            return;
        }
        if (this.parameters != null && this.parameters.length != 0) {
            return;
        }
        BCMethod subMethod = this.getNewSubMethod(this.myReturnType, false);
        this.handlingOverflow = true;
        this.callSubMethod(subMethod);
        this.methodReturn();
        this.complete();
        this.handlingOverflow = false;
        this.myEntry = subMethod.myEntry;
        this.myCode = subMethod.myCode;
        this.currentVarNum = subMethod.currentVarNum;
        this.statementNum = subMethod.statementNum;
        this.stackTypes = subMethod.stackTypes;
        this.stackTypeOffset = subMethod.stackTypeOffset;
        this.maxStack = subMethod.maxStack;
        this.stackDepth = subMethod.stackDepth;
    }

    final BCMethod getNewSubMethod(String returnType, boolean withParameters) {
        int modifiers = this.myEntry.getModifier();
        modifiers &= 0xFFFFFFFA;
        String subMethodName = this.myName + "_s" + Integer.toString(this.subMethodCount++);
        BCMethod subMethod = (BCMethod)this.cb.newMethodBuilder(modifiers |= 2, returnType, subMethodName, withParameters ? this.parameterTypes : null);
        subMethod.thrownExceptions = this.thrownExceptions;
        return subMethod;
    }

    final void callSubMethod(BCMethod subMethod) {
        short op;
        if ((this.myEntry.getModifier() & 8) == 0) {
            op = 182;
            this.pushThis();
        } else {
            op = 184;
        }
        int parameterCount = subMethod.parameters == null ? 0 : subMethod.parameters.length;
        for (int pi = 0; pi < parameterCount; ++pi) {
            this.getParameter(pi);
        }
        this.callMethod(op, this.modClass.getName(), subMethod.getName(), subMethod.myReturnType, parameterCount);
    }
}

