/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.load;

import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.util.PrivilegedFileOps;
import com.pivotal.gemfirexd.internal.impl.load.ControlInfo;
import com.pivotal.gemfirexd.internal.impl.load.ExportAbstract;
import com.pivotal.gemfirexd.internal.impl.load.ExportWriteData;
import com.pivotal.gemfirexd.internal.impl.load.ExportWriteDataAbstract;
import com.pivotal.gemfirexd.internal.impl.load.LoadError;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;

public class Export
extends ExportAbstract {
    private String outputFileName;
    private String lobsFileName;

    private void doExport() throws SQLException {
        try {
            if (this.entityName == null && this.selectStatement == null) {
                throw LoadError.entityNameMissing();
            }
            if (this.outputFileName == null) {
                throw LoadError.dataFileNull();
            }
            if (this.dataFileExists(this.outputFileName)) {
                throw LoadError.dataFileExists(this.outputFileName);
            }
            if (this.lobsFileName != null && this.lobsFileExists(this.lobsFileName)) {
                throw LoadError.lobsFileExists(this.lobsFileName);
            }
            try {
                this.doAllTheWork();
            }
            catch (IOException iex) {
                throw LoadError.errorWritingData(iex);
            }
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    private Export(Connection con, String schemaName, String tableName, String selectStatement, String outputFileName, String characterDelimeter, String columnDelimeter, String codeset) throws SQLException {
        this.con = con;
        this.schemaName = schemaName;
        this.entityName = tableName;
        this.selectStatement = selectStatement;
        this.outputFileName = outputFileName;
        try {
            this.controlFileReader = new ControlInfo();
            this.controlFileReader.setControlProperties(characterDelimeter, columnDelimeter, codeset);
        }
        catch (Exception ex) {
            throw LoadError.unexpectedError(ex);
        }
    }

    private void setLobsExtFileName(String lobsFileName) throws SQLException {
        if (lobsFileName == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0Q.S"));
        }
        this.lobsFileName = lobsFileName;
        this.lobsInExtFile = true;
    }

    private boolean lobsFileExists(String fileName) throws SQLException {
        if (fileName == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE0Q.S"));
        }
        File file = new File(fileName);
        return PrivilegedFileOps.exists(file);
    }

    private boolean dataFileExists(String fileName) throws SQLException {
        if (fileName == null) {
            throw PublicAPI.wrapStandardException(StandardException.newException("XIE05.S"));
        }
        File file = new File(fileName);
        return PrivilegedFileOps.exists(file);
    }

    public static void exportTable(Connection con, String schemaName, String tableName, String outputFileName, String columnDelimeter, String characterDelimeter, String codeset) throws SQLException {
        Export fex = new Export(con, schemaName, tableName, null, outputFileName, characterDelimeter, columnDelimeter, codeset);
        fex.doExport();
    }

    public static void exportTable(Connection con, String schemaName, String tableName, String outputFileName, String columnDelimeter, String characterDelimeter, String codeset, String lobsFileName) throws SQLException {
        Export fex = new Export(con, schemaName, tableName, null, outputFileName, characterDelimeter, columnDelimeter, codeset);
        fex.setLobsExtFileName(lobsFileName);
        fex.doExport();
    }

    public static void exportQuery(Connection con, String selectStatement, String outputFileName, String columnDelimeter, String characterDelimeter, String codeset) throws SQLException {
        Export fex = new Export(con, null, null, selectStatement, outputFileName, characterDelimeter, columnDelimeter, codeset);
        fex.doExport();
    }

    public static void exportQuery(Connection con, String selectStatement, String outputFileName, String columnDelimeter, String characterDelimeter, String codeset, String lobsFileName) throws SQLException {
        Export fex = new Export(con, null, null, selectStatement, outputFileName, characterDelimeter, columnDelimeter, codeset);
        fex.setLobsExtFileName(lobsFileName);
        fex.doExport();
    }

    @Override
    protected ExportWriteDataAbstract getExportWriteData() throws Exception {
        if (this.lobsInExtFile) {
            return new ExportWriteData(this.outputFileName, this.lobsFileName, this.controlFileReader);
        }
        return new ExportWriteData(this.outputFileName, this.controlFileReader);
    }
}

