/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.DerbyIOException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.SQLExceptionFactory;
import java.io.IOException;
import java.sql.SQLException;

public abstract class Util {
    private static SQLExceptionFactory exceptionFactory = new SQLExceptionFactory();

    private static SQLException newEmbedSQLException(String messageId, Object[] args, SQLException next, int severity, Throwable t) {
        String message = MessageService.getCompleteMessage(messageId, args);
        return exceptionFactory.getSQLException(message, messageId, next, severity, t, args);
    }

    public static SQLException newEmbedSQLException(String messageId, Object[] args, int severity) {
        return Util.newEmbedSQLException(messageId, args, null, severity, null);
    }

    public static SQLException newEmbedSQLException(String messageId, Object[] args, Throwable cause) {
        return Util.newEmbedSQLException(messageId, args, null, StandardException.getSeverityFromIdentifier(messageId), cause);
    }

    static SQLException seeNextException(StandardException se, SQLException next) {
        return exceptionFactory.getSQLException(se.getMessage(), se.getMessageId(), next, se.getSeverity(), null, se.getArguments());
    }

    private static SQLException newEmbedSQLException(String messageId, Object[] args, int severity, Throwable t) {
        return Util.newEmbedSQLException(messageId, args, null, severity, t);
    }

    private static SQLException newEmbedSQLException(String messageId, int severity) {
        return Util.newEmbedSQLException(messageId, null, null, severity, null);
    }

    public static void ASSERT(EmbedConnection conn, boolean mustBeTrue, String msg) throws SQLException {
        try {
            SanityManager.ASSERT((boolean)mustBeTrue, (String)msg);
        }
        catch (Throwable t) {
            SQLException se = conn.handleException(t);
            SanityManager.ASSERT((boolean)(se instanceof DerbySQLException));
            throw se;
        }
    }

    static void THROWASSERT(EmbedConnection conn, String msg) throws SQLException {
        try {
            SanityManager.THROWASSERT((String)msg);
        }
        catch (Throwable t) {
            SQLException se = conn.handleException(t);
            SanityManager.ASSERT((boolean)(se instanceof DerbySQLException));
            throw se;
        }
    }

    static SQLException newException(String messageID, Object a1, Object a2, Object a3) {
        return Util.newEmbedSQLException(messageID, new Object[]{a1, a2, a3}, StandardException.getSeverityFromIdentifier(messageID));
    }

    public static SQLException generateCsSQLException(String error) {
        return Util.newEmbedSQLException(error, StandardException.getSeverityFromIdentifier(error));
    }

    public static SQLException generateCsSQLException(String error, Object arg1) {
        return Util.newEmbedSQLException(error, new Object[]{arg1}, StandardException.getSeverityFromIdentifier(error));
    }

    public static SQLException generateCsSQLException(String error, Object arg1, Object arg2) {
        return Util.newEmbedSQLException(error, new Object[]{arg1, arg2}, StandardException.getSeverityFromIdentifier(error));
    }

    public static SQLException generateCsSQLException(String error, Object arg1, Object arg2, Object arg3) {
        return Util.newEmbedSQLException(error, new Object[]{arg1, arg2, arg3}, StandardException.getSeverityFromIdentifier(error));
    }

    public static SQLException generateCsSQLException(String error, Object arg1, Throwable t) {
        return Util.newEmbedSQLException(error, new Object[]{arg1}, StandardException.getSeverityFromIdentifier(error), t);
    }

    public static SQLException generateCsSQLException(StandardException se) {
        DerbyIOException dioe;
        Throwable cause = se.getCause();
        if (cause instanceof StandardException) {
            cause = Util.generateCsSQLException((StandardException)cause);
        } else if (cause instanceof DerbyIOException && (dioe = (DerbyIOException)cause).getSQLState() != null) {
            cause = exceptionFactory.getSQLException(dioe.getMessage(), dioe.getSQLState(), null, StandardException.getSeverityFromIdentifier(dioe.getSQLState()), cause.getCause(), null);
        }
        SQLException sqle = exceptionFactory.getSQLException(se.getMessage(), se.getMessageId(), null, se.getSeverity(), cause, se.getArguments());
        sqle.setStackTrace(se.getStackTrace());
        return sqle;
    }

    public static SQLException noCurrentConnection() {
        return Util.newEmbedSQLException("08003", StandardException.getSeverityFromIdentifier("08003"));
    }

    static SQLException seeNextException(String messageId, Object[] args, SQLException next) {
        return Util.newEmbedSQLException(messageId, args, next, StandardException.getSeverityFromIdentifier(messageId), null);
    }

    public static SQLException javaException(Throwable t) {
        String msg = t.getMessage();
        if (msg == null) {
            msg = "";
        }
        String name = t.getClass().getName();
        SQLException next = null;
        Throwable cause = t.getCause();
        if (cause != null) {
            next = cause instanceof SQLException ? (SQLException)cause : (cause instanceof StandardException ? Util.generateCsSQLException((StandardException)cause) : Util.javaException(cause));
        }
        return Util.newEmbedSQLException("XJ001.U", new Object[]{name, msg}, next, 0, t);
    }

    public static SQLException policyNotReloaded(Throwable t) {
        return Util.newEmbedSQLException("XK000.S", new Object[]{t.getMessage()}, StandardException.getSeverityFromIdentifier("XK000.S"), t);
    }

    public static SQLException notImplemented() {
        return Util.notImplemented(MessageService.getTextMessage("J008"));
    }

    public static SQLException notImplemented(String feature) {
        return Util.newEmbedSQLException("0A000.S", new Object[]{feature}, StandardException.getSeverityFromIdentifier("0A000.S"));
    }

    static SQLException setStreamFailure(IOException e) {
        String msg = e.getMessage();
        if (msg == null) {
            msg = e.getClass().getName();
        }
        return Util.generateCsSQLException("XJ022.S", (Object)msg, e);
    }

    static SQLException typeMisMatch(int targetSQLType) {
        return Util.newEmbedSQLException("XJ020.S", new Object[]{Util.typeName(targetSQLType)}, StandardException.getSeverityFromIdentifier("XJ020.S"));
    }

    static IOException newIOException(Throwable cause) {
        IOException ioe = new IOException(cause.getMessage());
        ioe.initCause(cause);
        return ioe;
    }

    public static void setExceptionFactory(SQLExceptionFactory factory) {
        exceptionFactory = factory;
    }

    public static SQLExceptionFactory getExceptionFactory() {
        return exceptionFactory;
    }

    public static String typeName(int jdbcType) {
        switch (jdbcType) {
            case 2003: {
                return "ARRAY";
            }
            case -7: {
                return "CHAR () FOR BIT DATA";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 70: {
                return "DATALINK";
            }
            case -6: {
                return "TINYINT";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: {
                return "FLOAT";
            }
            case 7: {
                return "REAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 2: {
                return "NUMERIC";
            }
            case 3: {
                return "DECIMAL";
            }
            case 1: {
                return "CHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -2: {
                return "BINARY";
            }
            case -3: {
                return "VARBINARY";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case 1111: {
                return "OTHER";
            }
            case 2000: {
                return "Types.JAVA_OBJECT";
            }
            case 2006: {
                return "REF";
            }
            case -8: {
                return "ROWID";
            }
            case 2002: {
                return "STRUCT";
            }
            case 456: {
                return "XML";
            }
            case 2009: {
                return "SQLXML";
            }
            case 4002: {
                return "JSON";
            }
        }
        return String.valueOf(jdbcType);
    }
}

