/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.jdbc;

import com.gemstone.gemfire.distributed.DistributedMember;
import com.pivotal.gemfirexd.internal.iapi.error.DerbySQLException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedSQLException;
import com.pivotal.gemfirexd.internal.impl.jdbc.SQLExceptionFactory;
import com.pivotal.gemfirexd.internal.shared.common.error.DefaultExceptionFactory40;
import java.sql.SQLDataException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLIntegrityConstraintViolationException;
import java.sql.SQLInvalidAuthorizationSpecException;
import java.sql.SQLNonTransientConnectionException;
import java.sql.SQLSyntaxErrorException;
import java.sql.SQLTransactionRollbackException;

public class SQLExceptionFactory40
extends SQLExceptionFactory {
    @Override
    public SQLException getSQLException(String message, String messageId, SQLException next, int severity, Throwable t, Object[] args) {
        String sqlState = StandardException.getSQLStateFromIdentifier(messageId);
        if (sqlState.startsWith("08")) {
            return new EmbedSQLNonTransientConnectionException(message, messageId, next, severity, t, args);
        }
        if (sqlState.startsWith("22")) {
            return new EmbedSQLDataException(message, messageId, next, severity, t, args);
        }
        if (sqlState.startsWith("23")) {
            return new EmbedSQLIntegrityConstraintViolationException(message, messageId, next, severity, t, args);
        }
        if (sqlState.startsWith("28") || sqlState.startsWith("425")) {
            return new EmbedSQLInvalidAuthorizationSpecException(message, messageId, next, severity, t, args);
        }
        if (DefaultExceptionFactory40.isTransactionException((String)sqlState)) {
            return new EmbedSQLTransactionRollbackException(message, messageId, next, severity, t, args);
        }
        if (sqlState.startsWith("42")) {
            return new EmbedSQLSyntaxErrorException(message, messageId, next, severity, t, args);
        }
        if (sqlState.startsWith("0A")) {
            return new EmbedSQLFeatureNotSupportedException(message, messageId, next, severity, t, args);
        }
        return new EmbedSQLException(message, messageId, next, severity, t, args);
    }

    private SQLException wrapArgsForTransportAcrossDRDA(String message, String messageId, SQLException next, int severity, Throwable t, Object[] args) {
        SQLException e = super.getSQLException(message, messageId, next == null ? null : this.getArgumentFerry(next), severity, t, args);
        return e;
    }

    public static class EmbedSQLFeatureNotSupportedException
    extends SQLFeatureNotSupportedException
    implements DerbySQLException {
        private static final long serialVersionUID = 879447537063698632L;
        private Object[] arguments;
        private String messageId;
        private DistributedMember origin;

        public EmbedSQLFeatureNotSupportedException() {
        }

        EmbedSQLFeatureNotSupportedException(String message, String messageId, SQLException nextException, int severity, Throwable t, Object[] args) {
            super(message, StandardException.getSQLStateFromIdentifier(messageId), severity);
            this.messageId = messageId;
            if (args != null) {
                this.arguments = new Object[args.length];
                for (int index = 0; index < args.length; ++index) {
                    this.arguments[index] = args[index] != null ? args[index].toString() : null;
                }
            } else {
                this.arguments = null;
            }
            if (this.origin == null) {
                this.origin = StandardException.getSenderFromException(t);
                if (this.origin == null) {
                    this.origin = StandardException.getMyId();
                }
            }
            if (nextException != null) {
                this.setNextException(nextException);
            }
            if (t == null) {
                t = nextException;
            }
            if (t != null) {
                this.initCause(t);
            }
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isSimpleWrapper() {
            return false;
        }

        @Override
        public DistributedMember getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return "java.sql.SQLFeatureNotSupportedException(" + this.getSQLState() + "): " + this.getMessage();
        }
    }

    public static class EmbedSQLSyntaxErrorException
    extends SQLSyntaxErrorException
    implements DerbySQLException {
        private static final long serialVersionUID = 5978011241555870084L;
        private Object[] arguments;
        private String messageId;
        private DistributedMember origin;

        public EmbedSQLSyntaxErrorException() {
        }

        EmbedSQLSyntaxErrorException(String message, String messageId, SQLException nextException, int severity, Throwable t, Object[] args) {
            super(message, StandardException.getSQLStateFromIdentifier(messageId), severity);
            this.messageId = messageId;
            if (args != null) {
                this.arguments = new Object[args.length];
                for (int index = 0; index < args.length; ++index) {
                    this.arguments[index] = args[index] != null ? args[index].toString() : null;
                }
            } else {
                this.arguments = null;
            }
            if (this.origin == null) {
                this.origin = StandardException.getSenderFromException(t);
                if (this.origin == null) {
                    this.origin = StandardException.getMyId();
                }
            }
            if (nextException != null) {
                this.setNextException(nextException);
            }
            if (t == null) {
                t = nextException;
            }
            if (t != null) {
                this.initCause(t);
            }
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isSimpleWrapper() {
            return false;
        }

        @Override
        public DistributedMember getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return "java.sql.SQLSyntaxErrorException(" + this.getSQLState() + "): " + this.getMessage();
        }
    }

    public static class EmbedSQLTransactionRollbackException
    extends SQLTransactionRollbackException
    implements DerbySQLException {
        private static final long serialVersionUID = -1880056564903119733L;
        private Object[] arguments;
        private String messageId;
        private DistributedMember origin;

        public EmbedSQLTransactionRollbackException() {
        }

        EmbedSQLTransactionRollbackException(String message, String messageId, SQLException nextException, int severity, Throwable t, Object[] args) {
            super(message, StandardException.getSQLStateFromIdentifier(messageId), severity);
            this.messageId = messageId;
            if (args != null) {
                this.arguments = new Object[args.length];
                for (int index = 0; index < args.length; ++index) {
                    this.arguments[index] = args[index] != null ? args[index].toString() : null;
                }
            } else {
                this.arguments = null;
            }
            if (this.origin == null) {
                this.origin = StandardException.getSenderFromException(t);
                if (this.origin == null) {
                    this.origin = StandardException.getMyId();
                }
            }
            if (nextException != null) {
                this.setNextException(nextException);
            }
            if (t == null) {
                t = nextException;
            }
            if (t != null) {
                this.initCause(t);
            }
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isSimpleWrapper() {
            return false;
        }

        @Override
        public DistributedMember getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return "java.sql.SQLTransactionRollbackException(" + this.getSQLState() + "): " + this.getMessage();
        }
    }

    public static class EmbedSQLInvalidAuthorizationSpecException
    extends SQLInvalidAuthorizationSpecException
    implements DerbySQLException {
        private static final long serialVersionUID = 239272541885450068L;
        private Object[] arguments;
        private String messageId;
        private DistributedMember origin;

        public EmbedSQLInvalidAuthorizationSpecException() {
        }

        EmbedSQLInvalidAuthorizationSpecException(String message, String messageId, SQLException nextException, int severity, Throwable t, Object[] args) {
            super(message, StandardException.getSQLStateFromIdentifier(messageId), severity);
            this.messageId = messageId;
            if (args != null) {
                this.arguments = new Object[args.length];
                for (int index = 0; index < args.length; ++index) {
                    this.arguments[index] = args[index] != null ? args[index].toString() : null;
                }
            } else {
                this.arguments = null;
            }
            if (this.origin == null) {
                this.origin = StandardException.getSenderFromException(t);
                if (this.origin == null) {
                    this.origin = StandardException.getMyId();
                }
            }
            if (nextException != null) {
                this.setNextException(nextException);
            }
            if (t == null) {
                t = nextException;
            }
            if (t != null) {
                this.initCause(t);
            }
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isSimpleWrapper() {
            return false;
        }

        @Override
        public DistributedMember getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return "java.sql.SQLInvalidAuthorizationSpecException(" + this.getSQLState() + "): " + this.getMessage();
        }
    }

    public static class EmbedSQLIntegrityConstraintViolationException
    extends SQLIntegrityConstraintViolationException
    implements DerbySQLException {
        private static final long serialVersionUID = -6619591273592269731L;
        private Object[] arguments;
        private String messageId;
        private DistributedMember origin;

        public EmbedSQLIntegrityConstraintViolationException() {
        }

        EmbedSQLIntegrityConstraintViolationException(String message, String messageId, SQLException nextException, int severity, Throwable t, Object[] args) {
            super(message, StandardException.getSQLStateFromIdentifier(messageId), severity);
            this.messageId = messageId;
            if (args != null) {
                this.arguments = new Object[args.length];
                for (int index = 0; index < args.length; ++index) {
                    this.arguments[index] = args[index] != null ? args[index].toString() : null;
                }
            } else {
                this.arguments = null;
            }
            if (this.origin == null) {
                this.origin = StandardException.getSenderFromException(t);
                if (this.origin == null) {
                    this.origin = StandardException.getMyId();
                }
            }
            if (nextException != null) {
                this.setNextException(nextException);
            }
            if (t == null) {
                t = nextException;
            }
            if (t != null) {
                this.initCause(t);
            }
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isSimpleWrapper() {
            return false;
        }

        @Override
        public DistributedMember getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return "java.sql.SQLIntegrityConstraintViolationException(" + this.getSQLState() + "): " + this.getMessage();
        }
    }

    public static class EmbedSQLDataException
    extends SQLDataException
    implements DerbySQLException {
        private static final long serialVersionUID = 3824010447574121870L;
        private Object[] arguments;
        private String messageId;
        private DistributedMember origin;

        public EmbedSQLDataException() {
        }

        EmbedSQLDataException(String message, String messageId, SQLException nextException, int severity, Throwable t, Object[] args) {
            super(message, StandardException.getSQLStateFromIdentifier(messageId), severity);
            this.messageId = messageId;
            if (args != null) {
                this.arguments = new Object[args.length];
                for (int index = 0; index < args.length; ++index) {
                    this.arguments[index] = args[index] != null ? args[index].toString() : null;
                }
            } else {
                this.arguments = null;
            }
            if (this.origin == null) {
                this.origin = StandardException.getSenderFromException(t);
                if (this.origin == null) {
                    this.origin = StandardException.getMyId();
                }
            }
            if (nextException != null) {
                this.setNextException(nextException);
            }
            if (t == null) {
                t = nextException;
            }
            if (t != null) {
                this.initCause(t);
            }
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isSimpleWrapper() {
            return false;
        }

        @Override
        public DistributedMember getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return "java.sql.SQLDataException(" + this.getSQLState() + "): " + this.getMessage();
        }
    }

    public static class EmbedSQLNonTransientConnectionException
    extends SQLNonTransientConnectionException
    implements DerbySQLException {
        private static final long serialVersionUID = -8832940935707798936L;
        private Object[] arguments;
        private String messageId;
        private DistributedMember origin;

        public EmbedSQLNonTransientConnectionException() {
        }

        EmbedSQLNonTransientConnectionException(String message, String messageId, SQLException nextException, int severity, Throwable t, Object[] args) {
            super(message, StandardException.getSQLStateFromIdentifier(messageId), severity);
            this.messageId = messageId;
            if (args != null) {
                this.arguments = new Object[args.length];
                for (int index = 0; index < args.length; ++index) {
                    this.arguments[index] = args[index] != null ? args[index].toString() : null;
                }
            } else {
                this.arguments = null;
            }
            if (this.origin == null) {
                this.origin = StandardException.getSenderFromException(t);
                if (this.origin == null) {
                    this.origin = StandardException.getMyId();
                }
            }
            if (nextException != null) {
                this.setNextException(nextException);
            }
            if (t == null) {
                t = nextException;
            }
            if (t != null) {
                this.initCause(t);
            }
        }

        @Override
        public String getMessageId() {
            return this.messageId;
        }

        @Override
        public Object[] getArguments() {
            return this.arguments;
        }

        @Override
        public boolean isSimpleWrapper() {
            return false;
        }

        @Override
        public DistributedMember getOrigin() {
            return this.origin;
        }

        @Override
        public String toString() {
            return "java.sql.SQLNonTransientConnectionException(" + this.getSQLState() + "): " + this.getMessage();
        }
    }
}

