/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.db;

import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.jdbc.AuthenticationService;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.replication.slave.SlaveFactory;
import com.pivotal.gemfirexd.internal.impl.db.BasicDatabase;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class SlaveDatabase
extends BasicDatabase {
    private volatile boolean inReplicationSlaveMode;
    private volatile boolean shutdownInitiated;
    private volatile boolean inBoot;
    private volatile StandardException bootException;
    private String dbname;
    private volatile SlaveFactory slaveFac;

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        String repliMode;
        boolean supported = Monitor.isDesiredCreateType(startParams, this.getEngineType());
        if (supported && ((repliMode = startParams.getProperty("replication.slave.mode")) == null || !repliMode.equals("slavemode"))) {
            supported = false;
        }
        return supported;
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        this.inReplicationSlaveMode = true;
        this.inBoot = true;
        this.shutdownInitiated = false;
        this.dbname = startParams.getProperty("replication.slave.dbname");
        SlaveDatabaseBootThread dbBootThread = new SlaveDatabaseBootThread(create, startParams);
        Thread sdbThread = new Thread((Runnable)dbBootThread, "gemfirexd.slave.boot-" + this.dbname);
        sdbThread.setDaemon(true);
        sdbThread.start();
        this.verifySuccessfulBoot();
        this.inBoot = false;
        this.active = true;
    }

    @Override
    public void stop() {
        if (this.inReplicationSlaveMode && this.slaveFac != null) {
            try {
                this.slaveFac.stopSlave(true);
            }
            catch (StandardException standardException) {
            }
            finally {
                this.slaveFac = null;
            }
        }
        super.stop();
    }

    @Override
    public boolean isInSlaveMode() {
        return this.inReplicationSlaveMode;
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname) throws StandardException {
        if (this.inReplicationSlaveMode) {
            throw StandardException.newException("08004.C.7", dbname);
        }
        return super.setupConnection(cm, user, drdaID, dbname);
    }

    @Override
    public AuthenticationService getAuthenticationService() throws StandardException {
        if (this.inReplicationSlaveMode) {
            throw StandardException.newException("08004.C.7", this.dbname);
        }
        return super.getAuthenticationService();
    }

    public void verifyShutdownSlave() throws StandardException {
        if (!this.shutdownInitiated) {
            throw StandardException.newException("XRE43");
        }
        this.pushDbContext(ContextService.getFactory().getCurrentContextManager());
    }

    @Override
    public void stopReplicationSlave() throws SQLException {
        if (this.shutdownInitiated) {
            return;
        }
        if (!this.inReplicationSlaveMode) {
            StandardException se = StandardException.newException("XRE40");
            throw PublicAPI.wrapStandardException(se);
        }
        try {
            this.slaveFac.stopSlave(false);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
        this.slaveFac = null;
    }

    @Override
    public void failover(String dbname) throws StandardException {
        if (this.inReplicationSlaveMode) {
            this.slaveFac.failover();
            while (this.inReplicationSlaveMode) {
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            super.failover(dbname);
        }
    }

    private void verifySuccessfulBoot() throws StandardException {
        while (!this.isSlaveFactorySet() || !this.slaveFac.isStarted()) {
            if (this.bootException != null) {
                throw this.bootException;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private boolean isSlaveFactorySet() {
        if (this.slaveFac != null) {
            return true;
        }
        try {
            this.slaveFac = (SlaveFactory)Monitor.findServiceModule(this, "com.pivotal.gemfirexd.internal.iapi.store.replication.slave.SlaveFactory");
            return true;
        }
        catch (StandardException se) {
            return false;
        }
    }

    private void handleShutdown(StandardException shutdownCause) {
        if (this.inBoot) {
            this.bootException = shutdownCause;
            return;
        }
        try {
            this.shutdownInitiated = true;
            String driverName = "io.snappydata.jdbc.EmbeddedDriver";
            Class.forName(driverName).newInstance();
            Driver embedDriver = DriverManager.getDriver("jdbc:gemfirexd:");
            String conStr = "jdbc:gemfirexd:;internal_stopslave=true";
            embedDriver.connect(conStr, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void bootBasicDatabase(boolean create, Properties params) throws StandardException {
        super.boot(create, params);
    }

    @Override
    public void cleanupOnError(Throwable e) {
    }

    private class SlaveDatabaseBootThread
    implements Runnable {
        private boolean create;
        private Properties params;

        public SlaveDatabaseBootThread(boolean create, Properties startParams) {
            this.create = create;
            this.params = startParams;
        }

        @Override
        public void run() {
            ContextManager bootThreadCm = null;
            try {
                bootThreadCm = ContextService.getFactory().newContextManager();
                ContextService.getFactory().setCurrentContextManager(bootThreadCm);
                SlaveDatabase.this.bootBasicDatabase(this.create, this.params);
                SlaveDatabase.this.inReplicationSlaveMode = false;
                if (bootThreadCm != null) {
                    ContextService.getFactory().resetCurrentContextManager(bootThreadCm);
                    bootThreadCm = null;
                }
            }
            catch (StandardException se) {
                SlaveDatabase.this.handleShutdown(se);
            }
        }
    }
}

