/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.internal.cache.LocalRegion;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.shared.ClientSharedUtils;
import com.gemstone.gemfire.internal.shared.unsafe.UnsafeHolder;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.db.FabricDatabase;
import com.pivotal.gemfirexd.internal.engine.distributed.ByteArrayDataOutput;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapByteSource;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.LocaleFinder;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.DerbyIOException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.StreamStorable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.CollationElementsInterface;
import com.pivotal.gemfirexd.internal.iapi.types.CollatorSQLChar;
import com.pivotal.gemfirexd.internal.iapi.types.ConcatableDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.Like;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLDate;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTime;
import com.pivotal.gemfirexd.internal.iapi.types.SQLTimestamp;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.iapi.types.StringDataValue;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UTFDataFormatException;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.CollationKey;
import java.text.DateFormat;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Locale;
import sun.misc.Unsafe;

public class SQLChar
extends DataType
implements StringDataValue,
StreamStorable {
    protected static final int RETURN_SPACE_THRESHOLD = 4096;
    private static final int GROWBY_FOR_CHAR = 64;
    private static final int BASE_MEMORY_USAGE;
    private static final char[] BLANKS;
    private static final byte[] BLANKSB;
    protected String value;
    protected char[] rawData;
    protected int rawLength = -1;
    private CollationKey cKey;
    char[][] arg_passer = new char[1][];
    static final boolean[] IS_NORMAL_ASCII_CHAR;
    static final int[] IS_NON_ASCII_OR_SPECIAL_PXF_CHAR;

    public SQLChar() {
    }

    public SQLChar(String val) {
        this.value = val;
    }

    public final int getCharArray(char[] chars, int offset) throws StandardException {
        if (this.rawLength != -1) {
            System.arraycopy(this.rawData, 0, chars, offset, this.rawLength);
            return this.rawLength;
        }
        if (this.value != null) {
            int len = this.value.length();
            this.value.getChars(0, len, chars, offset);
            return len;
        }
        return 0;
    }

    public static void appendBlanks(char[] ca, int offset, int howMany) {
        while (howMany > 0) {
            int count = howMany > BLANKS.length ? BLANKS.length : howMany;
            System.arraycopy(BLANKS, 0, ca, offset, count);
            howMany -= count;
            offset += count;
        }
    }

    public static void appendBlanks(ByteArrayDataOutput buffer, int howMany) {
        while (howMany > 0) {
            int count = howMany > BLANKSB.length ? BLANKSB.length : howMany;
            buffer.write(BLANKSB, 0, count);
            howMany -= count;
        }
    }

    @Override
    public boolean getBoolean() throws StandardException {
        if (this.isNull()) {
            return false;
        }
        String cleanedValue = this.getString().trim();
        return !cleanedValue.equals("0") && !cleanedValue.equals("false");
    }

    @Override
    public byte getByte() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Byte.parseByte(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", (Object)"byte", (Object)null);
        }
    }

    @Override
    public short getShort() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Short.parseShort(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", (Object)"short", (Object)null);
        }
    }

    @Override
    public int getInt() throws StandardException {
        if (this.isNull()) {
            return 0;
        }
        try {
            return Integer.parseInt(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", (Object)("int (" + nfe.getMessage() + ")"), (Object)null);
        }
    }

    @Override
    public long getLong() throws StandardException {
        if (this.isNull()) {
            return 0L;
        }
        try {
            return Long.parseLong(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", (Object)"long", (Object)null);
        }
    }

    @Override
    public float getFloat() throws StandardException {
        if (this.isNull()) {
            return 0.0f;
        }
        try {
            return Float.parseFloat(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", (Object)"float", (Object)null);
        }
    }

    @Override
    public double getDouble() throws StandardException {
        if (this.isNull()) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.getString().trim());
        }
        catch (NumberFormatException nfe) {
            throw StandardException.newException("22018", (Object)"double", (Object)null);
        }
    }

    @Override
    public Date getDate(Calendar cal) throws StandardException {
        return SQLChar.getDate(cal, this.getString(), this.getLocaleFinder());
    }

    public static Date getDate(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLDate internalDate = new SQLDate(str, false, localeFinder);
        return internalDate.getDate(cal);
    }

    @Override
    public Time getTime(Calendar cal) throws StandardException {
        return SQLChar.getTime(cal, this.getString(), this.getLocaleFinder());
    }

    public static Time getTime(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLTime internalTime = new SQLTime(str, false, localeFinder, cal);
        return internalTime.getTime(cal);
    }

    @Override
    public Timestamp getTimestamp(Calendar cal) throws StandardException {
        return SQLChar.getTimestamp(cal, this.getString(), this.getLocaleFinder());
    }

    public static Timestamp getTimestamp(Calendar cal, String str, LocaleFinder localeFinder) throws StandardException {
        if (str == null) {
            return null;
        }
        SQLTimestamp internalTimestamp = new SQLTimestamp(str, false, localeFinder, cal);
        return internalTimestamp.getTimestamp(cal);
    }

    @Override
    public InputStream returnStream() {
        return null;
    }

    @Override
    public final void setStream(InputStream newStream) throws StandardException {
        try {
            if (!this.readFromStream(newStream)) {
                this.value = null;
                this.rawLength = -1;
                this.rawData = null;
                this.cKey = null;
            }
        }
        catch (IOException ioe) {
            this.throwStreamingIOException(ioe);
        }
    }

    @Override
    public void loadStream() throws StandardException {
        this.getString();
    }

    @Override
    public Object getObject() throws StandardException {
        return this.getString();
    }

    @Override
    public InputStream getStream() throws StandardException {
        return null;
    }

    @Override
    public int typeToBigDecimal() throws StandardException {
        return 1;
    }

    @Override
    public int getLength() throws StandardException {
        if (this.rawLength != -1) {
            return this.rawLength;
        }
        String tmpString = this.getString();
        if (tmpString == null) {
            return 0;
        }
        int clobLength = tmpString.length();
        return clobLength;
    }

    private void throwStreamingIOException(IOException ioe) throws StandardException {
        DerbyIOException dioe;
        if (ioe instanceof DerbyIOException && (dioe = (DerbyIOException)ioe).getSQLState() != null) {
            throw StandardException.newPreLocalizedException(dioe.getSQLState(), dioe, dioe.getLocalizedMessage());
        }
        throw StandardException.newException("XCL30.S", (Throwable)ioe, (Object)this.getTypeName());
    }

    @Override
    public String getTypeName() {
        return "CHAR";
    }

    @Override
    public String getString() throws StandardException {
        if (this.value != null) {
            return this.value;
        }
        if (this.rawLength != -1) {
            if (this.rawData != null) {
                this.value = ClientSharedUtils.newWrappedString((char[])this.rawData, (int)0, (int)this.rawLength);
                return this.value;
            }
            SanityManager.THROWASSERT((String)("rawData null with rawLength=" + this.rawLength));
        }
        return null;
    }

    @Override
    public char[] getCharArray() throws StandardException {
        return this.getCharArray(false);
    }

    public final char[] getCharArray(boolean noCopy) throws StandardException {
        if (this.rawLength != -1) {
            return this.rawData;
        }
        String v = this.value;
        if (v != null) {
            char[] internalChars;
            int vlen = v.length();
            if (noCopy && (internalChars = ResolverUtils.getInternalCharsOnly((String)v, (int)vlen)) != null) {
                return internalChars;
            }
            this.rawData = ResolverUtils.getChars((String)v, (int)vlen);
            this.rawLength = vlen;
            this.value = null;
            return this.rawData;
        }
        return null;
    }

    @Override
    public int getTypeFormatId() {
        return 78;
    }

    @Override
    public boolean isNull() {
        return this.value == null && this.rawLength == -1;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        boolean isNull = this.isNull();
        out.writeBoolean(isNull);
        if (isNull) {
            return;
        }
        this.writeData(out, true);
    }

    void writeData(DataOutput out, boolean createArray) throws IOException {
        char[] data;
        SanityManager.ASSERT((!this.isNull() ? 1 : 0) != 0);
        int strlen = this.rawLength;
        if (strlen < 0) {
            String v = this.value;
            if (v != null) {
                strlen = v.length();
                data = ResolverUtils.getInternalCharsOnly((String)v, (int)strlen);
                if (data == null) {
                    this.rawData = data = ResolverUtils.getChars((String)v, (int)strlen);
                    this.rawLength = strlen;
                    this.value = null;
                }
            } else {
                data = this.rawData;
                strlen = this.rawLength;
            }
        } else {
            data = this.rawData;
        }
        int utflen = strlen;
        for (int i = 0; i < strlen && utflen <= 65535; ++i) {
            char c = data[i];
            if (c >= '\u0001' && c <= '\u007f') continue;
            if (c > '\u07ff') {
                utflen += 2;
                continue;
            }
            ++utflen;
        }
        boolean isLongUTF = false;
        int byteArrayLen = utflen;
        if (utflen > 65535) {
            isLongUTF = true;
            utflen = 0;
            byteArrayLen += 3;
        }
        int index = 0;
        byte[] bytes = null;
        if (createArray) {
            bytes = new byte[byteArrayLen];
            out.writeShort(utflen);
        } else {
            out.writeShort(utflen);
        }
        for (int i = 0; i < strlen; ++i) {
            char c = data[i];
            if (c >= '\u0001' && c <= '\u007f') {
                if (createArray) {
                    bytes[index++] = (byte)(c & 0xFF);
                    continue;
                }
                out.writeByte((byte)(c & 0xFF));
                continue;
            }
            if (c > '\u07ff') {
                if (createArray) {
                    bytes[index++] = (byte)(0xE0 | c >> 12 & 0xF);
                    bytes[index++] = (byte)(0x80 | c >> 6 & 0x3F);
                    bytes[index++] = (byte)(0x80 | c >> 0 & 0x3F);
                    continue;
                }
                out.writeByte((byte)(0xE0 | c >> 12 & 0xF));
                out.writeByte((byte)(0x80 | c >> 6 & 0x3F));
                out.writeByte((byte)(0x80 | c >> 0 & 0x3F));
                continue;
            }
            if (createArray) {
                bytes[index++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytes[index++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            out.writeByte((byte)(0xC0 | c >> 6 & 0x1F));
            out.writeByte((byte)(0x80 | c >> 0 & 0x3F));
        }
        if (isLongUTF) {
            if (createArray) {
                bytes[index++] = -32;
                bytes[index++] = 0;
                bytes[index++] = 0;
            } else {
                out.writeByte(-32);
                out.writeByte(0);
                out.writeByte(0);
            }
        }
        if (createArray) {
            out.write(bytes);
        }
        if (!isLongUTF && strlen == 0) {
            out.writeByte(-1);
        }
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException {
        this.arg_passer[0] = this.rawData;
        this.rawLength = in.readDerbyUTF(this.arg_passer);
        this.rawData = this.arg_passer[0];
        this.value = null;
        this.cKey = null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        this.readExternal(in, true);
    }

    private void readExternal(ObjectInput in, boolean canBeNull) throws IOException {
        boolean isNull;
        if (canBeNull && (isNull = in.readBoolean())) {
            this.setToNull();
            return;
        }
        this.readData(in, false);
    }

    void readData(DataInput in, boolean reuseArrayIfPossible) throws IOException {
        int requiredLength;
        int utflen = in.readUnsignedShort();
        int minGrowBy = this.growBy();
        if (utflen != 0) {
            requiredLength = utflen;
        } else {
            requiredLength = 0;
            if (requiredLength < minGrowBy) {
                requiredLength = minGrowBy;
            }
        }
        char[] str = new char[requiredLength];
        int arrayLength = str.length;
        this.restoreToNull();
        int count = 0;
        int strlen = 0;
        while (count < utflen || utflen == 0) {
            int char2;
            char actualChar;
            int c;
            try {
                c = in.readUnsignedByte();
            }
            catch (EOFException eof) {
                if (utflen == 0) break;
                throw new EOFException();
            }
            if (c == 255) {
                if (utflen == 0) break;
                throw new EOFException();
            }
            if (strlen >= arrayLength) {
                int growby = 0;
                if (growby < minGrowBy) {
                    growby = minGrowBy;
                }
                int newstrlength = arrayLength + growby;
                char[] oldstr = str;
                str = new char[newstrlength];
                System.arraycopy(oldstr, 0, str, 0, arrayLength);
                arrayLength = newstrlength;
            }
            if ((c & 0x80) == 0) {
                ++count;
                actualChar = (char)c;
            } else if ((c & 0x60) == 64) {
                if (utflen != 0 && (count += 2) > utflen) {
                    throw new UTFDataFormatException();
                }
                char2 = in.readUnsignedByte();
                if ((char2 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                actualChar = (char)((c & 0x1F) << 6 | char2 & 0x3F);
            } else if ((c & 0x70) == 96) {
                if (utflen != 0 && (count += 3) > utflen) {
                    throw new UTFDataFormatException();
                }
                char2 = in.readUnsignedByte();
                int char3 = in.readUnsignedByte();
                if (c == 224 && char2 == 0 && char3 == 0 && utflen == 0) break;
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                actualChar = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
            } else {
                throw new UTFDataFormatException("char=" + c + " utflen=" + utflen + " count=" + count + " str=" + new String(str));
            }
            str[strlen++] = actualChar;
        }
        this.rawData = str;
        if (strlen < utflen) {
            char[] newCharArray = new char[strlen];
            System.arraycopy(str, 0, newCharArray, 0, strlen);
            this.rawData = newCharArray;
        }
        this.rawLength = strlen;
        this.value = null;
        this.cKey = null;
    }

    protected int growBy() {
        return 64;
    }

    @Override
    public void restoreToNull() {
        this.value = null;
        this.rawLength = -1;
        this.cKey = null;
        this.rawData = null;
    }

    @Override
    public boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls && (this.isNull() || other.isNull())) {
            return unknownRV;
        }
        if (!(other instanceof SQLChar)) {
            return other.compare(SQLChar.flip(op), this, orderedNulls, unknownRV);
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    @Override
    public int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -Integer.signum(other.compare(this));
        }
        return this.stringCompare(this, (SQLChar)other);
    }

    @Override
    public Object cloneObject() {
        return this.getClone();
    }

    @Override
    public DataValueDescriptor getClone() {
        try {
            return new SQLChar(this.getString());
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception", se);
        }
    }

    @Override
    public DataValueDescriptor getNewNull() {
        return new SQLChar();
    }

    @Override
    public StringDataValue getValue(RuleBasedCollator collatorForComparison) {
        if (collatorForComparison == null) {
            return this;
        }
        CollatorSQLChar s = new CollatorSQLChar(collatorForComparison);
        s.copyState(this);
        return s;
    }

    @Override
    public final void setValueFromResultSet(ResultSet resultSet, int colNumber, boolean isNullable) throws SQLException, StandardException {
        this.setValue(resultSet.getString(colNumber));
    }

    @Override
    public final void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setString(position, this.getString());
    }

    @Override
    public void setValue(String theValue) throws StandardException {
        this.rawLength = -1;
        this.cKey = null;
        this.value = theValue;
        this.rawData = null;
    }

    @Override
    public void setValue(boolean theValue) throws StandardException {
        this.setValue(theValue ? "1" : "0");
    }

    @Override
    public void setValue(int theValue) throws StandardException {
        this.setValue(Integer.toString(theValue));
    }

    @Override
    public void setValue(double theValue) throws StandardException {
        this.setValue(Double.toString(theValue));
    }

    @Override
    public void setValue(float theValue) throws StandardException {
        this.setValue(Float.toString(theValue));
    }

    @Override
    public void setValue(short theValue) throws StandardException {
        this.setValue(Short.toString(theValue));
    }

    @Override
    public void setValue(long theValue) throws StandardException {
        this.setValue(Long.toString(theValue));
    }

    @Override
    public void setValue(byte theValue) throws StandardException {
        this.setValue(Byte.toString(theValue));
    }

    @Override
    public void setValue(byte[] theValue) throws StandardException {
        if (theValue == null) {
            this.restoreToNull();
            return;
        }
        int mod = theValue.length % 2;
        int len = theValue.length / 2 + mod;
        char[] carray = new char[len];
        int cindex = 0;
        int bindex = 0;
        if (mod == 1) {
            carray[--len] = (char)(theValue[theValue.length - 1] << 8);
        }
        while (cindex < len) {
            carray[cindex] = (char)(theValue[bindex] << 8 | theValue[bindex + 1] & 0xFF);
            bindex += 2;
            ++cindex;
        }
        this.setValue(new String(carray));
    }

    @Override
    public void setBigDecimal(Number bigDecimal) throws StandardException {
        if (bigDecimal == null) {
            this.setToNull();
        } else {
            this.setValue(bigDecimal.toString());
        }
    }

    @Override
    public void setValue(Date theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuilder sb = new StringBuilder();
                this.formatJDBCDate(cal, sb);
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    @Override
    public void setValue(Time theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuilder sb = new StringBuilder();
                this.formatJDBCTime(cal, sb);
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    @Override
    public void setValue(Timestamp theValue, Calendar cal) throws StandardException {
        String strValue = null;
        if (theValue != null) {
            if (cal == null) {
                strValue = theValue.toString();
            } else {
                cal.setTime(theValue);
                StringBuilder sb = new StringBuilder();
                this.formatJDBCDate(cal, sb);
                sb.append(' ');
                this.formatJDBCTime(cal, sb);
                int micros = (theValue.getNanos() + 500) / 1000;
                if (micros > 0) {
                    sb.append('.');
                    String microsStr = Integer.toString(micros);
                    if (microsStr.length() > 6) {
                        sb.append(microsStr.substring(0, 6));
                    } else {
                        for (int i = microsStr.length(); i < 6; ++i) {
                            sb.append('0');
                        }
                        sb.append(microsStr);
                    }
                }
                strValue = sb.toString();
            }
        }
        this.setValue(strValue);
    }

    private void formatJDBCDate(Calendar cal, StringBuilder sb) {
        SQLDate.dateToString(cal.get(1), cal.get(2) - 0 + 1, cal.get(5), sb);
    }

    private void formatJDBCTime(Calendar cal, StringBuilder sb) {
        SQLTime.timeToString(cal.get(10), cal.get(12), cal.get(13), sb);
    }

    @Override
    public final void setValue(InputStream theStream, int valueLength) throws StandardException {
        this.setStream(theStream);
    }

    @Override
    public void setObjectForCast(Object theValue, boolean instanceOfResultType, String resultTypeClassName) throws StandardException {
        if (theValue == null) {
            this.setToNull();
            return;
        }
        if (resultTypeClassName != null) {
            if ("java.lang.String".equals(resultTypeClassName)) {
                this.setValue(theValue.toString());
                return;
            }
        } else if (String.class.equals(theValue.getClass())) {
            this.setValue((String)theValue);
            return;
        }
        super.setObjectForCast(theValue, instanceOfResultType, resultTypeClassName);
    }

    @Override
    protected void setFrom(DataValueDescriptor theValue) throws StandardException {
        switch (theValue.getTypeFormatId()) {
            case 78: 
            case 85: 
            case 235: {
                this.copyFieldsByReference((SQLChar)theValue);
            }
        }
        this.setValue(theValue.getString());
    }

    private void copyFieldsByReference(SQLChar theValue) throws StandardException {
        this.rawData = theValue.rawData;
        this.rawLength = theValue.rawLength;
        this.cKey = theValue.cKey;
        this.value = theValue.value;
    }

    @Override
    public void normalize(DataTypeDescriptor desiredType, DataValueDescriptor source) throws StandardException {
        this.normalize(desiredType, source.getString());
    }

    protected void normalize(DataTypeDescriptor desiredType, String sourceValue) throws StandardException {
        int desiredWidth = desiredType.getMaximumWidth();
        int sourceWidth = sourceValue.length();
        if (sourceWidth == desiredWidth) {
            this.setValue(sourceValue);
            return;
        }
        if (sourceWidth < desiredWidth) {
            this.setToNull();
            this.rawData = new char[desiredWidth];
            char[] ca = this.rawData;
            sourceValue.getChars(0, sourceWidth, ca, 0);
            SQLChar.appendBlanks(ca, sourceWidth, desiredWidth - sourceWidth);
            this.rawLength = desiredWidth;
            return;
        }
        this.hasNonBlankChars(sourceValue, desiredWidth, sourceWidth);
        String truncatedString = sourceValue.substring(0, desiredWidth);
        this.setValue(truncatedString);
    }

    protected final void hasNonBlankChars(String source, int start, int end) throws StandardException {
        for (int posn = start; posn < end; ++posn) {
            if (source.charAt(posn) == ' ') continue;
            throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)StringUtil.formatForPrint(source), (Object)String.valueOf(start));
        }
    }

    @Override
    public void setWidth(int desiredWidth, int desiredScale, boolean errorOnTrunc) throws StandardException {
        if (this.getString() == null) {
            return;
        }
        int sourceWidth = this.getLength();
        if (sourceWidth < desiredWidth) {
            if (!(this instanceof SQLVarchar)) {
                StringBuilder strbuf = new StringBuilder(this.getString());
                while (sourceWidth < desiredWidth) {
                    strbuf.append(' ');
                    ++sourceWidth;
                }
                this.setValue(new String(strbuf));
            }
        } else if (sourceWidth > desiredWidth && desiredWidth > 0) {
            if (errorOnTrunc) {
                this.hasNonBlankChars(this.getString(), desiredWidth, sourceWidth);
            }
            this.setValue(this.getString().substring(0, desiredWidth));
        }
    }

    @Override
    public BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) == 0 : SQLChar.stringCompare(left.getString(), right.getString()) == 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) != 0 : SQLChar.stringCompare(left.getString(), right.getString()) != 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) < 0 : SQLChar.stringCompare(left.getString(), right.getString()) < 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) > 0 : SQLChar.stringCompare(left.getString(), right.getString()) > 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) <= 0 : SQLChar.stringCompare(left.getString(), right.getString()) <= 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean comparison = left instanceof SQLChar && right instanceof SQLChar ? this.stringCompare((SQLChar)left, (SQLChar)right) >= 0 : SQLChar.stringCompare(left.getString(), right.getString()) >= 0;
        return SQLBoolean.truthValue(left, right, comparison);
    }

    @Override
    public NumberDataValue charLength(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        result.setValue(this.getLength());
        return result;
    }

    @Override
    public StringDataValue concatenate(StringDataValue leftOperand, StringDataValue rightOperand, StringDataValue result) throws StandardException {
        if (leftOperand.isNull() || leftOperand.getString() == null || rightOperand.isNull() || rightOperand.getString() == null) {
            result.setToNull();
            return result;
        }
        result.setValue(leftOperand.getString().concat(rightOperand.getString()));
        return result;
    }

    @Override
    public BooleanDataValue like(DataValueDescriptor pattern) throws StandardException {
        char[] evalCharArray = this.getCharArray(true);
        char[] patternCharArray = ((SQLChar)pattern).getCharArray(true);
        Boolean likeResult = Like.like(evalCharArray, this.getLength(), patternCharArray, pattern.getLength(), null);
        return SQLBoolean.truthValue((DataValueDescriptor)this, pattern, likeResult);
    }

    @Override
    public BooleanDataValue like(DataValueDescriptor pattern, DataValueDescriptor escape) throws StandardException {
        SanityManager.ASSERT((pattern instanceof StringDataValue && escape instanceof StringDataValue ? 1 : 0) != 0, (String)"All three operands must be instances of StringDataValue");
        if (escape.isNull()) {
            throw StandardException.newException("22501");
        }
        char[] evalCharArray = this.getCharArray(true);
        char[] patternCharArray = ((SQLChar)pattern).getCharArray(true);
        char[] escapeCharArray = ((SQLChar)escape).getCharArray(true);
        int escapeLength = escape.getLength();
        if (escapeCharArray != null && escapeLength != 1) {
            throw StandardException.newException("22019", new String(escapeCharArray));
        }
        Boolean likeResult = Like.like(evalCharArray, this.getLength(), patternCharArray, pattern.getLength(), escapeCharArray, escapeLength, null);
        return SQLBoolean.truthValue((DataValueDescriptor)this, pattern, likeResult);
    }

    @Override
    public NumberDataValue locate(StringDataValue searchFrom, NumberDataValue start, NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        int startVal = start.isNull() ? 1 : start.getInt();
        if (this.isNull() || searchFrom.isNull()) {
            result.setToNull();
            return result;
        }
        String mySearchFrom = searchFrom.getString();
        String mySearchFor = this.getString();
        if (startVal < 1) {
            throw StandardException.newException("22014", (Object)new String(this.getString()), (Object)new String(mySearchFrom), (Object)new Integer(startVal));
        }
        if (mySearchFor.length() == 0) {
            result.setValue(startVal);
            return result;
        }
        result.setValue(mySearchFrom.indexOf(mySearchFor, startVal - 1) + 1);
        return result;
    }

    @Override
    public ConcatableDataValue substring(NumberDataValue start, NumberDataValue length, ConcatableDataValue result, int maxLen) throws StandardException {
        if (result == null) {
            result = this.getNewVarchar();
        }
        StringDataValue stringResult = (StringDataValue)result;
        if (this.isNull() || start.isNull() || length != null && length.isNull()) {
            stringResult.setToNull();
            return stringResult;
        }
        int startInt = start.getInt();
        int lengthInt = length != null ? length.getInt() : maxLen - startInt + 1;
        if (startInt <= 0 || lengthInt < 0 || startInt > maxLen || lengthInt > maxLen - startInt + 1) {
            throw StandardException.newException("22011");
        }
        if (lengthInt < 0) {
            stringResult.setToNull();
            return stringResult;
        }
        if (startInt < 0) {
            if (startInt + this.getLength() < 0 && startInt + this.getLength() + lengthInt <= 0) {
                stringResult.setValue("");
                return stringResult;
            }
            startInt += this.getLength();
            while (startInt < 0) {
                ++startInt;
                --lengthInt;
            }
        } else if (startInt > 0) {
            --startInt;
        }
        if (lengthInt == 0 || lengthInt <= 0 - startInt || startInt > this.getLength()) {
            stringResult.setValue("");
            return stringResult;
        }
        if (lengthInt >= this.getLength() - startInt) {
            stringResult.setValue(this.getString().substring(startInt));
        } else {
            stringResult.setValue(this.getString().substring(startInt, startInt + lengthInt));
        }
        return stringResult;
    }

    private String trimInternal(int trimType, char trimChar, String source) {
        int end;
        int start;
        if (source == null) {
            return null;
        }
        int len = source.length();
        if (trimType == 2 || trimType == 0) {
            for (start = 0; start < len && trimChar == source.charAt(start); ++start) {
            }
        }
        if (start == len) {
            return "";
        }
        if (trimType == 1 || trimType == 0) {
            for (end = len - 1; end >= 0 && trimChar == source.charAt(end); --end) {
            }
        }
        if (end == -1) {
            return "";
        }
        return source.substring(start, end + 1);
    }

    @Override
    public StringDataValue ansiTrim(int trimType, StringDataValue trimChar, StringDataValue result) throws StandardException {
        if (result == null) {
            result = this.getNewVarchar();
        }
        if (trimChar == null || trimChar.getString() == null) {
            result.setToNull();
            return result;
        }
        if (trimChar.getString().length() != 1) {
            throw StandardException.newException("22020", trimChar.getString());
        }
        char trimCharacter = trimChar.getString().charAt(0);
        result.setValue(this.trimInternal(trimType, trimCharacter, this.getString()));
        return result;
    }

    @Override
    public StringDataValue upper(StringDataValue result) throws StandardException {
        if (result == null) {
            result = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        String upper = this.getString();
        upper = upper.toUpperCase(this.getLocale());
        result.setValue(upper);
        return result;
    }

    @Override
    public StringDataValue lower(StringDataValue result) throws StandardException {
        if (result == null) {
            result = (StringDataValue)this.getNewNull();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        String lower = this.getString();
        lower = lower.toLowerCase(this.getLocale());
        result.setValue(lower);
        return result;
    }

    @Override
    public int typePrecedence() {
        return 0;
    }

    public static int stringCompare(String op1, String op2) {
        int remainingLen;
        String remainingString;
        int retvalIfLTSpace;
        int posn;
        int rightlen;
        int leftlen = op1.length();
        int shorterLen = leftlen < (rightlen = op2.length()) ? leftlen : rightlen;
        for (posn = 0; posn < shorterLen; ++posn) {
            char rightchar;
            char leftchar = op1.charAt(posn);
            if (leftchar == (rightchar = op2.charAt(posn))) continue;
            if (leftchar < rightchar) {
                return -1;
            }
            return 1;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (leftlen > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = op1;
            posn = rightlen;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = op2;
            posn = leftlen;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            char remainingChar = remainingString.charAt(posn);
            if (remainingChar < ' ') {
                return retvalIfLTSpace;
            }
            if (remainingChar > ' ') {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    protected final int stringCompareIgnoreCase(SQLChar char1, SQLChar char2) throws StandardException {
        if (!(char1 instanceof CollationElementsInterface)) {
            return SQLChar.stringCompareIgnoreCase(char1.getCharArray(true), char1.getLength(), char2.getCharArray(true), char2.getLength());
        }
        return this.stringCompare(char1, char2);
    }

    public final int compareIgnoreCase(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -Integer.signum(other.compare(this));
        }
        SQLChar otherChar = (SQLChar)other;
        if (!(this instanceof CollationElementsInterface)) {
            return SQLChar.stringCompareIgnoreCase(this.getCharArray(true), this.getLength(), otherChar.getCharArray(true), otherChar.getLength());
        }
        return this.stringCompare(this, otherChar);
    }

    public static int stringCompareIgnoreCase(String op1, String op2) {
        int remainingLen;
        String remainingString;
        int retvalIfLTSpace;
        int posn;
        int rightlen;
        if (op1 == null || op2 == null) {
            if (op1 != null) {
                return -1;
            }
            if (op2 != null) {
                return 1;
            }
            return 0;
        }
        int leftlen = op1.length();
        int shorterLen = leftlen < (rightlen = op2.length()) ? leftlen : rightlen;
        for (posn = 0; posn < shorterLen; ++posn) {
            char rightchar;
            char leftchar = op1.charAt(posn);
            int res = leftchar - (rightchar = op2.charAt(posn));
            if (res == 0 || (res = Character.toUpperCase((int)leftchar) - Character.toUpperCase((int)rightchar)) == 0) continue;
            return res;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (leftlen > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = op1;
            posn = rightlen;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = op2;
            posn = leftlen;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            char remainingChar = Character.toUpperCase(remainingString.charAt(posn));
            if (remainingChar < ' ') {
                return retvalIfLTSpace;
            }
            if (remainingChar > ' ') {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    protected static int stringCompareIgnoreCase(char[] op1, int leftlen, char[] op2, int rightlen) {
        int remainingLen;
        char[] remainingString;
        int retvalIfLTSpace;
        int posn;
        if (op1 == null || op2 == null) {
            if (op1 != null) {
                return -1;
            }
            if (op2 != null) {
                return 1;
            }
            return 0;
        }
        int shorterLen = leftlen < rightlen ? leftlen : rightlen;
        for (posn = 0; posn < shorterLen; ++posn) {
            char leftchar = op1[posn];
            char rightchar = op2[posn];
            int res = leftchar - rightchar;
            if (res == 0 || (res = Character.toUpperCase((int)leftchar) - Character.toUpperCase((int)rightchar)) == 0) continue;
            return res;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (leftlen > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = op1;
            posn = rightlen;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = op2;
            posn = leftlen;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            char remainingChar = Character.toUpperCase(remainingString[posn]);
            if (remainingChar < ' ') {
                return retvalIfLTSpace;
            }
            if (remainingChar > ' ') {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    protected int stringCompare(SQLChar char1, SQLChar char2) throws StandardException {
        return SQLChar.stringCompare(char1.getCharArray(true), char1.getLength(), char2.getCharArray(true), char2.getLength());
    }

    protected static int stringCompare(char[] op1, int leftlen, char[] op2, int rightlen) {
        int remainingLen;
        char[] remainingString;
        int retvalIfLTSpace;
        int posn;
        if (op1 == null || op2 == null) {
            if (op1 != null) {
                return -1;
            }
            if (op2 != null) {
                return 1;
            }
            return 0;
        }
        int shorterLen = leftlen < rightlen ? leftlen : rightlen;
        for (posn = 0; posn < shorterLen; ++posn) {
            char leftchar = op1[posn];
            char rightchar = op2[posn];
            if (leftchar == rightchar) continue;
            if (leftchar < rightchar) {
                return -1;
            }
            return 1;
        }
        if (leftlen == rightlen) {
            return 0;
        }
        if (leftlen > rightlen) {
            retvalIfLTSpace = -1;
            remainingString = op1;
            posn = rightlen;
            remainingLen = leftlen;
        } else {
            retvalIfLTSpace = 1;
            remainingString = op2;
            posn = leftlen;
            remainingLen = rightlen;
        }
        while (posn < remainingLen) {
            char remainingChar = remainingString[posn];
            if (remainingChar < ' ') {
                return retvalIfLTSpace;
            }
            if (remainingChar > ' ') {
                return -retvalIfLTSpace;
            }
            ++posn;
        }
        return 0;
    }

    protected CollationKey getCollationKey() throws StandardException {
        int lastNonspaceChar;
        char[] tmpCharArray;
        if (this.cKey != null) {
            return this.cKey;
        }
        if (this.rawLength == -1 && (tmpCharArray = this.getCharArray()) == null) {
            return null;
        }
        for (lastNonspaceChar = this.rawLength; lastNonspaceChar > 0 && this.rawData[lastNonspaceChar - 1] == ' '; --lastNonspaceChar) {
        }
        RuleBasedCollator rbc = this.getCollatorForCollation();
        this.cKey = rbc.getCollationKey(new String(this.rawData, 0, lastNonspaceChar));
        return this.cKey;
    }

    public String toString() {
        if (this.value != null) {
            return this.value;
        }
        if (this.rawLength != -1) {
            return ClientSharedUtils.newWrappedString((char[])this.rawData, (int)0, (int)this.rawLength);
        }
        return "NULL";
    }

    public int hashCode() {
        try {
            char[] data = this.getCharArray(true);
            if (data != null) {
                int len;
                int n = len = this.rawLength != -1 ? this.rawLength : data.length;
                if (len > 0) {
                    return ResolverUtils.getHashCodeOfCharArrayData((char[])data, (String)this.value, (int)len);
                }
            }
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception", se);
        }
        return 0;
    }

    protected StringDataValue getNewVarchar() throws StandardException {
        return new SQLVarchar();
    }

    private Locale getLocale() throws StandardException {
        return this.getLocaleFinder().getCurrentLocale();
    }

    protected RuleBasedCollator getCollatorForCollation() throws StandardException {
        SanityManager.THROWASSERT((String)"No support for collators in base class");
        return null;
    }

    protected final FabricDatabase getLocaleFinder() {
        return Misc.getMemStore().getDatabase();
    }

    protected DateFormat getDateFormat() throws StandardException {
        return this.getLocaleFinder().getDateFormat();
    }

    protected DateFormat getTimeFormat() throws StandardException {
        return this.getLocaleFinder().getTimeFormat();
    }

    protected DateFormat getTimestampFormat() throws StandardException {
        return this.getLocaleFinder().getTimestampFormat();
    }

    protected DateFormat getDateFormat(Calendar cal) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getDateFormat(), cal);
    }

    protected DateFormat getTimeFormat(Calendar cal) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getTimeFormat(), cal);
    }

    protected DateFormat getTimestampFormat(Calendar cal) throws StandardException {
        return this.setDateFormatCalendar(this.getLocaleFinder().getTimestampFormat(), cal);
    }

    private DateFormat setDateFormatCalendar(DateFormat df, Calendar cal) {
        if (cal != null && df.getTimeZone() != cal.getTimeZone()) {
            df = (DateFormat)df.clone();
            df.setCalendar(cal);
        }
        return df;
    }

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE + ClassSize.estimateMemoryUsage(this.value);
        if (this.value == null && this.rawData != null) {
            sz += 2 * this.rawData.length;
        }
        return sz;
    }

    protected void copyState(SQLChar other) {
        this.value = other.value;
        this.rawData = other.rawData;
        this.rawLength = other.rawLength;
        this.cKey = other.cKey;
    }

    @Override
    public String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        return this.toString();
    }

    protected final boolean readFromStream(InputStream stream) throws IOException {
        if (stream != null) {
            if (stream instanceof FormatIdInputStream) {
                this.readExternal((FormatIdInputStream)stream, false);
            } else {
                this.readExternal(new FormatIdInputStream(stream), false);
            }
            return true;
        }
        return false;
    }

    @Override
    public void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            out.writeByte(this.getTypeId());
            this.writeData(out, true);
            return;
        }
        this.writeNullDVD(out);
    }

    @Override
    public void fromData(DataInput in) throws IOException, ClassNotFoundException {
        this.readData(in, false);
    }

    @Override
    public void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        assert (!this.isNull());
        this.writeData(dos, false);
    }

    @Override
    public void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.readData(dis, true);
    }

    @Override
    public int getLengthInBytes(DataTypeDescriptor dtd) throws StandardException {
        char[] data = this.getCharArray(true);
        if (data != null) {
            int strlen;
            int utflen = strlen = this.rawLength != -1 ? this.rawLength : data.length;
            for (int index = 0; index < strlen && utflen <= 65535; ++index) {
                char c = data[index];
                if (c >= '\u0001' && c <= '\u007f') continue;
                if (c > '\u07ff') {
                    utflen += 2;
                    continue;
                }
                ++utflen;
            }
            return utflen;
        }
        return 0;
    }

    @Override
    public int writeBytes(byte[] bytes, int offset, DataTypeDescriptor dtd) {
        char[] data;
        assert (!this.isNull());
        try {
            data = this.getCharArray(true);
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception", se);
        }
        int strlen = this.rawLength != -1 ? this.rawLength : data.length;
        int index = offset;
        for (int i = 0; i < strlen; ++i) {
            char c = data[i];
            if (c >= '\u0001' && c <= '\u007f') {
                bytes[index++] = (byte)(c & 0xFF);
                continue;
            }
            if (c > '\u07ff') {
                bytes[index++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytes[index++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytes[index++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            bytes[index++] = (byte)(0xC0 | c >> 6 & 0x1F);
            bytes[index++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return index - offset;
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        char[] chars = new char[columnWidth];
        int strlen = SQLChar.readIntoCharsFromByteArray(inBytes, offset, columnWidth, chars);
        if (columnWidth >= strlen >>> 1) {
            this.rawData = new char[strlen];
            System.arraycopy(chars, 0, this.rawData, 0, strlen);
        } else {
            this.rawData = chars;
        }
        this.rawLength = strlen;
        this.value = null;
        return columnWidth;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        char[] chars = new char[columnWidth];
        int strlen = SQLChar.readIntoCharsFromByteSource(UnsafeHolder.getUnsafe(), memOffset, columnWidth, bs, chars);
        if (columnWidth >= strlen >>> 1) {
            this.rawData = new char[strlen];
            System.arraycopy(chars, 0, this.rawData, 0, strlen);
        } else {
            this.rawData = chars;
        }
        this.rawLength = strlen;
        this.value = null;
        return columnWidth;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        int strlen;
        char[] data;
        assert (!this.isNull());
        try {
            data = this.getCharArray(true);
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception", se);
        }
        int n = strlen = this.rawLength != -1 ? this.rawLength : data.length;
        if (maxWidth > 0 && strlen > maxWidth) {
            strlen = maxWidth;
        }
        int typeId = this.getTypeFormatId();
        hash = ResolverUtils.getComputeHashOfCharArrayData((int)hash, (int)strlen, (char[])data, (int)typeId);
        for (int i = strlen; i < maxWidth; ++i) {
            hash = ResolverUtils.addByteToBucketHash((byte)32, (int)hash, (int)typeId);
        }
        return hash;
    }

    @Override
    public void setRegionContext(LocalRegion region) {
        try {
            char[] data = this.getCharArray(false);
            if (this.rawLength != -1 && this.value == null) {
                this.value = ClientSharedUtils.newWrappedString((char[])data, (int)0, (int)this.rawLength);
            }
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("unexpected exception", se);
        }
    }

    @Override
    public boolean canCompareBytesToBytes() {
        return true;
    }

    public static final int readIntoCharsFromByteSource(Unsafe unsafe, long memOffset, int utflen, ByteSource inBytes, char[] chars) {
        byte c;
        if (utflen == 0) {
            return 0;
        }
        int count = 0;
        int strlen = 0;
        long endAddr = memOffset + (long)utflen;
        while (count < utflen && ((c = unsafe.getByte(memOffset++)) & 0xFF) != 255) {
            byte char2;
            char actualChar;
            if ((c & 0x80) == 0) {
                ++count;
                actualChar = (char)c;
            } else if ((c & 0x60) == 64) {
                if ((count += 2) > utflen) {
                    throw new GemFireXDRuntimeException("UTFDataFormatException. ByteSource = " + inBytes);
                }
                if (((char2 = unsafe.getByte(memOffset++)) & 0xC0) != 128) {
                    throw new GemFireXDRuntimeException("UTFDataFormatException. ByteSource = " + inBytes);
                }
                actualChar = (char)((c & 0x1F) << 6 | char2 & 0x3F);
            } else if ((c & 0x70) == 96) {
                if ((count += 3) > utflen) {
                    throw new GemFireXDRuntimeException("UTFDataFormatException. ByteSource = " + inBytes);
                }
                char2 = unsafe.getByte(memOffset++);
                byte char3 = unsafe.getByte(memOffset++);
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new GemFireXDRuntimeException("UTFDataFormatException. ByteSource = " + inBytes);
                }
                actualChar = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
            } else {
                throw new GemFireXDRuntimeException("UTFDataFormatException. ByteSource = " + inBytes);
            }
            chars[strlen++] = actualChar;
        }
        assert (memOffset == endAddr) : "did not read " + (endAddr - memOffset) + " bytes";
        return strlen;
    }

    public static int readIntoCharsFromByteArray(byte[] inBytes, int offset, int utflen, char[] chars) {
        byte c;
        int count = 0;
        int strlen = 0;
        int bi = offset;
        while (count < utflen && ((c = inBytes[bi++]) & 0xFF) != 255) {
            byte char2;
            char actualChar;
            if ((c & 0x80) == 0) {
                ++count;
                actualChar = (char)c;
            } else if ((c & 0x60) == 64) {
                if ((count += 2) > utflen) {
                    throw new GemFireXDRuntimeException("UTFDataFormatException");
                }
                if (((char2 = inBytes[bi++]) & 0xC0) != 128) {
                    throw new GemFireXDRuntimeException("UTFDataFormatException");
                }
                actualChar = (char)((c & 0x1F) << 6 | char2 & 0x3F);
            } else if ((c & 0x70) == 96) {
                if ((count += 3) > utflen) {
                    throw new GemFireXDRuntimeException("UTFDataFormatException");
                }
                char2 = inBytes[bi++];
                byte char3 = inBytes[bi++];
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new GemFireXDRuntimeException("UTFDataFormatException");
                }
                actualChar = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
            } else {
                throw new GemFireXDRuntimeException("UTFDataFormatException");
            }
            chars[strlen++] = actualChar;
        }
        assert (bi - offset == utflen) : "read=" + (bi - offset) + ", expected=" + utflen;
        return strlen;
    }

    public static final int readIntoCharsForTesting(Object inBytes, int offset, int utflen, char[] chars) {
        if (inBytes == null || inBytes.getClass() == byte[].class) {
            return SQLChar.readIntoCharsFromByteArray((byte[])inBytes, offset, utflen, chars);
        }
        OffHeapByteSource bs = (OffHeapByteSource)((Object)inBytes);
        return SQLChar.readIntoCharsFromByteSource(UnsafeHolder.getUnsafe(), bs.getUnsafeAddress(offset, utflen), utflen, bs, chars);
    }

    public static final int compareStringIgnoreCase(byte[] lhs, int lhsOffset, int lhsColumnWidth, byte[] rhs, int rhsOffset, int rhsColumnWidth) {
        int remainingLen;
        int shorterLen = lhsColumnWidth < rhsColumnWidth ? lhsColumnWidth : rhsColumnWidth;
        int lhsEnd = shorterLen + lhsOffset;
        int rhsEnd = shorterLen + rhsOffset;
        int ltposn = lhsOffset;
        int rtposn = rhsOffset;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            byte l2b;
            int lc;
            byte lb = lhs[ltposn];
            byte rb = rhs[rtposn];
            if ((lb & 0x80) == 0) {
                if ((rb & 0x80) == 0) {
                    int rc;
                    int res = lb - rb;
                    if (res != 0 && (res = (lc = Character.toUpperCase(lb)) - (rc = Character.toUpperCase(rb))) != 0) {
                        return res;
                    }
                    ++ltposn;
                    ++rtposn;
                    continue;
                }
                return -1;
            }
            if ((lb & 0x60) == 64) {
                byte r2b;
                int rc;
                int res;
                if ((rb & 0x80) == 0) {
                    byte byeet = lhs[++ltposn];
                    lc = (lb & 0x1F) << 6 | byeet & 0x3F;
                    int res2 = Character.toUpperCase(lc) - Character.toUpperCase(rb);
                    assert (res2 != 0) : "leftChar=" + Character.toString((char)lc) + ", rightChar=" + Character.toString((char)rb);
                    return res2;
                }
                if ((rb & 0x70) == 96) {
                    return -1;
                }
                if ((res = (lc = (lb & 0x1F) << 6 | (l2b = lhs[++ltposn]) & 0x3F) - (rc = (rb & 0x1F) << 6 | (r2b = rhs[++rtposn]) & 0x3F)) != 0 && (res = Character.toUpperCase(lc) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((lb & 0x70) == 96) {
                byte r3b;
                int rc;
                int res;
                if ((rb & 0x80) == 0) {
                    return 1;
                }
                if ((rb & 0x60) == 64) {
                    return 1;
                }
                l2b = lhs[++ltposn];
                byte l3b = lhs[++ltposn];
                int lc2 = (lb & 0xF) << 12 | (l2b & 0x3F) << 6 | l3b & 0x3F;
                ++rtposn;
                byte r2b = rhs[rtposn];
                if ((res = lc2 - (rc = (rb & 0xF) << 12 | (r2b & 0x3F) << 6 | (r3b = rhs[++rtposn]) & 0x3F)) != 0 && (res = Character.toUpperCase(lc2) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + ltposn + " offset=" + lhsOffset + " width=" + lhsColumnWidth + " bytes=" + Arrays.toString(lhs));
        }
        if (lhsColumnWidth == rhsColumnWidth) {
            return 0;
        }
        if (lhsColumnWidth > rhsColumnWidth) {
            remainingLen = lhsColumnWidth + lhsOffset;
            return SQLChar.compareTrailingBlanks(lhs, ltposn, remainingLen, 1);
        }
        remainingLen = rhsColumnWidth + rhsOffset;
        return SQLChar.compareTrailingBlanks(rhs, rtposn, remainingLen, -1);
    }

    public static final int compareStringIgnoreCase(UnsafeWrapper unsafe, long lhsAddrOffset, int lhsColumnWidth, OffHeapByteSource lhs, long rhsAddrOffset, int rhsColumnWidth, OffHeapByteSource rhs) {
        int shorterLen = lhsColumnWidth < rhsColumnWidth ? lhsColumnWidth : rhsColumnWidth;
        long lhsEnd = lhsAddrOffset + (long)shorterLen;
        long rhsEnd = rhsAddrOffset + (long)shorterLen;
        long ltposn = lhsAddrOffset;
        long rtposn = rhsAddrOffset;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            byte l2b;
            int lc;
            byte lb = unsafe.getByte(ltposn);
            byte rb = unsafe.getByte(rtposn);
            if ((lb & 0x80) == 0) {
                if ((rb & 0x80) == 0) {
                    int rc;
                    int res = lb - rb;
                    if (res != 0 && (res = (lc = Character.toUpperCase(lb)) - (rc = Character.toUpperCase(rb))) != 0) {
                        return res;
                    }
                    ++ltposn;
                    ++rtposn;
                    continue;
                }
                return -1;
            }
            if ((lb & 0x60) == 64) {
                byte r2b;
                int rc;
                int res;
                if ((rb & 0x80) == 0) {
                    byte byeet = unsafe.getByte(++ltposn);
                    lc = (lb & 0x1F) << 6 | byeet & 0x3F;
                    int res2 = Character.toUpperCase(lc) - Character.toUpperCase(rb);
                    assert (res2 != 0) : "leftChar=" + Character.toString((char)lc) + ", rightChar=" + Character.toString((char)rb);
                    return res2;
                }
                if ((rb & 0x70) == 96) {
                    return -1;
                }
                if ((res = (lc = (lb & 0x1F) << 6 | (l2b = unsafe.getByte(++ltposn)) & 0x3F) - (rc = (rb & 0x1F) << 6 | (r2b = unsafe.getByte(++rtposn)) & 0x3F)) != 0 && (res = Character.toUpperCase(lc) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((lb & 0x70) == 96) {
                byte r3b;
                if ((rb & 0x80) == 0) {
                    return 1;
                }
                if ((rb & 0x60) == 64) {
                    return 1;
                }
                l2b = unsafe.getByte(++ltposn);
                byte l3b = unsafe.getByte(++ltposn);
                int lc2 = (lb & 0xF) << 12 | (l2b & 0x3F) << 6 | l3b & 0x3F;
                ++rtposn;
                byte r2b = unsafe.getByte(rtposn);
                int rc = (rb & 0xF) << 12 | (r2b & 0x3F) << 6 | (r3b = unsafe.getByte(++rtposn)) & 0x3F;
                int res = lc2 - rc;
                if (res != 0 && (res = Character.toUpperCase(lc2) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + ltposn + " offset=" + (lhsAddrOffset - lhs.getUnsafeAddress()) + " width=" + lhsColumnWidth + " bytes=" + Arrays.toString(lhs.getRowBytes()));
        }
        if (lhsColumnWidth == rhsColumnWidth) {
            return 0;
        }
        if (lhsColumnWidth > rhsColumnWidth) {
            long remainingLen = lhsAddrOffset + (long)lhsColumnWidth;
            return SQLChar.compareTrailingBlanks(unsafe, ltposn, remainingLen, 1, lhs);
        }
        long remainingLen = rhsAddrOffset + (long)rhsColumnWidth;
        return SQLChar.compareTrailingBlanks(unsafe, rtposn, remainingLen, -1, rhs);
    }

    public static final int compareStringIgnoreCase(UnsafeWrapper unsafe, byte[] lhs, int lhsOffset, int lhsColumnWidth, long rhsAddrOffset, int rhsColumnWidth, OffHeapByteSource rhs) {
        int shorterLen = lhsColumnWidth < rhsColumnWidth ? lhsColumnWidth : rhsColumnWidth;
        int lhsEnd = shorterLen + lhsOffset;
        int ltposn = lhsOffset;
        long rtposn = rhsAddrOffset;
        long rhsEnd = rtposn + (long)shorterLen;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            byte l2b;
            int lc;
            byte lb = lhs[ltposn];
            byte rb = unsafe.getByte(rtposn);
            if ((lb & 0x80) == 0) {
                if ((rb & 0x80) == 0) {
                    int rc;
                    int res = lb - rb;
                    if (res != 0 && (res = (lc = Character.toUpperCase(lb)) - (rc = Character.toUpperCase(rb))) != 0) {
                        return res;
                    }
                    ++ltposn;
                    ++rtposn;
                    continue;
                }
                return -1;
            }
            if ((lb & 0x60) == 64) {
                byte r2b;
                int rc;
                int res;
                if ((rb & 0x80) == 0) {
                    byte byeet = lhs[++ltposn];
                    lc = (lb & 0x1F) << 6 | byeet & 0x3F;
                    int res2 = Character.toUpperCase(lc) - Character.toUpperCase(rb);
                    assert (res2 != 0) : "leftChar=" + Character.toString((char)lc) + ", rightChar=" + Character.toString((char)rb);
                    return res2;
                }
                if ((rb & 0x70) == 96) {
                    return -1;
                }
                if ((res = (lc = (lb & 0x1F) << 6 | (l2b = lhs[++ltposn]) & 0x3F) - (rc = (rb & 0x1F) << 6 | (r2b = unsafe.getByte(++rtposn)) & 0x3F)) != 0 && (res = Character.toUpperCase(lc) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((lb & 0x70) == 96) {
                byte r3b;
                if ((rb & 0x80) == 0) {
                    return 1;
                }
                if ((rb & 0x60) == 64) {
                    return 1;
                }
                l2b = lhs[++ltposn];
                byte l3b = lhs[++ltposn];
                int lc2 = (lb & 0xF) << 12 | (l2b & 0x3F) << 6 | l3b & 0x3F;
                ++rtposn;
                byte r2b = unsafe.getByte(rtposn);
                int rc = (rb & 0xF) << 12 | (r2b & 0x3F) << 6 | (r3b = unsafe.getByte(++rtposn)) & 0x3F;
                int res = lc2 - rc;
                if (res != 0 && (res = Character.toUpperCase(lc2) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + ltposn + " offset=" + lhsOffset + " width=" + lhsColumnWidth + " bytes=" + Arrays.toString(lhs));
        }
        if (lhsColumnWidth == rhsColumnWidth) {
            return 0;
        }
        if (lhsColumnWidth > rhsColumnWidth) {
            int remainingLen = lhsColumnWidth + lhsOffset;
            return SQLChar.compareTrailingBlanks(lhs, ltposn, remainingLen, 1);
        }
        long remainingLen = rhsAddrOffset + (long)rhsColumnWidth;
        return SQLChar.compareTrailingBlanks(unsafe, rtposn, remainingLen, -1, rhs);
    }

    public static final int compareStringIgnoreCase(String lhs, byte[] rhs, int rhsOffset, int rhsColumnWidth) {
        int lhsEnd = lhs.length();
        int rhsEnd = rhsOffset + rhsColumnWidth;
        int ltposn = 0;
        int rtposn = rhsOffset;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            int res;
            char lc = lhs.charAt(ltposn);
            int rc = rhs[rtposn];
            if ((rc & 0x80) == 0) {
                if (lc != rc && (res = Character.toUpperCase((int)lc) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((rc & 0x60) == 64) {
                if (lc != (rc = (rc & 0x1F) << 6 | rhs[++rtposn] & 0x3F) && (res = Character.toUpperCase((int)lc) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((rc & 0x70) == 96) {
                int res2;
                byte rc3;
                ++rtposn;
                byte rc2 = rhs[rtposn];
                if (lc != (rc = (rc & 0xF) << 12 | (rc2 & 0x3F) << 6 | (rc3 = rhs[++rtposn]) & 0x3F) && (res2 = Character.toUpperCase((int)lc) - Character.toUpperCase(rc)) != 0) {
                    return res2;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + rtposn + " offset=" + rhsOffset + " width=" + rhsColumnWidth + " bytes=" + Arrays.toString(rhs));
        }
        if (ltposn == lhsEnd && rtposn == rhsEnd) {
            return 0;
        }
        if (ltposn < lhsEnd) {
            return SQLChar.compareTrailingBlanks(lhs, ltposn, lhsEnd, 1);
        }
        return SQLChar.compareTrailingBlanks(rhs, rtposn, rhsEnd, -1);
    }

    public static final int compareStringIgnoreCase(UnsafeWrapper unsafe, String lhs, long rhsAddrOffset, int rhsColumnWidth, OffHeapByteSource rhs) {
        int lhsEnd = lhs.length();
        long rtposn = rhsAddrOffset;
        long rhsEnd = rtposn + (long)rhsColumnWidth;
        int ltposn = 0;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            int res;
            char lc = lhs.charAt(ltposn);
            int rc = unsafe.getByte(rtposn);
            if ((rc & 0x80) == 0) {
                if (lc != rc && (res = Character.toUpperCase((int)lc) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((rc & 0x60) == 64) {
                if (lc != (rc = (rc & 0x1F) << 6 | unsafe.getByte(++rtposn) & 0x3F) && (res = Character.toUpperCase((int)lc) - Character.toUpperCase(rc)) != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((rc & 0x70) == 96) {
                int res2;
                byte rc3;
                ++rtposn;
                byte rc2 = unsafe.getByte(rtposn);
                if (lc != (rc = (rc & 0xF) << 12 | (rc2 & 0x3F) << 6 | (rc3 = unsafe.getByte(++rtposn)) & 0x3F) && (res2 = Character.toUpperCase((int)lc) - Character.toUpperCase(rc)) != 0) {
                    return res2;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + rtposn + " offset=" + (rhsAddrOffset - rhs.getUnsafeAddress()) + " width=" + rhsColumnWidth + " bytes=" + Arrays.toString(rhs.getRowBytes()));
        }
        if (ltposn == lhsEnd && rtposn == rhsEnd) {
            return 0;
        }
        if (ltposn < lhsEnd) {
            return SQLChar.compareTrailingBlanks(lhs, ltposn, lhsEnd, 1);
        }
        return SQLChar.compareTrailingBlanks(unsafe, rtposn, rhsEnd, -1, rhs);
    }

    static final int compareTrailingBlanks(byte[] bytes, int offset, int endPos, int retValSign) {
        for (int posn = offset; posn < endPos; ++posn) {
            char remainingChar;
            byte c = bytes[posn];
            if ((c & 0x80) == 0) {
                remainingChar = (char)c;
            } else if ((c & 0x60) == 64) {
                remainingChar = (char)((c & 0x1F) << 6 | bytes[++posn] & 0x3F);
            } else if ((c & 0x70) == 96) {
                byte char2 = bytes[++posn];
                byte char3 = bytes[++posn];
                remainingChar = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
            } else {
                throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + posn + " offset=" + offset + " bytes=" + Arrays.toString(bytes));
            }
            if (remainingChar == ' ') {
                continue;
            }
            return (remainingChar - 32) * retValSign;
        }
        return 0;
    }

    static final int compareTrailingBlanks(UnsafeWrapper unsafe, long offset, long endPos, int retValSign, OffHeapByteSource bytes) {
        for (long posn = offset; posn < endPos; ++posn) {
            char remainingChar;
            byte c = unsafe.getByte(posn);
            if ((c & 0x80) == 0) {
                remainingChar = (char)c;
            } else if ((c & 0x60) == 64) {
                remainingChar = (char)((c & 0x1F) << 6 | unsafe.getByte(++posn) & 0x3F);
            } else if ((c & 0x70) == 96) {
                byte char2 = unsafe.getByte(++posn);
                byte char3 = unsafe.getByte(++posn);
                remainingChar = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
            } else {
                throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + posn + " offset=" + offset + " bytes=" + Arrays.toString(bytes.getRowBytes()));
            }
            if (remainingChar == ' ') {
                continue;
            }
            return (remainingChar - 32) * retValSign;
        }
        return 0;
    }

    static final int compareTrailingBlanks(String s, int posn, int endPos, int retValSign) {
        while (posn < endPos) {
            char lc = s.charAt(posn);
            if (lc == ' ') {
                ++posn;
                continue;
            }
            return (lc - 32) * retValSign;
        }
        return 0;
    }

    public static final int compareString(byte[] lhs, int lhsOffset, int lhsColumnWidth, byte[] rhs, int rhsOffset, int rhsColumnWidth) {
        int remainingLen;
        int shorterLen = lhsColumnWidth < rhsColumnWidth ? lhsColumnWidth : rhsColumnWidth;
        int lhsEnd = shorterLen + lhsOffset;
        int rhsEnd = shorterLen + rhsOffset;
        int ltposn = lhsOffset;
        int rtposn = rhsOffset;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            int res;
            byte lb = lhs[ltposn];
            byte rb = rhs[rtposn];
            if ((lb & 0x80) == 0) {
                if ((rb & 0x80) == 0) {
                    int res2 = lb - rb;
                    if (res2 != 0) {
                        return res2;
                    }
                    ++ltposn;
                    ++rtposn;
                    continue;
                }
                return -1;
            }
            if ((lb & 0x60) == 64) {
                byte r2b;
                byte l2b;
                if ((rb & 0x80) == 0) {
                    byte byeet = lhs[++ltposn];
                    int ac = (lb & 0x1F) << 6 | byeet & 0x3F;
                    return ac - rb;
                }
                if ((rb & 0x70) == 96) {
                    return -1;
                }
                if ((res = (l2b = lhs[++ltposn]) - (r2b = rhs[++rtposn])) != 0) {
                    return res;
                }
                res = lb - rb;
                if (res != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((lb & 0x70) == 96) {
                if ((rb & 0x80) == 0) {
                    return 1;
                }
                if ((rb & 0x60) == 64) {
                    return 1;
                }
                byte l3b = lhs[ltposn += 2];
                byte r3b = rhs[rtposn += 2];
                res = l3b - r3b;
                if (res != 0) {
                    return res;
                }
                byte l2b = lhs[ltposn - 1];
                byte r2b = rhs[rtposn - 1];
                res = l2b - r2b;
                if (res != 0) {
                    return res;
                }
                if (lb != rb) {
                    return lb - rb;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + ltposn + " offset=" + lhsOffset + " width=" + lhsColumnWidth + " bytes=" + Arrays.toString(lhs));
        }
        if (lhsColumnWidth == rhsColumnWidth) {
            return 0;
        }
        if (lhsColumnWidth > rhsColumnWidth) {
            remainingLen = lhsColumnWidth + lhsOffset;
            return SQLChar.compareTrailingBlanks(lhs, ltposn, remainingLen, 1);
        }
        remainingLen = rhsColumnWidth + rhsOffset;
        return SQLChar.compareTrailingBlanks(rhs, rtposn, remainingLen, -1);
    }

    public static final int compareString(UnsafeWrapper unsafe, long lhsAddrOffset, int lhsColumnWidth, OffHeapByteSource lhs, long rhsAddrOffset, int rhsColumnWidth, OffHeapByteSource rhs) {
        int shorterLen = lhsColumnWidth < rhsColumnWidth ? lhsColumnWidth : rhsColumnWidth;
        long lhsEnd = lhsAddrOffset + (long)shorterLen;
        long rhsEnd = rhsAddrOffset + (long)shorterLen;
        long ltposn = lhsAddrOffset;
        long rtposn = rhsAddrOffset;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            int res;
            byte lb = unsafe.getByte(ltposn);
            byte rb = unsafe.getByte(rtposn);
            if ((lb & 0x80) == 0) {
                if ((rb & 0x80) == 0) {
                    int res2 = lb - rb;
                    if (res2 != 0) {
                        return res2;
                    }
                    ++ltposn;
                    ++rtposn;
                    continue;
                }
                return -1;
            }
            if ((lb & 0x60) == 64) {
                byte r2b;
                byte l2b;
                if ((rb & 0x80) == 0) {
                    byte byeet = unsafe.getByte(++ltposn);
                    int ac = (lb & 0x1F) << 6 | byeet & 0x3F;
                    return ac - rb;
                }
                if ((rb & 0x70) == 96) {
                    return -1;
                }
                if ((res = (l2b = unsafe.getByte(++ltposn)) - (r2b = unsafe.getByte(++rtposn))) != 0) {
                    return res;
                }
                res = lb - rb;
                if (res != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((lb & 0x70) == 96) {
                byte r2b;
                byte r3b;
                if ((rb & 0x80) == 0) {
                    return 1;
                }
                if ((rb & 0x60) == 64) {
                    return 1;
                }
                byte l3b = unsafe.getByte(ltposn += 2L);
                res = l3b - (r3b = unsafe.getByte(rtposn += 2L));
                if (res != 0) {
                    return res;
                }
                byte l2b = unsafe.getByte(ltposn - 1L);
                res = l2b - (r2b = unsafe.getByte(rtposn - 1L));
                if (res != 0) {
                    return res;
                }
                if (lb != rb) {
                    return lb - rb;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + ltposn + " offset=" + (lhsAddrOffset - lhs.getUnsafeAddress()) + " width=" + lhsColumnWidth + " bytes=" + Arrays.toString(lhs.getRowBytes()));
        }
        if (lhsColumnWidth == rhsColumnWidth) {
            return 0;
        }
        if (lhsColumnWidth > rhsColumnWidth) {
            long remainingLen = lhsAddrOffset + (long)lhsColumnWidth;
            return SQLChar.compareTrailingBlanks(unsafe, ltposn, remainingLen, 1, lhs);
        }
        long remainingLen = rhsAddrOffset + (long)rhsColumnWidth;
        return SQLChar.compareTrailingBlanks(unsafe, rtposn, remainingLen, -1, rhs);
    }

    public static final int compareString(UnsafeWrapper unsafe, byte[] lhs, int lhsOffset, int lhsColumnWidth, long rhsAddrOffset, int rhsColumnWidth, OffHeapByteSource rhs) {
        int shorterLen = lhsColumnWidth < rhsColumnWidth ? lhsColumnWidth : rhsColumnWidth;
        int lhsEnd = shorterLen + lhsOffset;
        long rhsEnd = rhsAddrOffset + (long)shorterLen;
        int ltposn = lhsOffset;
        long rtposn = rhsAddrOffset;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            int res;
            byte lb = lhs[ltposn];
            byte rb = unsafe.getByte(rtposn);
            if ((lb & 0x80) == 0) {
                if ((rb & 0x80) == 0) {
                    int res2 = lb - rb;
                    if (res2 != 0) {
                        return res2;
                    }
                    ++ltposn;
                    ++rtposn;
                    continue;
                }
                return -1;
            }
            if ((lb & 0x60) == 64) {
                byte r2b;
                byte l2b;
                if ((rb & 0x80) == 0) {
                    byte byeet = lhs[++ltposn];
                    int ac = (lb & 0x1F) << 6 | byeet & 0x3F;
                    return ac - rb;
                }
                if ((rb & 0x70) == 96) {
                    return -1;
                }
                if ((res = (l2b = lhs[++ltposn]) - (r2b = unsafe.getByte(++rtposn))) != 0) {
                    return res;
                }
                res = lb - rb;
                if (res != 0) {
                    return res;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((lb & 0x70) == 96) {
                if ((rb & 0x80) == 0) {
                    return 1;
                }
                if ((rb & 0x60) == 64) {
                    return 1;
                }
                byte l3b = lhs[ltposn += 2];
                byte r3b = unsafe.getByte(rtposn += 2L);
                res = l3b - r3b;
                if (res != 0) {
                    return res;
                }
                byte l2b = lhs[ltposn - 1];
                byte r2b = unsafe.getByte(rtposn - 1L);
                res = l2b - r2b;
                if (res != 0) {
                    return res;
                }
                if (lb != rb) {
                    return lb - rb;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + ltposn + " offset=" + lhsOffset + " width=" + lhsColumnWidth + " bytes=" + Arrays.toString(lhs));
        }
        if (lhsColumnWidth == rhsColumnWidth) {
            return 0;
        }
        if (lhsColumnWidth > rhsColumnWidth) {
            int remainingLen = lhsColumnWidth + lhsOffset;
            return SQLChar.compareTrailingBlanks(lhs, ltposn, remainingLen, 1);
        }
        long remainingLen = rhsAddrOffset + (long)rhsColumnWidth;
        return SQLChar.compareTrailingBlanks(unsafe, rtposn, remainingLen, -1, rhs);
    }

    public static final int compareString(String lhs, byte[] rhs, int rhsOffset, int rhsColumnWidth) {
        int lhsEnd = lhs.length();
        int rhsEnd = rhsOffset + rhsColumnWidth;
        int ltposn = 0;
        int rtposn = rhsOffset;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            char lc = lhs.charAt(ltposn);
            int rc = rhs[rtposn];
            if ((rc & 0x80) == 0) {
                if (lc != rc) {
                    return lc - rc;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((rc & 0x60) == 64) {
                if (lc != (rc = (rc & 0x1F) << 6 | rhs[++rtposn] & 0x3F)) {
                    return lc - rc;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((rc & 0x70) == 96) {
                byte rc3;
                ++rtposn;
                byte rc2 = rhs[rtposn];
                if (lc != (rc = (rc & 0xF) << 12 | (rc2 & 0x3F) << 6 | (rc3 = rhs[++rtposn]) & 0x3F)) {
                    return lc - rc;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + rtposn + " offset=" + rhsOffset + " width=" + rhsColumnWidth + " bytes=" + Arrays.toString(rhs));
        }
        if (ltposn == lhsEnd && rtposn == rhsEnd) {
            return 0;
        }
        if (ltposn < lhsEnd) {
            return SQLChar.compareTrailingBlanks(lhs, ltposn, lhsEnd, 1);
        }
        return SQLChar.compareTrailingBlanks(rhs, rtposn, rhsEnd, -1);
    }

    public static final int compareString(UnsafeWrapper unsafe, String lhs, long rhsAddrOffset, int rhsColumnWidth, OffHeapByteSource rhs) {
        int lhsEnd = lhs.length();
        long rtposn = rhsAddrOffset;
        long rhsEnd = rtposn + (long)rhsColumnWidth;
        int ltposn = 0;
        while (ltposn < lhsEnd && rtposn < rhsEnd) {
            char lc = lhs.charAt(ltposn);
            int rc = unsafe.getByte(rtposn);
            if ((rc & 0x80) == 0) {
                if (lc != rc) {
                    return lc - rc;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((rc & 0x60) == 64) {
                if (lc != (rc = (rc & 0x1F) << 6 | unsafe.getByte(++rtposn) & 0x3F)) {
                    return lc - rc;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            if ((rc & 0x70) == 96) {
                byte rc3;
                ++rtposn;
                byte rc2 = unsafe.getByte(rtposn);
                if (lc != (rc = (rc & 0xF) << 12 | (rc2 & 0x3F) << 6 | (rc3 = unsafe.getByte(++rtposn)) & 0x3F)) {
                    return lc - rc;
                }
                ++ltposn;
                ++rtposn;
                continue;
            }
            throw new GemFireXDRuntimeException("UTFDataFormatException: posn=" + rtposn + " offset=" + (rhsAddrOffset - rhs.getUnsafeAddress(0, 1)) + " width=" + rhsColumnWidth + " bytes=" + Arrays.toString(rhs.getRowBytes()));
        }
        if (ltposn == lhsEnd && rtposn == rhsEnd) {
            return 0;
        }
        if (ltposn < lhsEnd) {
            return SQLChar.compareTrailingBlanks(lhs, ltposn, lhsEnd, 1);
        }
        return SQLChar.compareTrailingBlanks(unsafe, rtposn, rhsEnd, -1, rhs);
    }

    static final String getAsString(byte[] inBytes, int offset, int columnWidth, DataTypeDescriptor dtd) {
        char[] chars;
        int strlen;
        int size = dtd.getMaximumWidth();
        if (size > (strlen = SQLChar.readIntoCharsFromByteArray(inBytes, offset, columnWidth, chars = new char[size]))) {
            SQLChar.appendBlanks(chars, strlen, size - strlen);
        }
        return ClientSharedUtils.newWrappedString((char[])chars, (int)0, (int)size);
    }

    static final String getAsString(long memOffset, int columnWidth, OffHeapByteSource bs, DataTypeDescriptor dtd) {
        int size = dtd.getMaximumWidth();
        char[] chars = new char[size];
        int strlen = SQLChar.readIntoCharsFromByteSource(UnsafeHolder.getUnsafe(), memOffset, columnWidth, bs, chars);
        if (size > strlen) {
            SQLChar.appendBlanks(chars, strlen, size - strlen);
        }
        return ClientSharedUtils.newWrappedString((char[])chars, (int)0, (int)size);
    }

    static final GemFireXDRuntimeException utf8FormatException(byte[] inBytes, byte b, int startOffset, int offset, int columnWidth) {
        return new GemFireXDRuntimeException("UTFDataFormatException: offset=" + startOffset + " currentOffset=" + offset + " b=" + b + " columnWidth=" + columnWidth + " bytes=" + Arrays.toString(inBytes));
    }

    static final void writeAsUTF8String(byte[] inBytes, int startOffset, int columnWidth, int maxWidth, ByteArrayDataOutput buffer) {
        if (columnWidth <= 0) {
            return;
        }
        int bufPos = buffer.ensureCapacity(maxWidth + columnWidth, buffer.position());
        byte[] bufBytes = buffer.getData();
        boolean[] isNormal = IS_NORMAL_ASCII_CHAR;
        int offset = startOffset;
        int endOffset = startOffset + columnWidth;
        while (true) {
            int b;
            if ((b = inBytes[offset]) >= 0 && isNormal[b]) {
                bufBytes[bufPos] = b;
                if (++offset >= endOffset) break;
                ++bufPos;
                continue;
            }
            int v = IS_NON_ASCII_OR_SPECIAL_PXF_CHAR[b & 0xFF];
            if (v == 1) {
                bufBytes[bufPos] = 92;
                bufBytes[++bufPos] = b == 10 ? 110 : b;
            } else if (v == 2) {
                bufBytes[bufPos] = b;
                bufBytes[++bufPos] = inBytes[++offset];
            } else if (v == 3) {
                bufBytes[bufPos] = b;
                bufBytes[++bufPos] = inBytes[++offset];
                bufBytes[++bufPos] = inBytes[++offset];
            } else {
                throw SQLChar.utf8FormatException(inBytes, (byte)b, startOffset, offset, columnWidth);
            }
            if (++offset >= endOffset) break;
            ++bufPos;
        }
        buffer.advance(bufPos - buffer.position());
    }

    static final void writeAsUTF8String(UnsafeWrapper unsafe, long memOffset, int columnWidth, int maxWidth, OffHeapByteSource bs, ByteArrayDataOutput buffer) {
        if (columnWidth <= 0) {
            return;
        }
        buffer.ensureCapacity(maxWidth, buffer.position());
        boolean[] isNormal = IS_NORMAL_ASCII_CHAR;
        long bsOffset = memOffset;
        long bsEndOffset = memOffset + (long)columnWidth;
        while (true) {
            byte b;
            if ((b = unsafe.getByte(bsOffset)) >= 0 && isNormal[b]) {
                buffer.write(b);
                if (++bsOffset >= bsEndOffset) break;
                continue;
            }
            int v = IS_NON_ASCII_OR_SPECIAL_PXF_CHAR[b & 0xFF];
            if (v == 1) {
                buffer.write(92);
                if (b == 10) {
                    buffer.write(110);
                } else {
                    buffer.write(b);
                }
            } else if (v == 2) {
                buffer.write(b);
                buffer.write(unsafe.getByte(++bsOffset));
            } else if (v == 3) {
                buffer.write(b);
                buffer.write(unsafe.getByte(++bsOffset));
                buffer.write(unsafe.getByte(++bsOffset));
            } else {
                long bsAddr = bs.getUnsafeAddress();
                throw SQLChar.utf8FormatException(bs.getRowBytes(), b, (int)(memOffset - bsAddr), (int)(bsOffset - bsAddr), columnWidth);
            }
            if (++bsOffset >= bsEndOffset) break;
        }
    }

    static void writeAsUTF8String(byte[] inBytes, int startOffset, int columnWidth, DataTypeDescriptor dtd, ByteArrayDataOutput buffer) {
        int maxWidth = dtd.getMaximumWidth();
        if (maxWidth < columnWidth) {
            maxWidth = columnWidth;
        }
        SQLChar.writeAsUTF8String(inBytes, startOffset, columnWidth, maxWidth, buffer);
        if (maxWidth > columnWidth) {
            SQLChar.appendBlanks(buffer, maxWidth - columnWidth);
        }
    }

    static void writeAsUTF8String(UnsafeWrapper unsafe, long memOffset, int columnWidth, OffHeapByteSource bs, DataTypeDescriptor dtd, ByteArrayDataOutput buffer) {
        int maxWidth = dtd.getMaximumWidth();
        if (maxWidth < columnWidth) {
            maxWidth = columnWidth;
        }
        SQLChar.writeAsUTF8String(unsafe, memOffset, columnWidth, maxWidth, bs, buffer);
        if (maxWidth > columnWidth) {
            SQLChar.appendBlanks(buffer, maxWidth - columnWidth);
        }
    }

    @Override
    public byte getTypeId() {
        return 27;
    }

    static {
        int i;
        BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLChar.class);
        BLANKS = new char[40];
        BLANKSB = new byte[40];
        for (i = 0; i < BLANKS.length; ++i) {
            SQLChar.BLANKS[i] = 32;
        }
        for (i = 0; i < BLANKSB.length; ++i) {
            SQLChar.BLANKSB[i] = 32;
        }
        IS_NORMAL_ASCII_CHAR = new boolean[128];
        IS_NON_ASCII_OR_SPECIAL_PXF_CHAR = new int[256];
        for (int c = 0; c < 256; ++c) {
            if ((c & 0x80) == 0) {
                if (c != 92 && c != 44 && c != 10 && c != 13) {
                    SQLChar.IS_NORMAL_ASCII_CHAR[c] = true;
                    SQLChar.IS_NON_ASCII_OR_SPECIAL_PXF_CHAR[c] = 0;
                    continue;
                }
                SQLChar.IS_NON_ASCII_OR_SPECIAL_PXF_CHAR[c] = 1;
                continue;
            }
            SQLChar.IS_NON_ASCII_OR_SPECIAL_PXF_CHAR[c] = (c & 0x60) == 64 ? 2 : ((c & 0x70) == 96 ? 3 : -1);
        }
    }
}

