/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.internal.offheap.ByteSource;
import com.gemstone.gemfire.internal.offheap.UnsafeMemoryChunk;
import com.gemstone.gemfire.pdx.internal.unsafe.UnsafeWrapper;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.DerbyIOException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.BitDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.BooleanDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.ConcatableDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLBoolean;
import com.pivotal.gemfirexd.internal.iapi.types.SQLInteger;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarbit;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.shared.common.ResolverUtils;
import io.snappydata.thrift.common.BufferedBlob;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.SQLException;

abstract class SQLBinary
extends DataType
implements BitDataValue {
    static final byte PAD = 32;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(SQLBinary.class);
    Blob _blobValue;
    byte[] dataValue;

    @Override
    public int estimateMemoryUsage() {
        if (this.dataValue == null) {
            return BASE_MEMORY_USAGE;
        }
        return BASE_MEMORY_USAGE + this.dataValue.length;
    }

    abstract int getMaxMemoryUsage();

    SQLBinary() {
    }

    SQLBinary(byte[] val) {
        this.dataValue = val;
    }

    SQLBinary(Blob val) throws StandardException {
        this.setValue(val);
    }

    @Override
    public final void setValue(byte[] theValue) {
        this.dataValue = theValue;
        this._blobValue = null;
    }

    @Override
    public final void setValue(Blob theValue) throws StandardException {
        this.dataValue = null;
        this._blobValue = theValue;
    }

    @Override
    public final String getString() throws StandardException {
        if (this.getValue() == null) {
            return null;
        }
        if (this.dataValue.length * 2 < 0) {
            throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)MessageService.getTextMessage("BIN01", String.valueOf(this.dataValue.length)), (Object)String.valueOf(Integer.MAX_VALUE));
        }
        return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
    }

    @Override
    public final InputStream getStream() throws StandardException {
        return null;
    }

    @Override
    public final byte[] getBytes() throws StandardException {
        return this.getValue();
    }

    @Override
    public Object getObject() throws StandardException {
        return this.getValue();
    }

    final byte[] getValue() throws StandardException {
        try {
            return this.getValueAsBytes();
        }
        catch (SQLException sqle) {
            throw Misc.wrapSQLException(sqle, sqle);
        }
    }

    final byte[] getValueAsBytes() throws SQLException {
        if (this.dataValue == null && this._blobValue != null) {
            this.dataValue = this._blobValue.getBytes(1L, this.getBlobLength());
            this._blobValue = null;
        }
        return this.dataValue;
    }

    @Override
    public final int getLength() throws StandardException {
        try {
            if (this._blobValue != null) {
                return this.getBlobLength();
            }
        }
        catch (SQLException sqle) {
            throw Misc.wrapSQLException(sqle, sqle);
        }
        byte[] bytes = this.getBytes();
        return bytes == null ? 0 : bytes.length;
    }

    private void throwStreamingIOException(IOException ioe) throws StandardException {
        DerbyIOException dioe;
        if (ioe instanceof DerbyIOException && (dioe = (DerbyIOException)ioe).getSQLState() != null) {
            throw StandardException.newPreLocalizedException(dioe.getSQLState(), dioe, dioe.getLocalizedMessage());
        }
        throw StandardException.newException("XCL30.S", (Throwable)ioe, (Object)this.getTypeName());
    }

    @Override
    public final boolean isNull() {
        return this.dataValue == null && this._blobValue == null;
    }

    @Override
    public final void writeExternal(ObjectOutput out) throws IOException {
        if (this._blobValue != null) {
            this.writeBlob(out);
            return;
        }
        int len = this.dataValue.length;
        this.writeLength(out, len);
        out.write(this.dataValue, 0, this.dataValue.length);
    }

    private void writeBlob(ObjectOutput out) throws IOException {
        try {
            int len = this.getBlobLength();
            InputStream is = this._blobValue.getBinaryStream();
            this.writeLength(out, len);
            for (int i = 0; i < len; ++i) {
                out.write(is.read());
            }
        }
        catch (SQLException se) {
            throw new IOException(se.getMessage());
        }
    }

    private void writeLength(ObjectOutput out, int len) throws IOException {
        if (len <= 31) {
            out.write((byte)(0x80 | len & 0xFF));
        } else if (len <= 65535) {
            out.write(-96);
            out.writeShort((short)len);
        } else {
            out.write(-64);
            out.writeInt(len);
        }
    }

    @Override
    public final void readExternal(ObjectInput in) throws IOException {
        this._blobValue = null;
        int len = SQLBinary.readBinaryLength(in);
        if (len != 0) {
            this.dataValue = new byte[len];
            in.readFully(this.dataValue);
        } else {
            this.readFromStream((InputStream)((Object)in));
        }
    }

    @Override
    public final void readExternalFromArray(ArrayInputStream in) throws IOException {
        this._blobValue = null;
        int len = SQLBinary.readBinaryLength(in);
        if (len != 0) {
            this.dataValue = new byte[len];
            in.readFully(this.dataValue);
        } else {
            this.readFromStream(in);
        }
    }

    private static int readBinaryLength(ObjectInput in) throws IOException {
        int len;
        int bl = in.read();
        if (bl == -1) {
            throw new EOFException();
        }
        byte li = (byte)bl;
        if ((li & 0xFFFFFF80) != 0) {
            len = li == -64 ? in.readInt() : (li == -96 ? in.readUnsignedShort() : li & 0x1F);
        } else {
            int v2 = in.read();
            int v3 = in.read();
            int v4 = in.read();
            if (v2 == -1 || v3 == -1 || v4 == -1) {
                throw new EOFException();
            }
            int lenInBits = (bl & 0xFF) << 24 | (v2 & 0xFF) << 16 | (v3 & 0xFF) << 8 | v4 & 0xFF;
            len = lenInBits / 8;
            if (lenInBits % 8 != 0) {
                ++len;
            }
        }
        return len;
    }

    private void readFromStream(InputStream in) throws IOException {
        int len;
        this.dataValue = null;
        byte[] tmpData = new byte[32768];
        int off = 0;
        while ((len = in.read(tmpData, off, tmpData.length - off)) != -1) {
            int available = Math.max(1, in.available());
            int extraSpace = available - (tmpData.length - (off += len));
            if (extraSpace <= 0) continue;
            int size = tmpData.length * 2;
            if (extraSpace > tmpData.length) {
                size += extraSpace;
            }
            byte[] grow = new byte[size];
            System.arraycopy(tmpData, 0, grow, 0, off);
            tmpData = grow;
        }
        this.dataValue = new byte[off];
        System.arraycopy(tmpData, 0, this.dataValue, 0, off);
    }

    @Override
    public final void restoreToNull() {
        this.dataValue = null;
        this._blobValue = null;
    }

    @Override
    public final boolean compare(int op, DataValueDescriptor other, boolean orderedNulls, boolean unknownRV) throws StandardException {
        if (!orderedNulls) {
            int otherTypeFormatId = other.getTypeFormatId();
            if (87 != otherTypeFormatId && 88 != otherTypeFormatId && 234 != otherTypeFormatId && 78 != otherTypeFormatId && 85 != otherTypeFormatId && 235 != otherTypeFormatId && (443 != otherTypeFormatId || 443 != this.getTypeFormatId())) {
                SanityManager.THROWASSERT((String)("Some fool passed in a " + other.getClass().getName() + ", " + otherTypeFormatId + " to SQLBinary.compare()"));
            }
            String otherString = other.getString();
            if (this.getString() == null || otherString == null) {
                return unknownRV;
            }
        }
        return super.compare(op, other, orderedNulls, unknownRV);
    }

    @Override
    public final int compare(DataValueDescriptor other) throws StandardException {
        if (this.typePrecedence() < other.typePrecedence()) {
            return -Integer.signum(other.compare(this));
        }
        if (this.isNull() || other.isNull()) {
            if (!this.isNull()) {
                return -1;
            }
            if (!other.isNull()) {
                return 1;
            }
            return 0;
        }
        return SQLBinary.compare(this.getBytes(), other.getBytes());
    }

    @Override
    public final Object cloneObject() {
        if (this._blobValue != null) {
            SQLBinary self = (SQLBinary)this.getNewNull();
            self._blobValue = this._blobValue;
            self.dataValue = null;
            return self;
        }
        return this.getClone();
    }

    @Override
    public final DataValueDescriptor getClone() {
        try {
            DataValueDescriptor cloneDVD = this.getNewNull();
            if (this._blobValue != null) {
                cloneDVD.setValue(this._blobValue);
            } else {
                cloneDVD.setValue(this.dataValue);
            }
            return cloneDVD;
        }
        catch (StandardException se) {
            throw GemFireXDRuntimeException.newRuntimeException("Unexpected exception", se);
        }
    }

    @Override
    public final InputStream returnStream() {
        return null;
    }

    @Override
    public final void setStream(InputStream newStream) throws StandardException {
        this.dataValue = null;
        this._blobValue = null;
        try {
            if (newStream instanceof FormatIdInputStream) {
                this.readExternal((FormatIdInputStream)newStream);
            } else {
                this.readExternal(new FormatIdInputStream(newStream));
            }
        }
        catch (IOException ioe) {
            this.throwStreamingIOException(ioe);
        }
    }

    @Override
    public final void loadStream() throws StandardException {
        this.getValue();
    }

    boolean objectNull(Object o) {
        if (o == null) {
            this.setToNull();
            return true;
        }
        return false;
    }

    @Override
    public final void setValue(InputStream theStream, int valueLength) throws StandardException {
        this.setStream(theStream);
    }

    @Override
    protected final void setFrom(DataValueDescriptor theValue) throws StandardException {
        if (theValue instanceof SQLBinary) {
            SQLBinary theValueBinary = (SQLBinary)theValue;
            Blob blob = theValueBinary._blobValue;
            if (blob != null && !(blob instanceof BufferedBlob)) {
                this.setValue(theValueBinary.getBytes());
                return;
            }
            this.dataValue = theValueBinary.dataValue;
            this._blobValue = theValueBinary._blobValue;
        } else {
            this.setValue(theValue.getBytes());
        }
    }

    @Override
    public final BooleanDataValue equals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isEqual = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) == 0;
        return SQLBoolean.truthValue(left, right, isEqual);
    }

    @Override
    public final BooleanDataValue notEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isNotEqual = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) != 0;
        return SQLBoolean.truthValue(left, right, isNotEqual);
    }

    @Override
    public final BooleanDataValue lessThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isLessThan = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) < 0;
        return SQLBoolean.truthValue(left, right, isLessThan);
    }

    @Override
    public final BooleanDataValue greaterThan(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isGreaterThan = false;
        isGreaterThan = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) > 0;
        return SQLBoolean.truthValue(left, right, isGreaterThan);
    }

    @Override
    public final BooleanDataValue lessOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isLessEquals = false;
        isLessEquals = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) <= 0;
        return SQLBoolean.truthValue(left, right, isLessEquals);
    }

    @Override
    public final BooleanDataValue greaterOrEquals(DataValueDescriptor left, DataValueDescriptor right) throws StandardException {
        boolean isGreaterEquals = false;
        isGreaterEquals = left.isNull() || right.isNull() ? false : SQLBinary.compare(left.getBytes(), right.getBytes()) >= 0;
        return SQLBoolean.truthValue(left, right, isGreaterEquals);
    }

    @Override
    public final NumberDataValue charLength(NumberDataValue result) throws StandardException {
        if (result == null) {
            result = new SQLInteger();
        }
        if (this.isNull()) {
            result.setToNull();
            return result;
        }
        result.setValue(this.getValue().length);
        return result;
    }

    @Override
    public final BitDataValue concatenate(BitDataValue left, BitDataValue right, BitDataValue result) throws StandardException {
        if (left.isNull() || right.isNull()) {
            result.setToNull();
            return result;
        }
        byte[] leftData = left.getBytes();
        byte[] rightData = right.getBytes();
        byte[] concatData = new byte[leftData.length + rightData.length];
        System.arraycopy(leftData, 0, concatData, 0, leftData.length);
        System.arraycopy(rightData, 0, concatData, leftData.length, rightData.length);
        result.setValue(concatData);
        return result;
    }

    @Override
    public final ConcatableDataValue substring(NumberDataValue start, NumberDataValue length, ConcatableDataValue result, int maxLen) throws StandardException {
        if (result == null) {
            result = new SQLVarbit();
        }
        BitDataValue varbitResult = (BitDataValue)result;
        if (this.isNull() || start.isNull() || length != null && length.isNull()) {
            varbitResult.setToNull();
            return varbitResult;
        }
        int startInt = start.getInt();
        int lengthInt = length != null ? length.getInt() : this.getLength() - startInt + 1;
        if (startInt <= 0 || lengthInt < 0 || startInt > this.getLength() || lengthInt > this.getLength() - startInt + 1) {
            throw StandardException.newException("22011");
        }
        if (lengthInt < 0) {
            varbitResult.setToNull();
            return varbitResult;
        }
        if (startInt < 0) {
            if ((startInt += this.getLength()) < 0) {
                lengthInt += startInt;
                startInt = 0;
            }
            lengthInt = lengthInt + startInt > 0 ? (lengthInt += startInt) : 0;
        } else if (startInt > 0) {
            --startInt;
        }
        if (lengthInt == 0 || lengthInt <= 0 - startInt || startInt > this.getLength()) {
            varbitResult.setValue(new byte[0]);
            return varbitResult;
        }
        if (lengthInt >= this.getLength() - startInt) {
            byte[] substring = new byte[this.dataValue.length - startInt];
            System.arraycopy(this.dataValue, startInt, substring, 0, substring.length);
            varbitResult.setValue(substring);
        } else {
            byte[] substring = new byte[lengthInt];
            System.arraycopy(this.dataValue, startInt, substring, 0, substring.length);
            varbitResult.setValue(substring);
        }
        return varbitResult;
    }

    @Override
    public final void checkHostVariable(int declaredLength) throws StandardException {
        int variableLength = -1;
        if (this._blobValue != null) {
            variableLength = -1;
        } else if (this.dataValue != null) {
            variableLength = this.dataValue.length;
        }
        if (variableLength != -1 && variableLength > declaredLength) {
            throw StandardException.newException("22001", (Object)this.getTypeName(), (Object)MessageService.getTextMessage("BIN01", String.valueOf(variableLength)), (Object)String.valueOf(declaredLength));
        }
    }

    public String toString() {
        if (this.dataValue == null) {
            if (this._blobValue == null) {
                return "NULL";
            }
            try {
                this.loadStream();
                return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
            }
            catch (StandardException e) {
                throw GemFireXDRuntimeException.newRuntimeException(null, e);
            }
        }
        return StringUtil.toHexString(this.dataValue, 0, this.dataValue.length);
    }

    public final int hashCode() {
        try {
            if (this.getValue() == null) {
                return 0;
            }
        }
        catch (StandardException se) {
            SanityManager.THROWASSERT((String)"Unexpected exception", (Throwable)se);
            return 0;
        }
        byte[] bytes = this.dataValue;
        int hashcode = 0;
        for (int index = 0; index < bytes.length; ++index) {
            byte bv = bytes[index];
            if (bv == 32) continue;
            hashcode += bytes[index];
        }
        return hashcode;
    }

    private static int compare(byte[] left, byte[] right) {
        int i;
        int minLen = left.length;
        byte[] longer = right;
        if (right.length < minLen) {
            minLen = right.length;
            longer = left;
        }
        for (i = 0; i < minLen; ++i) {
            int lb = left[i] & 0xFF;
            int rb = right[i] & 0xFF;
            if (lb == rb) continue;
            return lb - rb;
        }
        for (i = minLen; i < longer.length; ++i) {
            byte nb = longer[i];
            if (nb == 32) continue;
            if (left == longer) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    @Override
    public void setInto(PreparedStatement ps, int position) throws SQLException, StandardException {
        ps.setBytes(position, this.getBytes());
    }

    @Override
    public final String getTraceString() throws StandardException {
        if (this.isNull()) {
            return "NULL";
        }
        if (this.getStream() != null) {
            return this.getTypeName() + "(" + this.getStream().toString() + ")";
        }
        return this.getTypeName() + ":Length=" + this.getLength();
    }

    private int getBlobLength() throws SQLException {
        long length = this._blobValue.length();
        if (length > Integer.MAX_VALUE) {
            throw Util.generateCsSQLException("XJ093.S", (Object)Long.toString(length), Long.toString(Integer.MAX_VALUE));
        }
        return (int)length;
    }

    @Override
    public final void toData(DataOutput out) throws IOException {
        if (!this.isNull()) {
            byte[] value;
            try {
                value = this.getValueAsBytes();
            }
            catch (SQLException sqle) {
                throw GemFireXDRuntimeException.newRuntimeException(null, sqle);
            }
            out.writeByte(46);
            out.writeShort(this.getTypeFormatId());
            DataSerializer.writeByteArray((byte[])value, (int)value.length, (DataOutput)out);
            return;
        }
        out.writeByte(41);
        out.writeByte(46);
        out.writeShort(this.getTypeFormatId());
    }

    @Override
    public final void fromDataForOptimizedResultHolder(DataInput dis) throws IOException, ClassNotFoundException {
        this.dataValue = DataSerializer.readByteArray((DataInput)dis);
    }

    @Override
    public final void toDataForOptimizedResultHolder(DataOutput dos) throws IOException {
        byte[] value;
        assert (!this.isNull());
        try {
            value = this.getValueAsBytes();
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, sqle);
        }
        DataSerializer.writeByteArray((byte[])value, (int)value.length, (DataOutput)dos);
    }

    @Override
    public int readBytes(byte[] inBytes, int offset, int columnWidth) {
        this.dataValue = new byte[columnWidth];
        System.arraycopy(inBytes, offset, this.dataValue, 0, columnWidth);
        return columnWidth;
    }

    @Override
    public int readBytes(long memOffset, int columnWidth, ByteSource bs) {
        this.dataValue = new byte[columnWidth];
        UnsafeMemoryChunk.readUnsafeBytes((long)memOffset, (byte[])this.dataValue, (int)columnWidth);
        return columnWidth;
    }

    @Override
    public int writeBytes(byte[] outBytes, int offset, DataTypeDescriptor dtd) {
        byte[] value;
        try {
            value = this.getValueAsBytes();
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, sqle);
        }
        System.arraycopy(value, 0, outBytes, offset, value.length);
        return value.length;
    }

    @Override
    public int computeHashCode(int maxWidth, int hash) {
        byte[] value;
        assert (!this.isNull());
        try {
            value = this.getValueAsBytes();
        }
        catch (SQLException sqle) {
            throw GemFireXDRuntimeException.newRuntimeException(null, sqle);
        }
        return ResolverUtils.addBytesToBucketHash((byte[])value, (int)hash, (int)this.getTypeFormatId());
    }

    static final byte[] getAsBytes(byte[] inBytes, int offset, int columnWidth) {
        if (offset == 0 && columnWidth == inBytes.length) {
            return inBytes;
        }
        byte[] data = new byte[columnWidth];
        System.arraycopy(inBytes, offset, data, 0, columnWidth);
        return data;
    }

    static final byte[] getAsBytes(UnsafeWrapper unsafe, long memOffset, int columnWidth) {
        byte[] data = new byte[columnWidth];
        UnsafeMemoryChunk.readUnsafeBytes((long)memOffset, (byte[])data, (int)columnWidth);
        return data;
    }
}

