/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.types;

import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.DerbyIOException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;

public final class ReaderToUTF8Stream
extends InputStream {
    private LimitReader reader;
    private byte[] buffer;
    private int boff;
    private int blen;
    private boolean eof;
    private boolean multipleBuffer;
    private static final int BUFSIZE = 32768;
    private final int charsToTruncate;
    private static final char SPACE = ' ';
    private final int valueLength;
    private final int maximumLength;
    private final String typeName;

    public ReaderToUTF8Stream(Reader appReader, int valueLength, int numCharsToTruncate, String typeName) {
        this.reader = new LimitReader(appReader);
        this.reader.setLimit(valueLength);
        this.buffer = new byte[32768];
        this.blen = -1;
        this.charsToTruncate = numCharsToTruncate;
        this.valueLength = valueLength;
        this.maximumLength = -1;
        this.typeName = typeName;
    }

    public ReaderToUTF8Stream(Reader appReader, int maximumLength, String typeName) {
        if (maximumLength < 0) {
            throw new IllegalArgumentException("Maximum length for a capped stream cannot be negative: " + maximumLength);
        }
        if (typeName == null) {
            throw new IllegalArgumentException("Type name cannot be null");
        }
        this.reader = new LimitReader(appReader);
        this.reader.setLimit(maximumLength);
        this.buffer = new byte[32768];
        this.blen = -1;
        this.maximumLength = maximumLength;
        this.typeName = typeName;
        this.charsToTruncate = -1;
        this.valueLength = -1;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.blen < 0) {
            this.fillBuffer(2);
        }
        while (this.boff == this.blen) {
            if (this.eof) {
                this.close();
                return -1;
            }
            this.fillBuffer(0);
        }
        return this.buffer[this.boff++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.buffer == null) {
            throw new EOFException(MessageService.getTextMessage("XJ085.S"));
        }
        if (this.blen < 0) {
            this.fillBuffer(2);
        }
        int readCount = 0;
        while (len > 0) {
            int copyBytes = this.blen - this.boff;
            if (copyBytes == 0) {
                if (this.eof) {
                    if (readCount > 0) {
                        return readCount;
                    }
                    this.close();
                    return -1;
                }
                this.fillBuffer(0);
                continue;
            }
            if (len < copyBytes) {
                copyBytes = len;
            }
            System.arraycopy(this.buffer, this.boff, b, off, copyBytes);
            this.boff += copyBytes;
            len -= copyBytes;
            readCount += copyBytes;
            off += copyBytes;
        }
        return readCount;
    }

    private void fillBuffer(int startingOffset) throws IOException {
        this.boff = startingOffset;
        int off = this.boff;
        if (off == 0) {
            this.multipleBuffer = true;
        }
        while (off <= this.buffer.length - 6) {
            int c = this.reader.read();
            if (c < 0) {
                this.eof = true;
                break;
            }
            if (c >= 1 && c <= 127) {
                this.buffer[off++] = (byte)c;
                continue;
            }
            if (c > 2047) {
                this.buffer[off++] = (byte)(0xE0 | c >> 12 & 0xF);
                this.buffer[off++] = (byte)(0x80 | c >> 6 & 0x3F);
                this.buffer[off++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            this.buffer[off++] = (byte)(0xC0 | c >> 6 & 0x1F);
            this.buffer[off++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        this.blen = off;
        this.boff = 0;
        if (this.eof) {
            this.checkSufficientData();
        }
    }

    private void checkSufficientData() throws IOException {
        int remainingBytes;
        if (this.charsToTruncate > 0) {
            this.reader.setLimit(this.charsToTruncate);
            this.truncate();
        }
        if ((remainingBytes = this.reader.clearLimit()) > 0 && this.valueLength > 0) {
            throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
        }
        if (remainingBytes == 0 && this.reader.read() >= 0) {
            if (this.valueLength > -1) {
                throw new DerbyIOException(MessageService.getTextMessage("XJ023.S"), "XJ023.S");
            }
            if (this.canTruncate()) {
                this.truncate();
            } else {
                throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, MessageService.getTextMessage("BIN01", String.valueOf(this.valueLength)), String.valueOf(this.maximumLength)), "22001");
            }
        }
        if (!this.multipleBuffer) {
            int utflen = this.blen - 2;
            this.buffer[0] = (byte)(utflen >>> 8 & 0xFF);
            this.buffer[1] = (byte)(utflen >>> 0 & 0xFF);
        } else {
            this.buffer[this.blen++] = -32;
            this.buffer[this.blen++] = 0;
            this.buffer[this.blen++] = 0;
        }
    }

    private boolean canTruncate() {
        if (this.typeName.equals("CLOB")) {
            return true;
        }
        return this.typeName.equals("VARCHAR");
    }

    private void truncate() throws IOException {
        int c = 0;
        while ((c = this.reader.read()) >= 0) {
            if (c == 32) continue;
            throw new DerbyIOException(MessageService.getTextMessage("22001", this.typeName, MessageService.getTextMessage("BIN01", String.valueOf(this.valueLength)), String.valueOf(this.maximumLength)), "22001");
        }
    }

    @Override
    public void close() throws IOException {
        this.buffer = null;
    }

    @Override
    public final int available() {
        int remainingBytes = this.reader.getLimit();
        return 32768 > remainingBytes ? remainingBytes : 32768;
    }
}

