/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.transaction;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.transaction.TransactionListener;
import java.util.ArrayList;
import java.util.Iterator;

public final class TransactionControl {
    private final ArrayList listeners = new ArrayList();

    public void addListener(TransactionListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TransactionListener listener) {
        this.listeners.remove(listener);
    }

    public void preCommitNotify() throws StandardException {
        if (this.listeners.isEmpty()) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            TransactionListener listener = (TransactionListener)i.next();
            try {
                if (!listener.preCommit()) continue;
                i.remove();
            }
            catch (StandardException se) {
                if (se.getSeverity() < 30000) {
                    throw StandardException.newException("40XT1", se);
                }
                throw se;
            }
        }
    }

    public void preRollbackNotify() throws StandardException {
        if (this.listeners.isEmpty()) {
            return;
        }
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            TransactionListener listener = (TransactionListener)i.next();
            try {
                listener.preRollback();
                i.remove();
            }
            catch (StandardException se) {
                if (se.getSeverity() < 30000) {
                    // empty if block
                }
                throw se;
            }
        }
    }
}

