/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.iapi.sql.dictionary;

import com.pivotal.gemfirexd.internal.catalog.DependableFinder;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DDdependableFinder;

public class RoutinePermsDescriptor
extends PermissionsDescriptor {
    private UUID routineUUID;
    private String routineName;
    private boolean hasExecutePermission;

    public RoutinePermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID routineUUID, boolean hasExecutePermission) throws StandardException {
        super(dd, grantee, grantor);
        this.routineUUID = routineUUID;
        this.hasExecutePermission = hasExecutePermission;
        if (routineUUID != null) {
            this.routineName = dd.getAliasDescriptor(routineUUID).getObjectName();
        }
    }

    public RoutinePermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID routineUUID) throws StandardException {
        this(dd, grantee, grantor, routineUUID, true);
    }

    public RoutinePermsDescriptor(DataDictionary dd, String grantee, String grantor) throws StandardException {
        this(dd, grantee, grantor, null);
    }

    public RoutinePermsDescriptor(DataDictionary dd, UUID routineePermsUUID) throws StandardException {
        this(dd, null, null, null, true);
        this.oid = routineePermsUUID;
    }

    @Override
    public int getCatalogNumber() {
        return 18;
    }

    public UUID getRoutineUUID() {
        return this.routineUUID;
    }

    public boolean getHasExecutePermission() {
        return this.hasExecutePermission;
    }

    public String toString() {
        return "routinePerms: grantee=" + this.getGrantee() + ",routinePermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",ldapGroup=" + this.getLdapGroup() + ",routineUUID=" + this.getRoutineUUID();
    }

    public boolean equals(Object other) {
        if (!(other instanceof RoutinePermsDescriptor)) {
            return false;
        }
        RoutinePermsDescriptor otherRoutinePerms = (RoutinePermsDescriptor)other;
        return super.keyEquals(otherRoutinePerms) && this.routineUUID.equals(otherRoutinePerms.routineUUID);
    }

    public int hashCode() {
        return super.keyHashCode() + this.routineUUID.hashCode();
    }

    @Override
    public boolean checkOwner(String authorizationId) throws StandardException {
        UUID uuid = this.getDataDictionary().getAliasDescriptor(this.routineUUID).getSchemaUUID();
        SchemaDescriptor sd = this.getDataDictionary().getSchemaDescriptor(uuid, null);
        String schemaOwner = sd.getAuthorizationId();
        return schemaOwner.equals(authorizationId) || Misc.checkLDAPGroupOwnership(sd.getSchemaName(), schemaOwner, authorizationId);
    }

    @Override
    public String getObjectName() {
        return "Routine Privilege on " + this.routineName;
    }

    @Override
    public String getClassType() {
        return "RoutinePrivilege";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return new DDdependableFinder(461);
    }
}

